<?php

namespace Kotchasan\Http;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2016-02-19 at 13:56:09.
 */
class RequestTest extends \PHPUnit_Framework_TestCase
{

    public function requestFactory()
    {
        $_SESSION = $_POST = $_COOKIE = $_GET = array(
            'a' => 'A',
            'test' => "ทด\"สอบ",
            array(
                'a' => 'A',
                'test' => "ทด\"สอบ")
        );
        $_FILES = array(
            'upload' => array(
                'tmp_name' => array(
                    'my-avatar-txt',
                    'my-avatar-jpg',
                ),
                'name' => array(
                    'my-avatar.txt',
                    'my-avatar.jpg',
                ),
                'size' => array(
                    8,
                    8
                ),
                'type' => array(
                    'text/plain',
                    'image/jpg'
                ),
                'error' => array(
                    0,
                    0
                )
            )
        );
        return new Request;
    }

    public function testGetQueryParams()
    {
        foreach ($this->requestFactory()->getQueryParams() as $key => $value) {
            $this->assertEquals($_GET[$key], $value);
        }
    }

    public function testGetServerParams()
    {
        foreach ($this->requestFactory()->getServerParams() as $key => $value) {
            if ($key == 'REQUEST_TIME' || $key == 'REQUEST_TIME_FLOAT') {
                $this->assertGreaterThanOrEqual($_SERVER[$key], $value);
            } else {
                $this->assertEquals($_SERVER[$key], $value);
            }
        }
    }

    public function testGetCookieParams()
    {
        foreach ($this->requestFactory()->getCookieParams() as $key => $value) {
            $this->assertEquals($_COOKIE[$key], $value);
        }
    }

    public function testWithCookieParams()
    {
        $request = $this->requestFactory();
        $clone = $request->withCookieParams(array('type' => 'framework'));
        $this->assertEquals(array('type' => 'framework'), $clone->getCookieParams());
    }

    public function testWithQueryParams()
    {
        $_SERVER['QUERY_STRING'] = 'abc=123';
        $request = $this->requestFactory();
        $clone = $request->withQueryParams(array('foo' => 'bar'));
        $cloneUri = $clone->getUri();
        $this->assertEquals('abc=123', $cloneUri->getQuery()); // <-- Unchanged
        $this->assertAttributeEquals(array('foo' => 'bar'), 'queryParams', $clone); // <-- Changed
    }

    public function testGetParsedBody()
    {
        foreach ($this->requestFactory()->getParsedBody() as $key => $value) {
            $this->assertEquals($_POST[$key], $value);
        }
    }

    public function testWithParsedBody()
    {
        $clone = $this->requestFactory()->withParsedBody(array('xyz' => '123'));
        $this->assertAttributeEquals(array('xyz' => '123'), 'parsedBody', $clone);
    }

    public function testGetUploadedFiles()
    {
        foreach ($this->requestFactory()->getUploadedFiles() as $name => $file) {
            $this->assertEquals(0, $file->getError());
        }
    }

    public function testWithUploadedFiles()
    {
        $files = array(new UploadedFile('tmp', 'foo.txt'), new UploadedFile('tmp', 'bar.txt'));
        $request = $this->requestFactory();
        $clone = $request->withUploadedFiles($files);
        $this->assertEquals($files, $clone->getUploadedFiles());
    }

    public function testGetAttributes()
    {
        foreach ($this->requestFactory()->withAttribute('test', 123)->getAttributes() as $key => $value) {
            $this->assertEquals('test', $key);
            $this->assertEquals(123, $value);
        }
    }

    public function testAttribute()
    {
        $request = $this->requestFactory();
        $clone = $request->withAttribute('test', '123');
        $this->assertEquals('123', $clone->getAttribute('test'));
        $this->assertNull($request->getAttribute('bar'));
        $clone2 = $clone->withoutAttribute('test');
        $this->assertNull($clone2->getAttribute('test'));
    }

    public function testGet()
    {
        $this->assertEquals('ทด"สอบ', $this->requestFactory()->get('test')->toString());
    }

    public function testPost()
    {
        $this->assertEquals('ทด"สอบ', $this->requestFactory()->post('test')->toString());
    }

    public function testRequest()
    {
        $this->assertEquals('ทด"สอบ', $this->requestFactory()->request('test')->toString());
    }

    public function testSession()
    {
        $this->assertEquals('ทด"สอบ', $this->requestFactory()->session('test')->toString());
    }

    public function testSetSession()
    {
        $request = $this->requestFactory();
        $this->assertEquals('ทด"สอบ', $request->session('test')->toString());
        $request->setSession('test', 'testSetSession');
        $this->assertEquals('testSetSession', $request->session('test')->toString());
    }

    public function testCookie()
    {
        $this->assertEquals('ทด"สอบ', $this->requestFactory()->cookie('test')->toString());
    }

    public function testGetClientIp()
    {
        $_SERVER = array(
            'REMOTE_ADDR' => '192.168.1.1'
        );
        $this->assertEquals('192.168.1.1', $this->requestFactory()->getClientIp());
    }

    public function testGetIpIfMissing()
    {
        unset($_SERVER['REMOTE_ADDR']);
        $this->assertNull($this->requestFactory()->getClientIp());
    }

    public function testGetForwardedIp()
    {
        $_SERVER = array(
            'HTTP_X_FORWARDED_FOR' => '192.168.1.3, 192.168.1.2, 192.168.1.1'
        );
        $this->assertEquals('192.168.1.3', $this->requestFactory()->getClientIp());
    }

    public function testIsReferer()
    {
        $_SERVER = array(
            'HTTP_HOST' => 'domain.tld',
            'HTTP_REFERER' => 'http://domain.tld/index.php?id=1'
        );
        $this->assertTrue($this->requestFactory()->isReferer());
    }

    public function testIsSafe()
    {
        $_SERVER = array(
            'HTTP_HOST' => 'domain.tld',
            'HTTP_REFERER' => 'http://domain.tld/index.php?id=1'
        );
        $request = $this->requestFactory();
        $_POST['token'] = $request->createToken();
        $i = 0;
        while ($request->isSafe()) {
            $i++;
        }
        $this->assertEquals(TOKEN_LIMIT, $i);
    }
}