<?php

namespace Kotchasan;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2022-12-05 at 19:11:23.
 */
class DateTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var Date
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->object = new Date();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {

    }

    /**
     * Generated from @assert (mktime(0, 0, 0, 2, 1, 2016), mktime(0, 0, 0, 3, 1, 2016)) [==]  array('days' => 29, 'year' => 0,'month' => 0, 'day' => 29).
     *
     * @covers Kotchasan\Date::compare
     */
    public function testCompare()
    {

        $this->assertEquals(
            array('days' => 29, 'year' => 0, 'month' => 0, 'day' => 29),
            \Kotchasan\Date::compare(mktime(0, 0, 0, 2, 1, 2016), mktime(0, 0, 0, 3, 1, 2016))
        );
    }

    /**
     * Generated from @assert ('2016-3-1', '2016-2-1') [==]  array('days' => -29, 'year' => 0,'month' => 0, 'day' => 29).
     *
     * @covers Kotchasan\Date::compare
     */
    public function testCompare2()
    {

        $this->assertEquals(
            array('days' => -29, 'year' => 0, 'month' => 0, 'day' => 29),
            \Kotchasan\Date::compare('2016-3-1', '2016-2-1')
        );
    }

    /**
     * Generated from @assert ('08:00', '09:00') [==] 3600.
     *
     * @covers Kotchasan\Date::timeDiff
     */
    public function testTimeDiff()
    {

        $this->assertEquals(
            3600,
            \Kotchasan\Date::timeDiff('08:00', '09:00')
        );
    }

    /**
     * Generated from @assert (0) [==] 'อา.'.
     *
     * @covers Kotchasan\Date::dateName
     */
    public function testDateName()
    {

        $this->assertEquals(
            'อา.',
            \Kotchasan\Date::dateName(0)
        );
    }

    /**
     * Generated from @assert (0, false) [==] 'อาทิตย์'.
     *
     * @covers Kotchasan\Date::dateName
     */
    public function testDateName2()
    {

        $this->assertEquals(
            'อาทิตย์',
            \Kotchasan\Date::dateName(0, false)
        );
    }

    /**
     * Generated from @assert (0, 'y-m-d H:i:s') [==]  date('y-m-d H:i:s').
     *
     * @covers Kotchasan\Date::format
     */
    public function testFormat()
    {

        $this->assertEquals(
            date('y-m-d H:i:s'),
                 \Kotchasan\Date::format(0, 'y-m-d H:i:s')
        );
    }

    /**
     * Generated from @assert (null) [==]  ''.
     *
     * @covers Kotchasan\Date::format
     */
    public function testFormat2()
    {

        $this->assertEquals(
            '',
            \Kotchasan\Date::format(null)
        );
    }

    /**
     * Generated from @assert (1454259600, 'Y-m-d H:i:s') [==] '2559-02-01 00:00:00'.
     *
     * @covers Kotchasan\Date::format
     */
    public function testFormat3()
    {

        $this->assertEquals(
            '2559-02-01 00:00:00',
            \Kotchasan\Date::format(1454259600, 'Y-m-d H:i:s')
        );
    }

    /**
     * Generated from @assert (1) [==] 'ม.ค.'.
     *
     * @covers Kotchasan\Date::monthName
     */
    public function testMonthName()
    {

        $this->assertEquals(
            'ม.ค.',
            \Kotchasan\Date::monthName(1)
        );
    }

    /**
     * Generated from @assert (1, false) [==] 'มกราคม'.
     *
     * @covers Kotchasan\Date::monthName
     */
    public function testMonthName2()
    {

        $this->assertEquals(
            'มกราคม',
            \Kotchasan\Date::monthName(1, false)
        );
    }
}