<?php

namespace Kotchasan;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2022-12-22 at 21:24:27.
 */
class CurrencyTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var Currency
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->object = new Currency();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {

    }

    /**
     * Generated from @assert (13.00) [==] 'thirteen Baht'.
     *
     * @covers Kotchasan\Currency::bahtEng
     */
    public function testBahtEng()
    {

        $this->assertEquals(
            'thirteen Baht',
            \Kotchasan\Currency::bahtEng(13.00)
        );
    }

    /**
     * Generated from @assert (101.55) [==] 'one hundred one Baht and fifty-five Satang'.
     *
     * @covers Kotchasan\Currency::bahtEng
     */
    public function testBahtEng2()
    {

        $this->assertEquals(
            'one hundred one Baht and fifty-five Satang',
            \Kotchasan\Currency::bahtEng(101.55)
        );
    }

    /**
     * Generated from @assert (1234.56) [==] 'one thousand two hundred thirty-four Baht and fifty-six Satang'.
     *
     * @covers Kotchasan\Currency::bahtEng
     */
    public function testBahtEng3()
    {

        $this->assertEquals(
            'one thousand two hundred thirty-four Baht and fifty-six Satang',
            \Kotchasan\Currency::bahtEng(1234.56)
        );
    }

    /**
     * Generated from @assert (12345.67) [==] 'twelve thousand three hundred forty-five Baht and sixty-seven Satang'.
     *
     * @covers Kotchasan\Currency::bahtEng
     */
    public function testBahtEng4()
    {

        $this->assertEquals(
            'twelve thousand three hundred forty-five Baht and sixty-seven Satang',
            \Kotchasan\Currency::bahtEng(12345.67)
        );
    }

    /**
     * Generated from @assert (-1000000050) [==] 'negative one billion fifty Baht'.
     *
     * @covers Kotchasan\Currency::bahtEng
     */
    public function testBahtEng5()
    {

        $this->assertEquals(
            'negative one billion fifty Baht',
            \Kotchasan\Currency::bahtEng(-1000000050)
        );
    }

    /**
     * Generated from @assert (1416921) [==] 'one million four hundred sixteen thousand nine hundred twenty-one Baht'.
     *
     * @covers Kotchasan\Currency::bahtEng
     */
    public function testBahtEng6()
    {

        $this->assertEquals(
            'one million four hundred sixteen thousand nine hundred twenty-one Baht',
            \Kotchasan\Currency::bahtEng(1416921)
        );
    }

    /**
     * Generated from @assert (269346000.00) [==] 'two hundred sixty-nine million three hundred forty-six thousand Baht'.
     *
     * @covers Kotchasan\Currency::bahtEng
     */
    public function testBahtEng7()
    {

        $this->assertEquals(
            'two hundred sixty-nine million three hundred forty-six thousand Baht',
            \Kotchasan\Currency::bahtEng(269346000.00)
        );
    }

    /**
     * Generated from @assert (1000000000.00) [==] 'one billion Baht'.
     *
     * @covers Kotchasan\Currency::bahtEng
     */
    public function testBahtEng8()
    {

        $this->assertEquals(
            'one billion Baht',
            \Kotchasan\Currency::bahtEng(1000000000.00)
        );
    }

    /**
     * Generated from @assert (10000000050.25) [==] 'ten billion fifty Baht and twenty-five Satang'.
     *
     * @covers Kotchasan\Currency::bahtEng
     */
    public function testBahtEng9()
    {

        $this->assertEquals(
            'ten billion fifty Baht and twenty-five Satang',
            \Kotchasan\Currency::bahtEng(10000000050.25)
        );
    }

    /**
     * Generated from @assert (100000000000.00) [==] 'one hundred billion Baht'.
     *
     * @covers Kotchasan\Currency::bahtEng
     */
    public function testBahtEng10()
    {

        $this->assertEquals(
            'one hundred billion Baht',
            \Kotchasan\Currency::bahtEng(100000000000.00)
        );
    }

    /**
     * Generated from @assert (1000000000000) [==] 'one trillion Baht'.
     *
     * @covers Kotchasan\Currency::bahtEng
     */
    public function testBahtEng11()
    {

        $this->assertEquals(
            'one trillion Baht',
            \Kotchasan\Currency::bahtEng(1000000000000)
        );
    }

    /**
     * Generated from @assert (999999999999999) [==] 'nine hundred ninety-nine trillion nine hundred ninety-nine billion nine hundred ninety-nine million nine hundred ninety-nine thousand nine hundred ninety-nine Baht'.
     *
     * @covers Kotchasan\Currency::bahtEng
     */
    public function testBahtEng12()
    {

        $this->assertEquals(
            'nine hundred ninety-nine trillion nine hundred ninety-nine billion nine hundred ninety-nine million nine hundred ninety-nine thousand nine hundred ninety-nine Baht',
            \Kotchasan\Currency::bahtEng(999999999999999)
        );
    }

    /**
     * Generated from @assert (1000000000000000500) [==] 'one thousand quadrillion five hundred Baht'.
     *
     * @covers Kotchasan\Currency::bahtEng
     */
    public function testBahtEng13()
    {

        $this->assertEquals(
            'one thousand quadrillion five hundred Baht',
            \Kotchasan\Currency::bahtEng(1000000000000000500)
        );
    }

    /**
     * Generated from @assert (13.00) [==] 'สิบสามบาทถ้วน'.
     *
     * @covers Kotchasan\Currency::bahtThai
     */
    public function testBahtThai()
    {

        $this->assertEquals(
            'สิบสามบาทถ้วน',
            \Kotchasan\Currency::bahtThai(13.00)
        );
    }

    /**
     * Generated from @assert (101.55) [==] 'หนึ่งร้อยเอ็ดบาทห้าสิบห้าสตางค์'.
     *
     * @covers Kotchasan\Currency::bahtThai
     */
    public function testBahtThai2()
    {

        $this->assertEquals(
            'หนึ่งร้อยเอ็ดบาทห้าสิบห้าสตางค์',
            \Kotchasan\Currency::bahtThai(101.55)
        );
    }

    /**
     * Generated from @assert (1234.56) [==] 'หนึ่งพันสองร้อยสามสิบสี่บาทห้าสิบหกสตางค์'.
     *
     * @covers Kotchasan\Currency::bahtThai
     */
    public function testBahtThai3()
    {

        $this->assertEquals(
            'หนึ่งพันสองร้อยสามสิบสี่บาทห้าสิบหกสตางค์',
            \Kotchasan\Currency::bahtThai(1234.56)
        );
    }

    /**
     * Generated from @assert (12345.67) [==] 'หนึ่งหมื่นสองพันสามร้อยสี่สิบห้าบาทหกสิบเจ็ดสตางค์'.
     *
     * @covers Kotchasan\Currency::bahtThai
     */
    public function testBahtThai4()
    {

        $this->assertEquals(
            'หนึ่งหมื่นสองพันสามร้อยสี่สิบห้าบาทหกสิบเจ็ดสตางค์',
            \Kotchasan\Currency::bahtThai(12345.67)
        );
    }

    /**
     * Generated from @assert (-1000000050) [==] 'ลบหนึ่งพันล้านห้าสิบบาทถ้วน'.
     *
     * @covers Kotchasan\Currency::bahtThai
     */
    public function testBahtThai5()
    {

        $this->assertEquals(
            'ลบหนึ่งพันล้านห้าสิบบาทถ้วน',
            \Kotchasan\Currency::bahtThai(-1000000050)
        );
    }

    /**
     * Generated from @assert (1416921) [==] 'หนึ่งล้านสี่แสนหนึ่งหมื่นหกพันเก้าร้อยยี่สิบเอ็ดบาทถ้วน'.
     *
     * @covers Kotchasan\Currency::bahtThai
     */
    public function testBahtThai6()
    {

        $this->assertEquals(
            'หนึ่งล้านสี่แสนหนึ่งหมื่นหกพันเก้าร้อยยี่สิบเอ็ดบาทถ้วน',
            \Kotchasan\Currency::bahtThai(1416921)
        );
    }

    /**
     * Generated from @assert (269346000.00) [==] 'สองร้อยหกสิบเก้าล้านสามแสนสี่หมื่นหกพันบาทถ้วน'.
     *
     * @covers Kotchasan\Currency::bahtThai
     */
    public function testBahtThai7()
    {

        $this->assertEquals(
            'สองร้อยหกสิบเก้าล้านสามแสนสี่หมื่นหกพันบาทถ้วน',
            \Kotchasan\Currency::bahtThai(269346000.00)
        );
    }

    /**
     * Generated from @assert (1000000000.00) [==] 'หนึ่งพันล้านบาทถ้วน'.
     *
     * @covers Kotchasan\Currency::bahtThai
     */
    public function testBahtThai8()
    {

        $this->assertEquals(
            'หนึ่งพันล้านบาทถ้วน',
            \Kotchasan\Currency::bahtThai(1000000000.00)
        );
    }

    /**
     * Generated from @assert (10000000050.25) [==] 'หนึ่งหมื่นล้านห้าสิบบาทยี่สิบห้าสตางค์'.
     *
     * @covers Kotchasan\Currency::bahtThai
     */
    public function testBahtThai9()
    {

        $this->assertEquals(
            'หนึ่งหมื่นล้านห้าสิบบาทยี่สิบห้าสตางค์',
            \Kotchasan\Currency::bahtThai(10000000050.25)
        );
    }

    /**
     * Generated from @assert (100000000000.00) [==] 'หนึ่งแสนล้านบาทถ้วน'.
     *
     * @covers Kotchasan\Currency::bahtThai
     */
    public function testBahtThai10()
    {

        $this->assertEquals(
            'หนึ่งแสนล้านบาทถ้วน',
            \Kotchasan\Currency::bahtThai(100000000000.00)
        );
    }

    /**
     * Generated from @assert (1000000000000) [==] 'หนึ่งล้านล้านบาทถ้วน'.
     *
     * @covers Kotchasan\Currency::bahtThai
     */
    public function testBahtThai11()
    {

        $this->assertEquals(
            'หนึ่งล้านล้านบาทถ้วน',
            \Kotchasan\Currency::bahtThai(1000000000000)
        );
    }

    /**
     * Generated from @assert (1000, 7, true) [==] 70.
     *
     * @covers Kotchasan\Currency::calcVat
     */
    public function testCalcVat()
    {

        $this->assertEquals(
            70,
            \Kotchasan\Currency::calcVat(1000, 7, true)
        );
    }

    /**
     * Generated from @assert (1000, 7, false) [==] 65.420560747663558.
     *
     * @covers Kotchasan\Currency::calcVat
     */
    public function testCalcVat2()
    {

        $this->assertEquals(
            65.420560747663558,
            \Kotchasan\Currency::calcVat(1000, 7, false)
        );
    }

    /**
     * Generated from @assert (1000000.444) [==] '1,000,000.44'.
     *
     * @covers Kotchasan\Currency::format
     */
    public function testFormat()
    {

        $this->assertEquals(
            '1,000,000.44',
            \Kotchasan\Currency::format(1000000.444)
        );
    }

    /**
     * Generated from @assert (1000000.555) [==] '1,000,000.56'.
     *
     * @covers Kotchasan\Currency::format
     */
    public function testFormat2()
    {

        $this->assertEquals(
            '1,000,000.56',
            \Kotchasan\Currency::format(1000000.555)
        );
    }

    /**
     * Generated from @assert (1000000.55455, 3, ',', false) [==] '1,000,000.554'.
     *
     * @covers Kotchasan\Currency::format
     */
    public function testFormat3()
    {

        $this->assertEquals(
            '1,000,000.554',
            \Kotchasan\Currency::format(1000000.55455, 3, ',', false)
        );
    }

    /**
     * Generated from @assert (1000000.55455, 3) [==] '1,000,000.555'.
     *
     * @covers Kotchasan\Currency::format
     */
    public function testFormat4()
    {

        $this->assertEquals(
            '1,000,000.555',
            \Kotchasan\Currency::format(1000000.55455, 3)
        );
    }
}