<?php

namespace Kotchasan;

/**
 * Generated by PHPUnit_SkeletonGenerator on 2024-03-21 at 15:15:08.
 */
class ArrayToolTest extends \PHPUnit_Framework_TestCase
{
    /**
     * @var ArrayTool
     */
    protected $object;

    /**
     * Sets up the fixture, for example, opens a network connection.
     * This method is called before a test is executed.
     */
    protected function setUp()
    {
        $this->object = new ArrayTool();
    }

    /**
     * Tears down the fixture, for example, closes a network connection.
     * This method is called after a test is executed.
     */
    protected function tearDown()
    {

    }

    /**
     * Generated from @assert (array((object)array('id' => 1, 'name' => 'one'), (object)array('id' => 2, 'name' => 'two'), array('id' => 3, 'name' => 'three')), 'name') [==] array(0 => 'one', 1 => 'two', 2 => 'three').
     *
     * @covers Kotchasan\ArrayTool::columns
     */
    public function testColumns()
    {

        $this->assertEquals(
            array(0 => 'one', 1 => 'two', 2 => 'three'),
            \Kotchasan\ArrayTool::columns(array((object)array('id' => 1, 'name' => 'one'), (object)array('id' => 2, 'name' => 'two'), array('id' => 3, 'name' => 'three')), 'name')
        );
    }

    /**
     * Generated from @assert (array((object)array('id' => 1, 'name' => 'one'), (object)array('id' => 2, 'name' => 'two'), array('id' => 3, 'name' => 'three')), 'name', 'id') [==] array(1 => 'one', 2 => 'two', 3 => 'three').
     *
     * @covers Kotchasan\ArrayTool::columns
     */
    public function testColumns2()
    {

        $this->assertEquals(
            array(1 => 'one', 2 => 'two', 3 => 'three'),
            \Kotchasan\ArrayTool::columns(array((object)array('id' => 1, 'name' => 'one'), (object)array('id' => 2, 'name' => 'two'), array('id' => 3, 'name' => 'three')), 'name', 'id')
        );
    }

    /**
     * Generated from @assert (array(array('id' => 1, 'name' => 'one'), array('id' => 2, 'name' => 'two'), array('id' => 3, 'name' => 'three')), 'name') [==] array(0 => 'one', 1 => 'two', 2 => 'three').
     *
     * @covers Kotchasan\ArrayTool::columns
     */
    public function testColumns3()
    {

        $this->assertEquals(
            array(0 => 'one', 1 => 'two', 2 => 'three'),
            \Kotchasan\ArrayTool::columns(array(array('id' => 1, 'name' => 'one'), array('id' => 2, 'name' => 'two'), array('id' => 3, 'name' => 'three')), 'name')
        );
    }

    /**
     * Generated from @assert (array(array('id' => 1, 'name' => 'one'), array('id' => 2, 'name' => 'two'), array('id' => 3, 'name' => 'three')), 'name', 'id') [==] array(1 => 'one', 2 => 'two', 3 => 'three').
     *
     * @covers Kotchasan\ArrayTool::columns
     */
    public function testColumns4()
    {

        $this->assertEquals(
            array(1 => 'one', 2 => 'two', 3 => 'three'),
            \Kotchasan\ArrayTool::columns(array(array('id' => 1, 'name' => 'one'), array('id' => 2, 'name' => 'two'), array('id' => 3, 'name' => 'three')), 'name', 'id')
        );
    }

    /**
     * Generated from @assert ((object)array(array('id' => 1, 'name' => 'one'), array('id' => 2, 'name' => 'two'), array('id' => 3, 'name' => 'three')), 'name', 'id') [==] array(1 => 'one', 2 => 'two', 3 => 'three').
     *
     * @covers Kotchasan\ArrayTool::columns
     */
    public function testColumns5()
    {

        $this->assertEquals(
            array(1 => 'one', 2 => 'two', 3 => 'three'),
            \Kotchasan\ArrayTool::columns((object)array(array('id' => 1, 'name' => 'one'), array('id' => 2, 'name' => 'two'), array('id' => 3, 'name' => 'three')), 'name', 'id')
        );
    }

    /**
     * Generated from @assert (array(0, 1, 2, 3, 4, 5), '0,2') [==] array(1 => 1, 3 => 3, 4 => 4, 5 => 5).
     *
     * @covers Kotchasan\ArrayTool::delete
     */
    public function testDelete()
    {

        $this->assertEquals(
            array(1 => 1, 3 => 3, 4 => 4, 5 => 5),
            \Kotchasan\ArrayTool::delete(array(0, 1, 2, 3, 4, 5), '0,2')
        );
    }

    /**
     * Generated from @assert (array(0, 1, 2, 3, 4, 5), array(0, 2)) [==] array(1 => 1, 3 => 3, 4 => 4, 5 => 5).
     *
     * @covers Kotchasan\ArrayTool::delete
     */
    public function testDelete2()
    {

        $this->assertEquals(
            array(1 => 1, 3 => 3, 4 => 4, 5 => 5),
            \Kotchasan\ArrayTool::delete(array(0, 1, 2, 3, 4, 5), array(0, 2))
        );
    }

    /**
     * Generated from @assert (array(0, 1, 2, 3, 4, 5), 2) [==] array(0 => 0, 1 => 1, 3 => 3, 4 => 4, 5 => 5).
     *
     * @covers Kotchasan\ArrayTool::delete
     */
    public function testDelete3()
    {

        $this->assertEquals(
            array(0 => 0, 1 => 1, 3 => 3, 4 => 4, 5 => 5),
            \Kotchasan\ArrayTool::delete(array(0, 1, 2, 3, 4, 5), 2)
        );
    }

    /**
     * Generated from @assert (array('one' => 1, 'two' => 2, 'three' => 3), 'two') [==] array('one' => 1, 'three' => 3).
     *
     * @covers Kotchasan\ArrayTool::delete
     */
    public function testDelete4()
    {

        $this->assertEquals(
            array('one' => 1, 'three' => 3),
            \Kotchasan\ArrayTool::delete(array('one' => 1, 'two' => 2, 'three' => 3), 'two')
        );
    }

    /**
     * Generated from @assert (array('one', 'One', 'two'), 'one') [==] array('one', 'One').
     *
     * @covers Kotchasan\ArrayTool::filter
     */
    public function testFilter()
    {

        $this->assertEquals(
            array('one', 'One'),
            \Kotchasan\ArrayTool::filter(array('one', 'One', 'two'), 'one')
        );
    }

    /**
     * Generated from @assert (array('one', 'two', 'three'), 0, '') [==] 'one'.
     *
     * @covers Kotchasan\ArrayTool::get
     */
    public function testGet()
    {

        $this->assertEquals(
            'one',
            \Kotchasan\ArrayTool::get(array('one', 'two', 'three'), 0, '')
        );
    }

    /**
     * Generated from @assert (array('one', 'two', 'three'), 4, '') [==] ''.
     *
     * @covers Kotchasan\ArrayTool::get
     */
    public function testGet2()
    {

        $this->assertEquals(
            '',
            \Kotchasan\ArrayTool::get(array('one', 'two', 'three'), 4, '')
        );
    }

    /**
     * Generated from @assert (array('one', 'two', 'three')) [==] 0.
     *
     * @covers Kotchasan\ArrayTool::getFirstKey
     */
    public function testGetFirstKey()
    {

        $this->assertEquals(
            0,
            \Kotchasan\ArrayTool::getFirstKey(array('one', 'two', 'three'))
        );
    }

    /**
     * Generated from @assert (array('one' => 1, 'two' => 2, 'three' => 3)) [==] 'one'.
     *
     * @covers Kotchasan\ArrayTool::getFirstKey
     */
    public function testGetFirstKey2()
    {

        $this->assertEquals(
            'one',
            \Kotchasan\ArrayTool::getFirstKey(array('one' => 1, 'two' => 2, 'three' => 3))
        );
    }

    /**
     * Generated from @assert ((object)array('one' => 1, 'two' => 2, 'three' => 3)) [==] 'one'.
     *
     * @covers Kotchasan\ArrayTool::getFirstKey
     */
    public function testGetFirstKey3()
    {

        $this->assertEquals(
            'one',
            \Kotchasan\ArrayTool::getFirstKey((object)array('one' => 1, 'two' => 2, 'three' => 3))
        );
    }

    /**
     * Generated from @assert ([]) [==] null.
     *
     * @covers Kotchasan\ArrayTool::getFirstKey
     */
    public function testGetFirstKey4()
    {

        $this->assertEquals(
            null,
            \Kotchasan\ArrayTool::getFirstKey([])
        );
    }

    /**
     * Generated from @assert (0) [==] null.
     *
     * @covers Kotchasan\ArrayTool::getFirstKey
     */
    public function testGetFirstKey5()
    {

        $this->assertEquals(
            null,
            \Kotchasan\ArrayTool::getFirstKey(0)
        );
    }

    /**
     * Generated from @assert (array('one' => 1, 'two' => 2), 'two', 'three', 3) [==] array('one' => 1, 'two' => 2, 'three' => 3).
     *
     * @covers Kotchasan\ArrayTool::insertAfter
     */
    public function testInsertAfter()
    {

        $this->assertEquals(
            array('one' => 1, 'two' => 2, 'three' => 3),
            \Kotchasan\ArrayTool::insertAfter(array('one' => 1, 'two' => 2), 'two', 'three', 3)
        );
    }

    /**
     * Generated from @assert (array(1 => 'one', 2 => 'two'), 1, 3, 'three') [==] array(1 => 'one', 3 => 'three', 2 => 'two').
     *
     * @covers Kotchasan\ArrayTool::insertAfter
     */
    public function testInsertAfter2()
    {

        $this->assertEquals(
            array(1 => 'one', 3 => 'three', 2 => 'two'),
            \Kotchasan\ArrayTool::insertAfter(array(1 => 'one', 2 => 'two'), 1, 3, 'three')
        );
    }

    /**
     * Generated from @assert (array(1 => 'one', 2 => 'two'), 2, 3, 'three') [==] array(1 => 'one', 2 => 'two', 3 => 'three').
     *
     * @covers Kotchasan\ArrayTool::insertAfter
     */
    public function testInsertAfter3()
    {

        $this->assertEquals(
            array(1 => 'one', 2 => 'two', 3 => 'three'),
            \Kotchasan\ArrayTool::insertAfter(array(1 => 'one', 2 => 'two'), 2, 3, 'three')
        );
    }

    /**
     * Generated from @assert (array(1 => 'one', 2 => 'two'), 3, 3, 'three') [==] array(1 => 'one', 2 => 'two', 3 => 'three').
     *
     * @covers Kotchasan\ArrayTool::insertAfter
     */
    public function testInsertAfter4()
    {

        $this->assertEquals(
            array(1 => 'one', 2 => 'two', 3 => 'three'),
            \Kotchasan\ArrayTool::insertAfter(array(1 => 'one', 2 => 'two'), 3, 3, 'three')
        );
    }

    /**
     * Generated from @assert (array(1 => 'one', 2 => 'two'), '1', 3, 'three') [==] array(1 => 'one', 2 => 'two', 3 => 'three').
     *
     * @covers Kotchasan\ArrayTool::insertAfter
     */
    public function testInsertAfter5()
    {

        $this->assertEquals(
            array(1 => 'one', 2 => 'two', 3 => 'three'),
            \Kotchasan\ArrayTool::insertAfter(array(1 => 'one', 2 => 'two'), '1', 3, 'three')
        );
    }

    /**
     * Generated from @assert (array('one' => 1, 'three' => 3), 'three', 'two', 2) [==] array('one' => 1, 'two' => 2, 'three' => 3).
     *
     * @covers Kotchasan\ArrayTool::insertBefore
     */
    public function testInsertBefore()
    {

        $this->assertEquals(
            array('one' => 1, 'two' => 2, 'three' => 3),
            \Kotchasan\ArrayTool::insertBefore(array('one' => 1, 'three' => 3), 'three', 'two', 2)
        );
    }

    /**
     * Generated from @assert (array(1 => 'one', 3 => 'three'), 3, 2, 'two') [==] array(1 => 'one', 2 => 'two', 3 => 'three').
     *
     * @covers Kotchasan\ArrayTool::insertBefore
     */
    public function testInsertBefore2()
    {

        $this->assertEquals(
            array(1 => 'one', 2 => 'two', 3 => 'three'),
            \Kotchasan\ArrayTool::insertBefore(array(1 => 'one', 3 => 'three'), 3, 2, 'two')
        );
    }

    /**
     * Generated from @assert (array(1 => 'one', 3 => 'three'), 2, 2, 'two') [==] array(1 => 'one', 3 => 'three', 2 => 'two').
     *
     * @covers Kotchasan\ArrayTool::insertBefore
     */
    public function testInsertBefore3()
    {

        $this->assertEquals(
            array(1 => 'one', 3 => 'three', 2 => 'two'),
            \Kotchasan\ArrayTool::insertBefore(array(1 => 'one', 3 => 'three'), 2, 2, 'two')
        );
    }

    /**
     * Generated from @assert (array(1 => 'one', 2 => 'two'), 1, 3, 'three') [==] array(3 => 'three', 1 => 'one', 2 => 'two').
     *
     * @covers Kotchasan\ArrayTool::insertBefore
     */
    public function testInsertBefore4()
    {

        $this->assertEquals(
            array(3 => 'three', 1 => 'one', 2 => 'two'),
            \Kotchasan\ArrayTool::insertBefore(array(1 => 'one', 2 => 'two'), 1, 3, 'three')
        );
    }

    /**
     * Generated from @assert (array(1 => 'one', 2 => 'two'), 2, 3, 'three') [==] array(1 => 'one', 3 => 'three', 2 => 'two').
     *
     * @covers Kotchasan\ArrayTool::insertBefore
     */
    public function testInsertBefore5()
    {

        $this->assertEquals(
            array(1 => 'one', 3 => 'three', 2 => 'two'),
            \Kotchasan\ArrayTool::insertBefore(array(1 => 'one', 2 => 'two'), 2, 3, 'three')
        );
    }

    /**
     * Generated from @assert (array(1 => 'one', 2 => 'two'), 3, 3, 'three') [==] array(1 => 'one', 2 => 'two', 3 => 'three').
     *
     * @covers Kotchasan\ArrayTool::insertBefore
     */
    public function testInsertBefore6()
    {

        $this->assertEquals(
            array(1 => 'one', 2 => 'two', 3 => 'three'),
            \Kotchasan\ArrayTool::insertBefore(array(1 => 'one', 2 => 'two'), 3, 3, 'three')
        );
    }

    /**
     * Generated from @assert (array(1 => 'one', 2 => 'two'), '1', 3, 'three') [==] array(1 => 'one', 2 => 'two', 3 => 'three').
     *
     * @covers Kotchasan\ArrayTool::insertBefore
     */
    public function testInsertBefore7()
    {

        $this->assertEquals(
            array(1 => 'one', 2 => 'two', 3 => 'three'),
            \Kotchasan\ArrayTool::insertBefore(array(1 => 'one', 2 => 'two'), '1', 3, 'three')
        );
    }

    /**
     * Generated from @assert (array(1 => 1, 2 => 2, 3 => 'three'), array(1 => 'one', 2 => 'two')) [==] array(1 => 'one', 2 => 'two', 3 => 'three').
     *
     * @covers Kotchasan\ArrayTool::replace
     */
    public function testReplace()
    {

        $this->assertEquals(
            array(1 => 'one', 2 => 'two', 3 => 'three'),
            \Kotchasan\ArrayTool::replace(array(1 => 1, 2 => 2, 3 => 'three'), array(1 => 'one', 2 => 'two'))
        );
    }

    /**
     * Generated from @assert ((object)array('one' => 1), array('two' => 2)) [==] (object)array('one' => 1, 'two' => 2).
     *
     * @covers Kotchasan\ArrayTool::replace
     */
    public function testReplace2()
    {

        $this->assertEquals(
            (object)array('one' => 1, 'two' => 2),
            \Kotchasan\ArrayTool::replace((object)array('one' => 1), array('two' => 2))
        );
    }

    /**
     * Generated from @assert ((object)array('one' => 1), (object)array('two' => 2)) [==] (object)array('one' => 1, 'two' => 2).
     *
     * @covers Kotchasan\ArrayTool::replace
     */
    public function testReplace3()
    {

        $this->assertEquals(
            (object)array('one' => 1, 'two' => 2),
            \Kotchasan\ArrayTool::replace((object)array('one' => 1), (object)array('two' => 2))
        );
    }

    /**
     * Generated from @assert (array(array('id' => 1, 'name' => 'one'), array('id' => 2, 'name' => 'two'), array('id' => 3, 'name' => 'one')), 'name', 'one') [==] array(0 => array('id' => 1, 'name' => 'one'), 2 => array('id' => 3, 'name' => 'one')).
     *
     * @covers Kotchasan\ArrayTool::search
     */
    public function testSearch()
    {

        $this->assertEquals(
            array(0 => array('id' => 1, 'name' => 'one'), 2 => array('id' => 3, 'name' => 'one')),
            \Kotchasan\ArrayTool::search(array(array('id' => 1, 'name' => 'one'), array('id' => 2, 'name' => 'two'), array('id' => 3, 'name' => 'one')), 'name', 'one')
        );
    }

    /**
     * Generated from @assert (array(array('id' => 1, 'name' => 'one'), array('id' => 2, 'name' => 'two'), array('id' => 3, 'name' => 'one')), 'id', 'one') [==] [].
     *
     * @covers Kotchasan\ArrayTool::search
     */
    public function testSearch2()
    {

        $this->assertEquals(
            [],
            \Kotchasan\ArrayTool::search(array(array('id' => 1, 'name' => 'one'), array('id' => 2, 'name' => 'two'), array('id' => 3, 'name' => 'one')), 'id', 'one')
        );
    }

    /**
     * Generated from @assert (array((object)array('id' => 1, 'name' => 'one'), (object)array('id' => 2, 'name' => 'two'), (object)array('id' => 3, 'name' => 'one')), 'name', 'one') [==] array(0 => (object)array('id' => 1, 'name' => 'one'), 2 => (object)array('id' => 3, 'name' => 'one')).
     *
     * @covers Kotchasan\ArrayTool::search
     */
    public function testSearch3()
    {

        $this->assertEquals(
            array(0 => (object)array('id' => 1, 'name' => 'one'), 2 => (object)array('id' => 3, 'name' => 'one')),
            \Kotchasan\ArrayTool::search(array((object)array('id' => 1, 'name' => 'one'), (object)array('id' => 2, 'name' => 'two'), (object)array('id' => 3, 'name' => 'one')), 'name', 'one')
        );
    }

    /**
     * Generated from @assert (array((object)array('id' => 1, 'name' => 'one'), (object)array('id' => 2, 'name' => 'two'), (object)array('id' => 3, 'name' => 'one')), 'id', 'one') [==] [].
     *
     * @covers Kotchasan\ArrayTool::search
     */
    public function testSearch4()
    {

        $this->assertEquals(
            [],
            \Kotchasan\ArrayTool::search(array((object)array('id' => 1, 'name' => 'one'), (object)array('id' => 2, 'name' => 'two'), (object)array('id' => 3, 'name' => 'one')), 'id', 'one')
        );
    }

    /**
     * Generated from @assert (array('one' => 1, 'two' => 2, 'three' => 3), 'two') [==] array('three' => 3).
     *
     * @covers Kotchasan\ArrayTool::shift
     */
    public function testShift()
    {

        $this->assertEquals(
            array('three' => 3),
            \Kotchasan\ArrayTool::shift(array('one' => 1, 'two' => 2, 'three' => 3), 'two')
        );
    }

    /**
     * Generated from @assert (array('one' => 1, 'two' => 2, 'three' => 3), 1) [==] array('one' => 1, 'two' => 2, 'three' => 3).
     *
     * @covers Kotchasan\ArrayTool::shift
     */
    public function testShift2()
    {

        $this->assertEquals(
            array('one' => 1, 'two' => 2, 'three' => 3),
            \Kotchasan\ArrayTool::shift(array('one' => 1, 'two' => 2, 'three' => 3), 1)
        );
    }

    /**
     * Generated from @assert (array(array('id' => 2, 'value' => 'two'), array('id' => 3, 'value' => 'three'), array('id' => 1, 'value' => 'one'))) [==] array(array('id' => 1, 'value' => 'one'), array('id' => 2, 'value' => 'two'), array('id' => 3, 'value' => 'three')).
     *
     * @covers Kotchasan\ArrayTool::sort
     */
    public function testSort()
    {

        $this->assertEquals(
            array(array('id' => 1, 'value' => 'one'), array('id' => 2, 'value' => 'two'), array('id' => 3, 'value' => 'three')),
            \Kotchasan\ArrayTool::sort(array(array('id' => 2, 'value' => 'two'), array('id' => 3, 'value' => 'three'), array('id' => 1, 'value' => 'one')))
        );
    }

    /**
     * Generated from @assert ('|', array('a' => 'A', 'b' => array('b', 'B'), 'c' => array('c' => array('c', 'C')))) [==] "A|b|B|c|C".
     *
     * @covers Kotchasan\ArrayTool::toString
     */
    public function testToString()
    {

        $this->assertEquals(
            "A|b|B|c|C",
            \Kotchasan\ArrayTool::toString('|', array('a' => 'A', 'b' => array('b', 'B'), 'c' => array('c' => array('c', 'C'))))
        );
    }

    /**
     * Generated from @assert ('|', (object)array('a' => 'A', 'b' => array('b', 'B'), 'c' => array('c' => array('c', 'C')))) [==] "A|b|B|c|C".
     *
     * @covers Kotchasan\ArrayTool::toString
     */
    public function testToString2()
    {

        $this->assertEquals(
            "A|b|B|c|C",
            \Kotchasan\ArrayTool::toString('|', (object)array('a' => 'A', 'b' => array('b', 'B'), 'c' => array('c' => array('c', 'C'))))
        );
    }

    /**
     * Generated from @assert ('|', 'one') [==] 'one'.
     *
     * @covers Kotchasan\ArrayTool::toString
     */
    public function testToString3()
    {

        $this->assertEquals(
            'one',
            \Kotchasan\ArrayTool::toString('|', 'one')
        );
    }

    /**
     * Generated from @assert ('|', 1) [==] 1.
     *
     * @covers Kotchasan\ArrayTool::toString
     */
    public function testToString4()
    {

        $this->assertEquals(
            1,
            \Kotchasan\ArrayTool::toString('|', 1)
        );
    }

    /**
     * Generated from @assert ('') [==] [].
     *
     * @covers Kotchasan\ArrayTool::unserialize
     */
    public function testUnserialize()
    {

        $this->assertEquals(
            [],
            \Kotchasan\ArrayTool::unserialize('')
        );
    }

    /**
     * Generated from @assert (serialize(array(1, 2, 3))) [==] array(1, 2, 3).
     *
     * @covers Kotchasan\ArrayTool::unserialize
     */
    public function testUnserialize2()
    {

        $this->assertEquals(
            array(1, 2, 3),
            \Kotchasan\ArrayTool::unserialize(serialize(array(1, 2, 3)))
        );
    }

    /**
     * Generated from @assert (serialize(array(1 => 'One', 2 => 'Two', 3 => 'Three')), array(3 => 3, 4 => 'Four'), true) [==] array(3 => 'Three', 4 => 'Four', 1 => 'One', 2 => 'Two').
     *
     * @covers Kotchasan\ArrayTool::unserialize
     */
    public function testUnserialize3()
    {

        $this->assertEquals(
            array(3 => 'Three', 4 => 'Four', 1 => 'One', 2 => 'Two'),
            \Kotchasan\ArrayTool::unserialize(serialize(array(1 => 'One', 2 => 'Two', 3 => 'Three')), array(3 => 3, 4 => 'Four'), true)
        );
    }

    /**
     * Generated from @assert (serialize(array(1 => 'One', 2 => 'Two', 3 => 'Three')), array(3 => 3, 4 => 'Four'), false) [==] array(3 => 3, 4 => 'Four', 1 => 'One', 2 => 'Two').
     *
     * @covers Kotchasan\ArrayTool::unserialize
     */
    public function testUnserialize4()
    {

        $this->assertEquals(
            array(3 => 3, 4 => 'Four', 1 => 'One', 2 => 'Two'),
            \Kotchasan\ArrayTool::unserialize(serialize(array(1 => 'One', 2 => 'Two', 3 => 'Three')), array(3 => 3, 4 => 'Four'), false)
        );
    }

    /**
     * Generated from @assert (array('12.4'), array('1.10', 12.4, 1.13)) [==] true.
     *
     * @covers Kotchasan\ArrayTool::in_array
     */
    public function testIn_array()
    {

        $this->assertTrue(
            \Kotchasan\ArrayTool::in_array(array('12.4'), array('1.10', 12.4, 1.13))
        );
    }

    /**
     * Generated from @assert (array('12.4'), array('1.10', 12.4, 1.13), true) [==] false.
     *
     * @covers Kotchasan\ArrayTool::in_array
     */
    public function testIn_array2()
    {

        $this->assertFalse(
            \Kotchasan\ArrayTool::in_array(array('12.4'), array('1.10', 12.4, 1.13), true)
        );
    }

    /**
     * Generated from @assert (array(1, 2), array('1', 2)) [==] true.
     *
     * @covers Kotchasan\ArrayTool::in_array
     */
    public function testIn_array3()
    {

        $this->assertTrue(
            \Kotchasan\ArrayTool::in_array(array(1, 2), array('1', 2))
        );
    }

    /**
     * Generated from @assert (array('1', 2), array(1, 2)) [==] true.
     *
     * @covers Kotchasan\ArrayTool::in_array
     */
    public function testIn_array4()
    {

        $this->assertTrue(
            \Kotchasan\ArrayTool::in_array(array('1', 2), array(1, 2))
        );
    }

    /**
     * Generated from @assert (array(1), array('1', 2), true) [==] false.
     *
     * @covers Kotchasan\ArrayTool::in_array
     */
    public function testIn_array5()
    {

        $this->assertFalse(
            \Kotchasan\ArrayTool::in_array(array(1), array('1', 2), true)
        );
    }

    /**
     * Generated from @assert (array('1'), array(1, 2), true) [==] false.
     *
     * @covers Kotchasan\ArrayTool::in_array
     */
    public function testIn_array6()
    {

        $this->assertFalse(
            \Kotchasan\ArrayTool::in_array(array('1'), array(1, 2), true)
        );
    }

    /**
     * Generated from @assert (array(1, 2), array(1, 2)) [==] true.
     *
     * @covers Kotchasan\ArrayTool::in_array
     */
    public function testIn_array7()
    {

        $this->assertTrue(
            \Kotchasan\ArrayTool::in_array(array(1, 2), array(1, 2))
        );
    }

    /**
     * Generated from @assert (array(2), array(1, 2, 3)) [==] true.
     *
     * @covers Kotchasan\ArrayTool::in_array
     */
    public function testIn_array8()
    {

        $this->assertTrue(
            \Kotchasan\ArrayTool::in_array(array(2), array(1, 2, 3))
        );
    }

    /**
     * Generated from @assert (array(1, 2), array(3, 4)) [==] false.
     *
     * @covers Kotchasan\ArrayTool::in_array
     */
    public function testIn_array9()
    {

        $this->assertFalse(
            \Kotchasan\ArrayTool::in_array(array(1, 2), array(3, 4))
        );
    }

    /**
     * Generated from @assert ([], array(3, 4)) [==] false.
     *
     * @covers Kotchasan\ArrayTool::in_array
     */
    public function testIn_array10()
    {

        $this->assertFalse(
            \Kotchasan\ArrayTool::in_array([], array(3, 4))
        );
    }

    /**
     * Generated from @assert ([], []) [==] false.
     *
     * @covers Kotchasan\ArrayTool::in_array
     */
    public function testIn_array11()
    {

        $this->assertFalse(
            \Kotchasan\ArrayTool::in_array([], [])
        );
    }

    /**
     * Generated from @assert (array('q', array('p', 'h')), array(array('p', 'h'), array('p', 'r'), 'o')) [==] true.
     *
     * @covers Kotchasan\ArrayTool::in_array
     */
    public function testIn_array12()
    {

        $this->assertTrue(
            \Kotchasan\ArrayTool::in_array(array('q', array('p', 'h')), array(array('p', 'h'), array('p', 'r'), 'o'))
        );
    }

    /**
     * Generated from @assert (array('r', 'h'), array(array('p', 'h'), array('p', 'r'), 'o')) [==] false.
     *
     * @covers Kotchasan\ArrayTool::in_array
     */
    public function testIn_array13()
    {

        $this->assertFalse(
            \Kotchasan\ArrayTool::in_array(array('r', 'h'), array(array('p', 'h'), array('p', 'r'), 'o'))
        );
    }

    /**
     * Generated from @assert (array('f', 'i'), array(array('p', 'h'), array('p', 'r'), 'o')) [==] false.
     *
     * @covers Kotchasan\ArrayTool::in_array
     */
    public function testIn_array14()
    {

        $this->assertFalse(
            \Kotchasan\ArrayTool::in_array(array('f', 'i'), array(array('p', 'h'), array('p', 'r'), 'o'))
        );
    }

    /**
     * Generated from @assert (array('o'), array(array('p', 'h'), array('p', 'r'), 'o')) [==] true.
     *
     * @covers Kotchasan\ArrayTool::in_array
     */
    public function testIn_array15()
    {

        $this->assertTrue(
            \Kotchasan\ArrayTool::in_array(array('o'), array(array('p', 'h'), array('p', 'r'), 'o'))
        );
    }
}