<?php
/**
 * @filesource modules/download/controllers/download.php
 *
 * ไฟล์ควบคุมการดาวน์โหลด
 *
 * @license https://www.kotchasan.com/license/
 * @see https://www.kotchasan.com/
 */

namespace Download\Download;

use Kotchasan\Http\Request;

/**
 * แสดงผลไฟล์ดาวน์โหลด
 *
 * @since 1.0
 */
class Controller extends \Kotchasan\KBase
{
    /**
     * Controller สำหรับการดาวน์โหลดไฟล์
     *
     * @param Request $request คำขอจากผู้ใช้
     */
    public function index(Request $request)
    {
        // รับค่าพารามิเตอร์ 'id' จากคำขอ
        $id = $request->get('id')->toString();
        if ($id) {
            try {
                // ถอดรหัส 'id' เพื่อรับข้อมูลที่เข้ารหัสไว้
                $payload = \Kotchasan\Password::decode($id, self::$cfg->password_key);
                // แปลงข้อมูลที่ถอดรหัสแล้วเป็น Array
                $json = json_decode($payload, true);
                // ตรวจสอบว่าไฟล์มีอยู่หรือไม่
                if (is_file($json['file'])) {
                    // อ่าน MIME type จากไฟล์
                    $finfo = finfo_open(FILEINFO_MIME_TYPE);
                    $mimeType = finfo_file($finfo, $json['file']);
                    finfo_close($finfo);

                    // ตั้งค่า header สำหรับการดาวน์โหลดไฟล์
                    header('Content-Description: File Transfer');
                    header('Content-Type: '.$mimeType);
                    header('Content-Transfer-Encoding: binary');
                    header('Expires: 0');
                    header('Cache-Control: must-revalidate');
                    header('Pragma: public');
                    header('Content-Length: '.filesize($json['file']));
                    // อ่านและส่งเนื้อหาไฟล์ไปยังผู้ใช้
                    readfile($json['file']);
                    exit;
                }
            } catch (\Exception $e) {
                // จัดการข้อยกเว้นในกรณีที่มีปัญหา
            }
        }
        // หากไม่พบไฟล์ ให้ส่งรหัสสถานะ 404
        header('HTTP/1.0 404 Not Found');
    }
}
