# Copyright 2021 Google LLC.
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     https://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from absl.testing import absltest
from temporian.core.data import schema
from temporian.core.data.dtype import DType


class SchemaTest(absltest.TestCase):
    def test_proto(self):
        a = schema.Schema(features=[("f1", DType.INT32), ("f2", DType.FLOAT64)])
        p = a.to_proto()
        b = schema.Schema.from_proto(p)
        self.assertEqual(a, b)


if __name__ == "__main__":
    absltest.main()
