# Tutorials

A collection of tutorials that will help you see how Temporian can be used in practice in a wide range of scenarios.

Make sure to check the [Getting Started guide](../getting_started.ipynb) before to learn about the basic usage of the library, including the concepts of sampling and indexes.

- [Heart rate analysis](heart_rate_analysis.ipynb): Load, visualize and preprocess medical data to detect heartbeats and compute heart rate and heart rate variability from raw ECG signals.
- [Loan outcomes prediction](loan_outcomes_prediction.ipynb): Use Temporian to prepare data to predict outcomes for finished loans.
- [M5 Competition](m5_competition.ipynb): Feature engineering and model training on the M5 Makridakis Forecasting Competitions.
- [Detecting payment card fraud](bank_fraud_detection_with_tfdf.ipynb): Feature augmentation to detect payment card fraud with Temporian and TensorFlow Decision Forests.
- [Temporian with Apache Beam](temporian_with_beam.ipynb): How to execute Temporian on large datasets using Apache Beam.
- [Supervised](anomaly_detection_supervised.ipynb) and [unsupervised](anomaly_detection_unsupervised.ipynb) anomaly detection: Data visualization and feature engineering for detecting anomalies in time series data.
