// Code generated by Wire. DO NOT EDIT.

//go:generate go run github.com/google/wire/cmd/wire
//go:build !wireinject
// +build !wireinject

package copper

import (
	"github.com/gocopper/copper/cconfig"
	"github.com/gocopper/copper/clifecycle"
	"github.com/gocopper/copper/clogger"
	"github.com/google/wire"
)

// Injectors from wire.go:

// InitApp creates a new Copper app along with its dependencies.
func InitApp() (*App, error) {
	lifecycle := clifecycle.New()
	flags := NewFlags()
	path := flags.ConfigPath
	overrides := flags.ConfigOverrides
	loader, err := cconfig.NewWithKeyOverrides(path, overrides)
	if err != nil {
		return nil, err
	}
	config, err := clogger.LoadConfig(loader)
	if err != nil {
		return nil, err
	}
	logger, err := clogger.NewWithConfig(config)
	if err != nil {
		return nil, err
	}
	app := NewApp(lifecycle, loader, logger)
	return app, nil
}

// wire.go:

// WireModule can be used as part of google/wire setup to include the app's
// lifecycle, config, and logger.
var WireModule = wire.NewSet(wire.FieldsOf(new(*App), "Lifecycle", "Config", "Logger"))
