
### Collecting Profiles via HTTP Interface

> [!note] To be able to collect profiles using the http API, you need to set `enableMetrics: true` in the yaml file in the `configs` directory, the default route is `/debug/pprof`.

Collecting profiles through HTTP API in the service [code example](https://github.com/go-dev-frame/sponge/blob/main/pkg/prof/README.md#sampling-profile-by-http).

This is typically used during development or testing. Enabling it in a production environment may cause slight performance overhead, so consider whether it's necessary. In addition to the default Go language profiles, it also supports I/O profiling, with the route `/debug/pprof/profile-io`.

- For web services, the default profile collection URL is http://localhost:8080/debug/pprof.
- For grpc service, the default profile collection URL is http://localhost:8283/debug/pprof.

By combining it with the **go tool pprof**, you can analyze the program's runtime status at any time.

<br>

### Collecting Profiles via System Signal Notifications

> [!note] The system signal notification collection profile function is enabled by default and does not require additional configuration.

Enable system signal notification collection profile in the service [code example](https://github.com/go-dev-frame/sponge/blob/main/pkg/prof/README.md#sampling-profile-by-system-notification-signal).

When using the HTTP interface, the program continuously records profile-related information in the background, even though most of the time this information is not needed. It can be improved by collecting profiles only when necessary and automatically stopping the collection afterward. Services generated by sponge support listening to system signals to start and stop profile collection. By default, it uses the **SIGTRAP** (5) system signal (recommended to change to SIGUSR1 on Linux; Windows environments do not support SIGUSR1). You can send a signal to the service like this:

```bash
# Find the service PID by name (second column)
ps aux | grep service-name

# Send a signal to the service
kill -trap pid-value
# kill -usr1 pid-value
```

After receiving the system signal, the service starts collecting profiles and saves them in the `/tmp/service-name_profile` directory. By default, profiles are collected for 60 seconds and then automatically stopped. If you want to collect profiles for only 30 seconds, send the first signal to start collection, and then send the second signal to stop collection after about 30 seconds. It's similar to a switch. By default, it collects six types of profiles: **cpu**, **memory**, **goroutine**, **block**, **mutex**, and **threadcreate**. The profile files are named in the format `datetime_pid_service-name_profile-type.out`, for example:

```
xxx221809_58546_user_cpu.out
xxx221809_58546_user_mem.out
xxx221809_58546_user_goroutine.out
xxx221809_58546_user_block.out
xxx221809_58546_user_mutex.out
xxx221809_58546_user_threadcreate.out
```

Trace profiles are relatively large, so they are not collected by default. You can enable trace collection as needed (call `prof.EnableTrace()` during service initialization).

Once you have the offline profile files, you can use the pprof tool for interactive or web-based analysis:

```bash
# Interactive mode
go tool pprof [options] source

# Web-based mode
go tool pprof -http=[host]:[port] [options] source
```

<br>

### Adaptive Profile Collection

> [!note] To be able to use system signals to notify the acquisition profile, you need to set `enableStat: true` in the yaml file in the `configs` directory.

For services running online, you don't usually manually collect profiles unless there is an issue. However, you may want to collect profile files when the service issues an alert. To address this, services generated by sponge support adaptive profile collection, which combines system signal-based profile collection with resource usage alerting. The alerting conditions are:

- When the CPU usage exceeds 80% for three consecutive times (default is once per minute), an alert is triggered.
- When the physical memory usage exceeds 80% for three consecutive times (default is once per minute), an alert is triggered.
- If the alert threshold is continuously exceeded, an alert is sent approximately every 15 minutes.

When an alert is triggered, the program internally uses the `kill` function to send a system signal to initiate profile collection. The collected profile files are saved in the `/tmp/service-name_profile` directory. This way, even if the CPU or memory usage is high late at night, you can still analyze the profile the next day to identify the source of the CPU or memory usage issue.

> [!note] Adaptive profile collection is not supported in Windows environments.

<br>
