package commands

import (
	"github.com/fatih/color"
	"github.com/spf13/cobra"
)

const (
	latestVersion    = "latest"
	separatedVersion = "v1.11.2"
)

// InitCommand initial sponge
func InitCommand() *cobra.Command {
	cmd := &cobra.Command{
		Use:   "init",
		Short: "Initialize sponge",
		Long:  "Initialize sponge.",
		Example: color.HiBlackString(`  # Run init, download code and install plugins.
  sponge init`),
		SilenceErrors: true,
		SilenceUsage:  true,
		RunE: func(cmd *cobra.Command, args []string) error {
			targetVersion := latestVersion
			// download sponge template code
			_, err := runUpgrade(targetVersion)
			if err != nil {
				return err
			}

			// installing dependency plugins
			_, lackNames := checkInstallPlugins()
			installPlugins(lackNames)

			return nil
		},
	}

	return cmd
}
