package service

import (
	"math/rand"
	"text/template"
	"time"
)

func init() {
	var err error
	serviceLogicTmpl, err = template.New("serviceLogic").Parse(serviceLogicTmplRaw)
	if err != nil {
		panic(err)
	}
	routerTmpl, err = template.New("serviceRouter").Parse(routerTmplRaw)
	if err != nil {
		panic(err)
	}
	rpcErrCodeTmpl, err = template.New("rpcErrCode").Parse(rpcErrCodeTmplRaw)
	if err != nil {
		panic(err)
	}

	rand.Seed(time.Now().UnixNano()) //nolint
}

var (
	serviceLogicTmpl    *template.Template
	serviceLogicTmplRaw = `// Code generated by https://github.com/go-dev-frame/sponge

package service

import (
	"context"

	// import api service package here
	//"moduleNameExample/internal/rpcclient"
)

{{- range .PbServices}}

var _ {{.ProtoPkgName}}.{{.Name}}Logicer = (*{{.LowerName}}Client)(nil)

type {{.LowerName}}Client struct {
	// define rpc clients interface here
	// example:
	//	    {{.LowerName}}Cli {{.ProtoPkgName}}.{{.Name}}Client
}

// New{{.Name}}Client create a client
func New{{.Name}}Client() {{.ProtoPkgName}}.{{.Name}}Logicer {
	return &{{.LowerName}}Client{
		// example:
		//	    {{.LowerName}}Cli: {{.ProtoPkgName}}.New{{.Name}}Client(rpcclient.Get{{.CutServiceName}}RPCConn()),
	}
}

{{- range .Methods}}

{{if eq .InvokeType 0}}{{if .Path}}{{.Comment}}
func (c *{{.LowerServiceName}}Client) {{.MethodName}}(ctx context.Context, req *{{.RequestImportPkgName}}.{{.Request}}) (*{{.ReplyImportPkgName}}.{{.Reply}}, error) {
	panic("implement me")

	// fill in the business logic code here
	// example:
	//	    {{if .IsIgnoreShouldBind}}gc, ctx := middleware.AdaptCtx(ctx)
	//	    if err = gc.ShouldBindJSON(req); err != nil {
	//	    	logger.Warn("ShouldBindJSON error", logger.Error(err), middleware.CtxRequestIDField(ctx))
	//	    	return nil, ecode.StatusInvalidParams.Err()
	//	    }{{else}}{{if .IsPassGinContext}}gc, ctx := middleware.AdaptCtx(ctx){{end}}{{end}}
	//	    err := req.Validate()
	//	    if err != nil {
	//		    logger.Warn("req.Validate error", logger.Err(err), logger.Any("req", req), interceptor.CtxRequestIDField(ctx))
	//		    return nil, ecode.StatusInvalidParams.Err()
	//	    }
	//
	//	    reply, err := c.{{.LowerServiceName}}Cli.{{.MethodName}}(ctx, &{{.RequestImportPkgName}}.{{.Request}}{
{{- range .RequestFields}}
	//     	{{.Name}}: req.{{.Name}},
{{- end}}
	//     })
	//	    if err != nil {
	//     	logger.Warn("{{.MethodName}} error", logger.Err(err), interceptor.CtxRequestIDField(ctx))
	//     	return nil, err
	//     }
	//
	//     return &{{.ReplyImportPkgName}}.{{.Reply}}{
{{- range .ReplyFields}}
	//     	{{.Name}}: reply.{{.Name}},
{{- end}}
	//     }, nil
}{{end}}{{end}}

{{- end}}

// ---------- Do not delete or move this split line, this is the merge code marker ----------

{{- end}}
`

	routerTmpl    *template.Template
	routerTmplRaw = `// Code generated by https://github.com/go-dev-frame/sponge

package routers

import (
	"context"

	"github.com/gin-gonic/gin"
	"google.golang.org/grpc/metadata"

	"github.com/go-dev-frame/sponge/pkg/gin/middleware"
	"github.com/go-dev-frame/sponge/pkg/logger"

	// import api service package here
	"moduleNameExample/internal/service"
)

func init() {
	allMiddlewareFns = append(allMiddlewareFns, func(c *middlewareConfig) {
{{- range .PbServices}}
		{{.LowerName}}Middlewares(c)
{{- end}}
	})

	allRouteFns = append(allRouteFns,
		func(r *gin.Engine, groupPathMiddlewares map[string][]gin.HandlerFunc, singlePathMiddlewares map[string][]gin.HandlerFunc) {
{{- range .PbServices}}
			{{.LowerName}}Router(r, groupPathMiddlewares, singlePathMiddlewares, service.New{{.Name}}Client())
{{- end}}
		})
}

{{- range .PbServices}}

func {{.LowerName}}Router(
	r *gin.Engine,
	groupPathMiddlewares map[string][]gin.HandlerFunc,
	singlePathMiddlewares map[string][]gin.HandlerFunc,
	iService {{.ProtoPkgName}}.{{.Name}}Logicer) {
	ctxFn := func(c *gin.Context) context.Context {
		md := metadata.New(map[string]string{
			// set metadata to be passed from http to rpc
			middleware.ContextRequestIDKey: middleware.GCtxRequestID(c), // request_id
			//middleware.HeaderAuthorizationKey: c.GetHeader(middleware.HeaderAuthorizationKey),  // authorization
		})
		return metadata.NewOutgoingContext(c.Request.Context(), md)
	}

	{{.ProtoPkgName}}.Register{{.Name}}Router(
		r,
		groupPathMiddlewares,
		singlePathMiddlewares,
		iService,
		{{.ProtoPkgName}}.With{{.Name}}Logger(logger.Get()),
		{{.ProtoPkgName}}.With{{.Name}}RPCResponse(),
		{{.ProtoPkgName}}.With{{.Name}}WrapCtx(ctxFn),
		{{.ProtoPkgName}}.With{{.Name}}RPCStatusToHTTPCode(
			// Set some error codes to standard http return codes,
			// by default there is already ecode.StatusInternalServerError and ecode.StatusServiceUnavailable
			// example:
			// 	ecode.StatusUnimplemented, ecode.StatusAborted,
		),
	)
}

// you can set the middleware of a route group, or set the middleware of a single route, 
// or you can mix them, pay attention to the duplication of middleware when mixing them, 
// it is recommended to set the middleware of a single route in preference
func {{.LowerName}}Middlewares(c *middlewareConfig) {
	// set up group route middleware, group path is left prefix rules,
	// if the left prefix is hit, the middleware will take effect, e.g. group route is /api/v1, route /api/v1/{{.LowerName}}/:id  will take effect
	// c.setGroupPath("/api/v1/{{.LowerName}}", middleware.Auth())

	// set up single route middleware, just uncomment the code and fill in the middlewares, nothing else needs to be changed
{{- range .Methods}}
	{{if eq .InvokeType 0}}{{if .Path}}//c.setSinglePath("{{.Method}}", "{{.Path}}", middleware.Auth())    {{.Comment}}{{end}}{{end}}
{{- end}}
}

// ---------- Do not delete or move this split line, this is the merge code marker ----------

{{- end}}
`

	rpcErrCodeTmpl *template.Template
	//nolint
	rpcErrCodeTmplRaw = `// Code generated by https://github.com/go-dev-frame/sponge

package ecode

import (
	"github.com/go-dev-frame/sponge/pkg/errcode"
)

{{- range .PbServices}}

// {{.LowerName}} business-level rpc error codes.
// the {{.LowerName}}NO value range is 1~100, if the same error code is used, it will cause panic.
var (
	_{{.LowerName}}NO       = {{.RandNumber}}
	_{{.LowerName}}Name     = "{{.LowerName}}"
	_{{.LowerName}}BaseCode = errcode.RCode(_{{.LowerName}}NO)
// --blank line--
{{- range $i, $v := .Methods}}
	{{if eq .InvokeType 0}}{{if .Path}}Status{{.MethodName}}{{.ServiceName}}   = errcode.NewRPCStatus(_{{.LowerServiceName}}BaseCode+{{$v.AddOne $i}}, "failed to {{.MethodName}} "+_{{.LowerServiceName}}Name){{end}}{{end}}
{{- end}}

	// error codes are globally unique, adding 1 to the previous error code
)

// ---------- Do not delete or move this split line, this is the merge code marker ----------

{{- end}}
`
)
