## English | [简体中文](assets/readme-cn.md)

<p align="center">
<img width="500px" src="https://raw.githubusercontent.com/go-dev-frame/sponge/main/assets/logo.png">
</p>

<div align=center>

[![Go Report](https://goreportcard.com/badge/github.com/go-dev-frame/sponge)](https://goreportcard.com/report/github.com/go-dev-frame/sponge)
[![codecov](https://codecov.io/gh/go-dev-frame/sponge/branch/main/graph/badge.svg)](https://codecov.io/gh/go-dev-frame/sponge)
[![Go Reference](https://pkg.go.dev/badge/github.com/go-dev-frame/sponge.svg)](https://pkg.go.dev/github.com/go-dev-frame/sponge)
[![Go](https://github.com/go-dev-frame/sponge/workflows/Go/badge.svg?branch=main)](https://github.com/go-dev-frame/sponge/actions)
[![Awesome Go](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/avelino/awesome-go)
[![License: MIT](https://img.shields.io/github/license/go-dev-frame/sponge)](https://img.shields.io/github/license/go-dev-frame/sponge)

</div>

**sponge** is a powerful `Go` development framework. Its core concept revolves around reverse-engineering modular code by parsing `JSON`, `SQL`, or `Protobuf` files. The generated code can be flexibly and seamlessly assembled into various types of complete backend services (similar to the characteristics of sponge cells, where disassembled sponge cells can automatically recombine into a new sponge). Sponge provides an all-in-one solution for project development, covering code generation, development, testing, API documentation, and deployment, significantly enhancing development efficiency, reducing complexity, and enabling high-quality projects with a "low-code approach".

<br>

### Use Cases

Sponge is suitable for quickly developing various high-performance backend services, including but not limited to:

- `Web` services (gin);
- `gRPC` services;
- `HTTP+gRPC` hybrid services;
- `gRPC Gateway API` services.

Additionally, developers can use custom templates to generate various types of code to meet specific business needs.

<br>

### Core Highlights

1. **One-click generation of complete backend service code**  
   For `Web` or `gRPC` services that only require `CRUD APIs`, no `Go` code needs to be written. Simply connect to a database (e.g., `MySQL`, `MongoDB`, `PostgreSQL`, `SQLite`) to one-click generate complete backend service code and easily deploy it to Linux servers, Docker, or Kubernetes.

2. **Efficient development of general-purpose services**  
   When developing general-purpose `Web`, `gRPC`, `HTTP+gRPC`, or `gRPC Gateway` services, you only need to focus on three aspects:
    - Defining database tables;
    - Defining API descriptions in Protobuf files;
    - Writing business logic code in the generated templates.

   The framework code and CRUD API code are all automatically generated by sponge.

3. **Support for custom templates, offering flexible extensibility**  
   sponge supports generating various types of project-specific code using custom templates, not limited to the `Go` language. For example:
    - Backend code;
    - Frontend code;
    - Configuration files;
    - Test code;
    - Build and deployment scripts, etc.

<br>

### Quick Start

1. **Install sponge**

   Sponge supports installation on Windows, macOS, and Linux. Click to view the [**sponge installation guide**](https://github.com/go-dev-frame/sponge/blob/main/assets/install-cn.md).

2. **Open the code generation UI**

   After installation, run the following command to open the sponge UI:

   ```bash
   sponge run
   ```  

   Access `http://localhost:24631` in a local browser to generate code through the UI interface, as shown below:

   <p align="center">
   <img width="1500px" src="https://raw.githubusercontent.com/go-dev-frame/sponge/main/assets/en_sponge-ui.png">
   </p>

   > To access from a browser on a different host, specify the host IP or domain when starting the UI, e.g., `sponge run -a http://your_host_ip:24631`. Alternatively, you can run the UI service in Docker to support cross-host access. Click to view the guide on [running the sponge UI service in Docker](https://github.com/go-dev-frame/sponge/blob/main/assets/install-cn.md#Docker%E7%8E%AF%E5%A2%83).

<br>

### Sponge Generates the Code Framework

Sponge supports generating code using both built-in templates and custom templates, as shown in the diagrams below.

1. The code generation framework based on Sponge's built-in templates is shown below. There are two approaches: SQL and Protobuf.

<p align="center">
<img width="1500px" src="https://raw.githubusercontent.com/go-dev-frame/sponge/main/assets/sponge-framework.png">
</p>

<br>

2. The code generation framework based on custom templates is shown below. There are three approaches: JSON, SQL, and Protobuf.

<p align="center">
<img width="1200px" src="https://raw.githubusercontent.com/go-dev-frame/sponge/main/assets/template-framework.png">
</p>

<br>

### Microservice framework

Sponge supports creating six types of backend services, all based on microservice architecture. The diagram below illustrates a typical layered microservice structure, featuring high performance, scalability, and built-in service governance capabilities.

<p align="center">
<img width="1000px" src="https://raw.githubusercontent.com/go-dev-frame/sponge/main/assets/microservices-framework.png">
</p>

<br>

Performance testing of http and grpc service code created by the microservices framework: 50 concurrent, 1 million total requests.

![http-server](https://raw.githubusercontent.com/zhufuyi/microservices_framework_benchmark/main/test/assets/http-server.png)

![grpc-server](https://raw.githubusercontent.com/zhufuyi/microservices_framework_benchmark/main/test/assets/grpc-server.png)

Click to view the [**test code**](https://github.com/zhufuyi/microservices_framework_benchmark).

<br>

### Key Features

- Web framework [gin](https://github.com/gin-gonic/gin)
- RPC framework [grpc](https://github.com/grpc/grpc-go)
- Configuration parsing [viper](https://github.com/spf13/viper)
- Logging component [zap](https://github.com/uber-go/zap)
- Database ORM component [gorm](https://github.com/go-gorm/gorm), [mongo-go-driver](https://github.com/mongodb/mongo-go-driver)
- Cache component [go-redis](https://github.com/go-redis/redis), [ristretto](https://github.com/dgraph-io/ristretto)
- Automated API documentation [swagger](https://github.com/swaggo/swag), [protoc-gen-openapiv2](https://github.com/grpc-ecosystem/grpc-gateway/v2/protoc-gen-openapiv2)
- Authentication [jwt](https://github.com/golang-jwt/jwt)
- Websocket [gorilla/websocket](https://github.com/gorilla/websocket)
- Crontab [cron](https://github.com/robfig/cron)
- Message Queue [rabbitmq](https://github.com/rabbitmq/amqp091-go), [kafka](https://github.com/IBM/sarama)
- Distributed Transaction Manager [dtm](https://github.com/dtm-labs/dtm)
- Distributed lock [dlock](https://github.com/go-dev-frame/sponge/tree/main/pkg/dlock)
- Parameter validation [validator](https://github.com/go-playground/validator)
- Adaptive rate limiting [ratelimit](https://github.com/go-dev-frame/sponge/tree/main/pkg/shield/ratelimit)
- Adaptive circuit breaking [circuitbreaker](https://github.com/go-dev-frame/sponge/tree/main/pkg/shield/circuitbreaker)
- Distributed Tracing [opentelemetry](https://github.com/open-telemetry/opentelemetry-go)
- Metrics monitoring [prometheus](https://github.com/prometheus/client_golang/prometheus), [grafana](https://github.com/grafana/grafana)
- Service registration and discovery [etcd](https://github.com/etcd-io/etcd), [consul](https://github.com/hashicorp/consul), [nacos](https://github.com/alibaba/nacos)
- Adaptive collecting [profile](https://go.dev/blog/pprof)
- Resource statistics [gopsutil](https://github.com/shirou/gopsutil)
- Configuration center [nacos](https://github.com/alibaba/nacos)
- Code quality checking [golangci-lint](https://github.com/golangci/golangci-lint)
- Continuous integration and deployment [jenkins](https://github.com/jenkinsci/jenkins), [docker](https://www.docker.com/), [kubernetes](https://github.com/kubernetes/kubernetes)
- Generate project business architecture diagram [spograph](https://github.com/go-dev-frame/spograph)
- Custom template generation code [go template](https://pkg.go.dev/text/template@go1.23.3)

<br>

### Project Code Directory Structure

The project code directory structure created by sponge follows the [project-layout](https://github.com/golang-standards/project-layout).

Here is the directory structure for the generated `monolithic application single repository (monolith)` or `microservice multi-repository (multi-repo)` code:

```bash
.
├── api            # Protobuf files and generated * pb.go directory
├── assets         # Store various static resources, such as images, markdown files, etc.
├── cmd            # Program entry directory
├── configs        # Directory for configuration files
├── deployments    # Bare metal, docker, k8s deployment script directory.
├── docs           # Directory for API interface Swagger documentation.
├── internal       # Directory for business logic code.
│    ├── cache        # Cache directory wrapped around business logic.
│    ├── config       # Directory for Go structure configuration files.
│    ├── dao          # Data access directory.
│    ├── database     # database directory.
│    ├── ecode        # Directory for system error codes and custom business error codes.
│    ├── handler      # Directory for implementing HTTP business functionality (specific to web services).
│    ├── model        # Database model directory.
│    ├── routers      # HTTP routing directory.
│    ├── rpcclient    # Directory for client-side code that connects to grpc services.
│    ├── server       # Directory for creating services, including HTTP and grpc.
│    ├── service      # Directory for implementing grpc business functionality (specific to grpc services).
│    └── types        # Directory for defining request and response parameter structures for HTTP.
├── pkg            # Directory for shared libraries.
├── scripts        # Directory for scripts.
├── test           # Directory for scripts required for testing services  and test SQL.
├── third_party    # Directory for third-party protobuf files or external helper programs.
├── Makefile       # Develop, test, deploy related command sets .
├── go.mod         # Go module dependencies and version control file.
└── go.sum         # Go module dependencies key and checksum file.
```

<br>

Here is the directory structure for the generated `microservice monolithic repository (mono-repo)` code (also known as large repository directory structure):

```bash
.
├── api
│    ├── server1       # Protobuf files and generated *pb.go directory for service 1.
│    ├── server2       # Protobuf files and generated *pb.go directory for service 2.
│    ├── server3       # Protobuf files and generated *pb.go directory for service 3.
│    └── ...
├── server1        # Code directory for Service 1, it has a similar structure to the microservice multi repo directory.
├── server2        # Code directory for Service 2, it has a similar structure to the microservice multi repo directory.
├── server3        # Code directory for Service 3, it has a similar structure to the microservice multi repo directory.
├── ...
├── third_party    # Third-party protobuf files.
├── go.mod         # Go module dependencies and version control file.
└── go.sum         # Go module dependencies' checksums and hash keys.
```

<br>

### Sponge Development Documentation

Click to view [the detailed documentation](https://go-sponge.com/) for Sponge development project, including code generation, development, configuration, and deployment instructions, and more.

<br>

### Examples of use

#### Examples of create services

- [Create **web** service based on **sql** (including CRUD)](https://github.com/go-dev-frame/sponge_examples/tree/main/1_web-gin-CRUD)
- [Create **grpc** service based on **sql** (including CRUD)](https://github.com/go-dev-frame/sponge_examples/tree/main/2_micro-grpc-CRUD)
- [Create **web** service based on **protobuf**](https://github.com/go-dev-frame/sponge_examples/tree/main/3_web-gin-protobuf)
- [Create **grpc** service based on **protobuf** ](https://github.com/go-dev-frame/sponge_examples/tree/main/4_micro-grpc-protobuf)
- [Create **grpc gateway** service based on **protobuf**](https://github.com/go-dev-frame/sponge_examples/tree/main/5_micro-gin-rpc-gateway)
- [Create **grpc+http** service based on **protobuf**](https://github.com/go-dev-frame/sponge_examples/tree/main/_10_micro-grpc-http-protobuf)

#### Examples of develop complete project

- [Simple community web backend service](https://github.com/go-dev-frame/sponge_examples/tree/main/7_community-single)
- [Simple community web service broken down into microservice](https://github.com/go-dev-frame/sponge_examples/tree/main/8_community-cluster)

#### Distributed transaction examples

- [Simple distributed order system](https://github.com/go-dev-frame/sponge_examples/tree/main/9_order-grpc-distributed-transaction)
- [Flash sale](https://github.com/go-dev-frame/sponge_examples/tree/main/_12_sponge-dtm-flashSale)
- [E-Commerce system](https://github.com/go-dev-frame/sponge_examples/tree/main/_14_eshop)

<br>
<br>

**If it's help to you, give it a star ⭐.**

<br>
