/*
 * Copyright (C) 2019 Tachibana General Laboratories, LLC
 * Copyright (C) 2019 Yaroslav Pronin <proninyaroslav@mail.ru>
 *
 * This file is part of Download Navi.
 *
 * Download Navi is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Download Navi is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Download Navi.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.tachibana.downloader.core.storage.dao;

import androidx.lifecycle.LiveData;
import androidx.room.Dao;
import androidx.room.Delete;
import androidx.room.Insert;
import androidx.room.OnConflictStrategy;
import androidx.room.Query;

import com.tachibana.downloader.core.model.data.entity.UserAgent;

import java.util.List;

@Dao
public interface UserAgentDao
{
    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void add(UserAgent agent);

    @Insert(onConflict = OnConflictStrategy.REPLACE)
    void add(UserAgent[] agent);

    @Delete
    void delete(UserAgent agent);

    @Query("SELECT * FROM UserAgent")
    LiveData<List<UserAgent>> observeAll();
}
