//  Copyright (C) 2015-2019 Pierre-Olivier Latour <info@pol-online.net>
//
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.

#import <AppKit/NSEvent.h>
#import <Foundation/Foundation.h>

typedef NS_ENUM(unsigned short, GIKeyCode) {
  kGIKeyCode_Tab = 0x30,
  kGIKeyCode_Esc = 0x35,
  kGIKeyCode_Left = 0x7B,
  kGIKeyCode_Right = 0x7C,
  kGIKeyCode_Down = 0x7D,
  kGIKeyCode_PageUp = 0x74,
  kGIKeyCode_PageDown = 0x79,
  kGIKeyCode_Up = 0x7E,
  kGIKeyCode_Home = 0x73,
  kGIKeyCode_End = 0x77,
  kGIKeyCode_Return = 0x24,
  kGIKeyCode_Delete = 0x33
};

static const NSEventModifierFlags kGIKeyModifiersAll = NSEventModifierFlagShift | NSEventModifierFlagControl | NSEventModifierFlagCommand | NSEventModifierFlagOption;
