export function deparam(query) {
  let match,
      plus = /\+/g,
      search = /([^&=]+)=?([^&]*)/g,
      decode = s => decodeURIComponent(s.replace(plus, ' ')),
      params = {};
  while (match = search.exec(query)) {
    params[decode(match[1])] = decode(match[2]);
  }
  return params;
}

export function param(obj) {
  let parts = [];
  for (var name in obj) {
    if (obj.hasOwnProperty(name)) {
      parts.push(`${encodeURIComponent(name)}=${encodeURIComponent(obj[name])}`);
    }
  }
  return parts.join('&');
}

export function stringComparisonOrdinalIgnoreCase(a, b) {
  a = a.toLowerCase();
  b = b.toLowerCase();
  if (a > b) {
    return 1;
  }
  if (a < b) {
    return -1;
  }
  return 0;
}

const contentTypeMap = {
  css: 'text/css',
  js: 'application/javascript',
  json: 'application/json',
  html: 'text/html'
};

export function getExtension(name) {
  let parts = name.split('.');
  let extension;
  if (parts.length === 1) {
    return '';
  }
  return parts[parts.length - 1];
}

export function getContentType(name) {
  let extension = getExtension(name);
  if (extension === '') {
    return 'text/plain';
  }
  return contentTypeMap[extension] || 'text/plain';
}

// http://stackoverflow.com/a/30810322/725866
export function copyTextToClipboard(text) {
  let textArea = document.createElement("textarea");

  //
  // *** This styling is an extra step which is likely not required. ***
  //
  // Why is it here? To ensure:
  // 1. the element is able to have focus and selection.
  // 2. if element was to flash render it has minimal visual impact.
  // 3. less flakyness with selection and copying which **might** occur if
  //    the textarea element is not visible.
  //
  // The likelihood is the element won't even render, not even a flash,
  // so some of these are just precautions. However in IE the element
  // is visible whilst the popup box asking the user for permission for
  // the web page to copy to the clipboard.
  //

  // Place in top-left corner of screen regardless of scroll position.
  textArea.style.position = 'fixed';
  textArea.style.top = 0;
  textArea.style.left = 0;

  // Ensure it has a small width and height. Setting to 1px / 1em
  // doesn't work as this gives a negative w/h on some browsers.
  textArea.style.width = '2em';
  textArea.style.height = '2em';

  // We don't need padding, reducing the size if it does flash render.
  textArea.style.padding = 0;

  // Clean up any borders.
  textArea.style.border = 'none';
  textArea.style.outline = 'none';
  textArea.style.boxShadow = 'none';

  // Avoid flash of white box if rendered for any reason.
  textArea.style.background = 'transparent';


  textArea.value = text;

  document.body.appendChild(textArea);

  textArea.select();

  try {
    var successful = document.execCommand('copy');
    var msg = successful ? 'successful' : 'unsuccessful';
    console.log('Copying text command was ' + msg);
  } catch (err) {
    console.log('Oops, unable to copy');
  }

  document.body.removeChild(textArea);
}
