import { Product } from '@ghostfolio/common/interfaces';

export const personalFinanceTools: Product[] = [
  {
    founded: 2023,
    hasSelfHostingAbility: false,
    key: 'allinvestview',
    languages: ['English'],
    name: 'AllInvestView',
    slogan: 'All your Investments in One View'
  },
  {
    founded: 2019,
    hasFreePlan: false,
    hasSelfHostingAbility: false,
    key: 'allvue-systems',
    name: 'Allvue Systems',
    origin: 'United States',
    slogan: 'Investment Software Suite'
  },
  {
    founded: 2016,
    key: 'alphatrackr',
    languages: ['English'],
    name: 'AlphaTrackr',
    slogan: 'Investment Portfolio Tracking Tool'
  },
  {
    founded: 2017,
    hasSelfHostingAbility: false,
    key: 'altoo',
    name: 'Altoo Wealth Platform',
    origin: 'Switzerland',
    slogan: 'Simplicity for Complex Wealth'
  },
  {
    founded: 2018,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'anlage.app',
    languages: ['English'],
    name: 'Anlage.App',
    origin: 'Austria',
    pricingPerYear: '$120',
    slogan: 'Analyze and track your portfolio.'
  },
  {
    hasFreePlan: false,
    hasSelfHostingAbility: true,
    key: 'banktivity',
    name: 'Banktivity',
    origin: 'United States',
    pricingPerYear: '$59.99',
    slogan: 'Proactive money management app for macOS & iOS'
  },
  {
    founded: 2022,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'basil-finance',
    name: 'Basil Finance',
    slogan: 'The ultimate solution for tracking and managing your investments'
  },
  {
    founded: 2020,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'beanvest',
    name: 'Beanvest',
    origin: 'France',
    pricingPerYear: '$100',
    slogan: 'Stock Portfolio Tracker for Smart Investors'
  },
  {
    founded: 2007,
    hasFreePlan: false,
    hasSelfHostingAbility: false,
    key: 'buxfer',
    name: 'Buxfer',
    origin: 'United States',
    pricingPerYear: '$48',
    regions: ['Global'],
    slogan: 'Take control of your financial future'
  },
  {
    founded: 2013,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'cointracking',
    languages: ['Deutsch', 'English'],
    name: 'CoinTracking',
    origin: 'Germany',
    pricingPerYear: '$120',
    slogan: 'The leading Crypto Portfolio Tracker & Tax Calculator'
  },
  {
    founded: 2022,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'degiro-portfolio-tracker-by-capitalyse',
    languages: ['English'],
    name: 'DEGIRO Portfolio Tracker by Capitalyse',
    origin: 'Netherlands',
    pricingPerYear: '€24',
    slogan: 'Democratizing Data Analytics'
  },
  {
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'capitally',
    name: 'Capitally',
    origin: 'Poland',
    pricingPerYear: '€50',
    slogan: 'Optimize your investments performance'
  },
  {
    founded: 2022,
    isArchived: true,
    key: 'capmon',
    name: 'CapMon.org',
    origin: 'Germany',
    note: 'CapMon.org was discontinued in 2023',
    slogan: 'Next Generation Assets Tracking'
  },
  {
    founded: 2019,
    key: 'compound-planning',
    name: 'Compound Planning',
    origin: 'United States',
    slogan: 'Modern Wealth & Investment Management'
  },
  {
    founded: 2019,
    hasFreePlan: false,
    hasSelfHostingAbility: false,
    key: 'copilot-money',
    name: 'Copilot Money',
    origin: 'United States',
    pricingPerYear: '$70',
    slogan: 'Do money better with Copilot'
  },
  {
    founded: 2020,
    key: 'de.fi',
    languages: ['English'],
    name: 'De.Fi',
    slogan: 'DeFi Portfolio Tracker'
  },
  {
    founded: 2017,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'delta',
    name: 'Delta Investment Tracker',
    note: 'Acquired by eToro',
    origin: 'Belgium',
    slogan: 'The app to track all your investments. Make smart moves only.'
  },
  {
    founded: 2019,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'divvydiary',
    languages: ['Deutsch', 'English'],
    name: 'DivvyDiary',
    origin: 'Germany',
    pricingPerYear: '€65',
    slogan: 'Your personal Dividend Calendar'
  },
  {
    founded: 2009,
    hasSelfHostingAbility: false,
    key: 'empower',
    name: 'Empower',
    note: 'Originally named as Personal Capital',
    origin: 'United States',
    slogan: 'Get answers to your money questions'
  },
  {
    alias: '8figures',
    founded: 2022,
    key: 'eightfigures',
    name: '8FIGURES',
    origin: 'United States',
    slogan: 'Portfolio Tracker Designed by Professional Investors'
  },
  {
    founded: 2010,
    hasFreePlan: false,
    key: 'etops',
    name: 'etops',
    origin: 'Switzerland',
    slogan: 'Your financial superpower'
  },
  {
    founded: 2020,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'exirio',
    name: 'Exirio',
    origin: 'United States',
    pricingPerYear: '$100',
    slogan: 'All your wealth, in one place.'
  },
  {
    founded: 2023,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'fina',
    languages: ['English'],
    name: 'Fina',
    origin: 'United States',
    pricingPerYear: '$115',
    slogan: 'Flexible Financial Management'
  },
  {
    founded: 2023,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'finanzfluss-copilot',
    name: 'Finanzfluss Copilot',
    origin: 'Germany',
    pricingPerYear: '€69.99',
    slogan: 'Portfolio Tracker für dein Vermögen'
  },
  {
    founded: 2020,
    key: 'finary',
    languages: ['Deutsch', 'English', 'Français'],
    name: 'Finary',
    origin: 'United States',
    slogan: 'Real-Time Portfolio Tracker & Stock Tracker'
  },
  {
    founded: 2021,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'finateka',
    languages: ['English'],
    name: 'FINATEKA',
    origin: 'United States',
    slogan:
      'The most convenient mobile application for personal finance accounting'
  },
  {
    founded: 2023,
    hasFreePlan: true,
    key: 'finwise',
    name: 'FinWise',
    origin: 'South Africa',
    pricingPerYear: '€69.99',
    slogan: 'Personal finances, simplified'
  },
  {
    founded: 2021,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'firekit',
    languages: ['English', 'українська мова'],
    name: 'FIREkit',
    origin: 'Ukraine',
    pricingPerYear: '$40',
    slogan: 'A simple solution to track your wealth online'
  },
  {
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'folishare',
    languages: ['Deutsch', 'English'],
    name: 'folishare',
    origin: 'Austria',
    pricingPerYear: '$65',
    slogan: 'Take control over your investments'
  },
  {
    founded: 2020,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'getquin',
    languages: ['Deutsch', 'English'],
    name: 'getquin',
    origin: 'Germany',
    pricingPerYear: '€48',
    slogan: 'Portfolio Tracker, Analysis & Community'
  },
  {
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'gospatz',
    name: 'goSPATZ',
    origin: 'Germany',
    slogan: 'Volle Kontrolle über deine Investitionen'
  },
  {
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'holistic-capital',
    languages: ['Deutsch'],
    name: 'Holistic',
    origin: 'Germany',
    slogan: 'Die All-in-One Lösung für dein Vermögen.',
    useAnonymously: true
  },
  {
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    isArchived: true,
    key: 'intuit-mint',
    name: 'Intuit Mint',
    note: 'Intuit Mint was discontinued in 2023',
    origin: 'United States',
    pricingPerYear: '$60',
    slogan: 'Managing money, made simple'
  },
  {
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'investify',
    name: 'Investify',
    origin: 'Pakistan',
    slogan: 'Advanced portfolio tracking and stock market information'
  },
  {
    founded: 2011,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'justetf',
    name: 'justETF',
    origin: 'Germany',
    pricingPerYear: '€119',
    slogan: 'ETF portfolios made simple'
  },
  {
    founded: 2016,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'koyfin',
    name: 'Koyfin',
    origin: 'United States',
    pricingPerYear: '$468',
    slogan: 'Comprehensive financial data analysis'
  },
  {
    founded: 2019,
    hasFreePlan: false,
    hasSelfHostingAbility: false,
    key: 'kubera',
    name: 'Kubera®',
    origin: 'United States',
    pricingPerYear: '$150',
    slogan: 'The Time Machine for your Net Worth'
  },
  {
    founded: 2021,
    hasFreePlan: false,
    key: 'leafs',
    languages: ['Deutsch', 'English'],
    name: 'Leafs',
    origin: 'Switzerland',
    slogan: 'Sustainability insights for wealth managers'
  },
  {
    founded: 2018,
    hasFreePlan: false,
    hasSelfHostingAbility: false,
    key: 'magnifi',
    name: 'Magnifi',
    origin: 'United States',
    pricingPerYear: '$132',
    slogan: 'AI Investing Assistant'
  },
  {
    founded: 2022,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'markets.sh',
    languages: ['English'],
    name: 'markets.sh',
    origin: 'Germany',
    pricingPerYear: '€168',
    regions: ['Global'],
    slogan: 'Track your investments'
  },
  {
    founded: 2010,
    key: 'masttro',
    name: 'Masttro',
    origin: 'United States',
    slogan: 'Your platform for wealth in full view'
  },
  {
    founded: 2021,
    hasSelfHostingAbility: false,
    isArchived: true,
    key: 'maybe-finance',
    languages: ['English'],
    name: 'Maybe Finance',
    note: 'Maybe Finance was discontinued in 2023',
    origin: 'United States',
    pricingPerYear: '$145',
    regions: ['United States'],
    slogan: 'Your financial future, in your control'
  },
  {
    hasFreePlan: false,
    hasSelfHostingAbility: false,
    key: 'merlincrypto',
    languages: ['English'],
    name: 'Merlin',
    origin: 'United States',
    pricingPerYear: '$204',
    regions: ['Canada', 'United States'],
    slogan: 'The smartest way to track your crypto'
  },
  {
    founded: 1991,
    hasSelfHostingAbility: true,
    isArchived: true,
    key: 'microsoft-money',
    name: 'Microsoft Money',
    note: 'Microsoft Money was discontinued in 2010',
    origin: 'United States'
  },
  {
    founded: 2019,
    hasFreePlan: false,
    hasSelfHostingAbility: false,
    key: 'monarch-money',
    name: 'Monarch Money',
    origin: 'United States',
    pricingPerYear: '$99.99',
    slogan: 'The modern way to manage your money'
  },
  {
    founded: 1999,
    hasFreePlan: false,
    hasSelfHostingAbility: true,
    key: 'moneydance',
    name: 'Moneydance',
    origin: 'Scotland',
    pricingPerYear: '$100',
    slogan: 'Personal Finance Manager for Mac, Windows, and Linux'
  },
  {
    hasFreePlan: false,
    hasSelfHostingAbility: false,
    key: 'monse',
    name: 'Monse',
    pricingPerYear: '$60',
    slogan: 'Gain financial control and keep your data private.'
  },
  {
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'morningstar-portfolio-manager',
    languages: ['English'],
    name: 'Morningstar® Portfolio Manager',
    origin: 'United States',
    slogan:
      'Track your equity, fund, investment trust, ETF and pension investments in one place.'
  },
  {
    founded: 2017,
    hasFreePlan: false,
    hasSelfHostingAbility: false,
    key: 'navexa',
    name: 'Navexa',
    origin: 'Australia',
    pricingPerYear: '$90',
    slogan: 'The Intelligent Portfolio Tracker'
  },
  {
    founded: 2020,
    hasSelfHostingAbility: false,
    hasFreePlan: true,
    key: 'parqet',
    name: 'Parqet',
    note: 'Originally named as Tresor One',
    origin: 'Germany',
    pricingPerYear: '€88',
    regions: ['Austria', 'Germany', 'Switzerland'],
    slogan: 'Dein Vermögen immer im Blick'
  },
  {
    founded: 2023,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'plainzer',
    languages: ['English'],
    name: 'Plainzer',
    origin: 'Poland',
    pricingPerYear: '$74',
    slogan: 'Free dividend tracker for your portfolio'
  },
  {
    founded: 2023,
    hasSelfHostingAbility: false,
    key: 'plannix',
    name: 'Plannix',
    origin: 'Italy',
    slogan: 'Your Personal Finance Hub'
  },
  {
    founded: 2008,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'pocketsmith',
    languages: ['English'],
    name: 'PocketSmith',
    origin: 'New Zealand',
    pricingPerYear: '$120',
    regions: ['Global'],
    slogan: 'Know where your money is going'
  },
  {
    hasFreePlan: false,
    hasSelfHostingAbility: false,
    key: 'portfolio-dividend-tracker',
    languages: ['English', 'Nederlands'],
    name: 'Portfolio Dividend Tracker',
    origin: 'Netherlands',
    pricingPerYear: '€60',
    slogan: 'Manage all your portfolios'
  },
  {
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'portfolio-visualizer',
    languages: ['English'],
    name: 'Portfolio Visualizer',
    pricingPerYear: '$360',
    slogan: 'Tools for Better Investors'
  },
  {
    hasFreePlan: true,
    isArchived: true,
    key: 'portfoloo',
    name: 'Portfoloo',
    note: 'Portfoloo was discontinued',
    slogan:
      'Free Stock Portfolio Tracker with unlimited portfolio and stocks for DIY investors'
  },
  {
    founded: 2021,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'portseido',
    languages: ['Deutsch', 'English', 'Français', 'Nederlands'],
    name: 'Portseido',
    origin: 'Thailand',
    pricingPerYear: '$96',
    slogan: 'Portfolio Performance and Dividend Tracker'
  },
  {
    founded: 2021,
    hasFreePlan: true,
    hasSelfHostingAbility: true,
    key: 'projectionlab',
    name: 'ProjectionLab',
    origin: 'United States',
    pricingPerYear: '$108',
    slogan: 'Build Financial Plans You Love.'
  },
  {
    founded: 2015,
    hasSelfHostingAbility: false,
    key: 'rocket-money',
    name: 'Rocket Money',
    origin: 'United States',
    slogan: 'Track your net worth'
  },
  {
    founded: 2019,
    hasSelfHostingAbility: false,
    isArchived: true,
    key: 'sarmaaya.pk',
    name: 'Sarmaaya.pk Portfolio Tracking',
    note: 'Sarmaaya.pk Portfolio Tracking was discontinued in 2024',
    origin: 'Pakistan',
    slogan: 'Unified platform for financial research and portfolio tracking'
  },
  {
    founded: 2004,
    hasFreePlan: false,
    hasSelfHostingAbility: false,
    key: 'seeking-alpha',
    name: 'Seeking Alpha',
    origin: 'United States',
    pricingPerYear: '$239',
    slogan: 'Stock Market Analysis & Tools for Investors'
  },
  {
    founded: 2022,
    key: 'segmio',
    name: 'Segmio',
    origin: 'Romania',
    slogan: 'Wealth Management and Net Worth Tracking'
  },
  {
    founded: 2007,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'sharesight',
    name: 'Sharesight',
    origin: 'New Zealand',
    pricingPerYear: '$135',
    regions: ['Global'],
    slogan: 'Stock Portfolio Tracker'
  },
  {
    hasFreePlan: true,
    isArchived: true,
    key: 'sharesmaster',
    name: 'SharesMaster',
    note: 'SharesMaster was discontinued',
    slogan: 'Free Stock Portfolio Tracker'
  },
  {
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'simple-portfolio',
    name: 'Simple Portfolio',
    origin: 'Czech Republic',
    pricingPerYear: '€80',
    slogan: 'Stock Portfolio Tracker'
  },
  {
    founded: 2021,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'snowball-analytics',
    name: 'Snowball Analytics',
    origin: 'France',
    pricingPerYear: '$80',
    slogan: 'Simple and powerful portfolio tracker'
  },
  {
    founded: 2019,
    hasSelfHostingAbility: false,
    key: 'stock-events',
    name: 'Stock Events',
    origin: 'Germany',
    slogan: 'Track all your Investments'
  },
  {
    key: 'stockle',
    name: 'Stockle',
    origin: 'Finland',
    slogan: 'Supercharge your investments tracking experience'
  },
  {
    founded: 2008,
    isArchived: true,
    key: 'stockmarketeye',
    name: 'StockMarketEye',
    origin: 'France',
    note: 'StockMarketEye was discontinued in 2023',
    slogan: 'A Powerful Portfolio & Investment Tracking App'
  },
  {
    founded: 2011,
    hasFreePlan: true,
    key: 'stock-rover',
    languages: ['English'],
    name: 'Stock Rover',
    origin: 'United States',
    pricingPerYear: '$79.99',
    slogan: 'Investment Research and Portfolio Management'
  },
  {
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'stonksfolio',
    languages: ['English'],
    name: 'Stonksfolio',
    origin: 'Bulgaria',
    pricingPerYear: '€49.90',
    slogan: 'Visualize all of your portfolios'
  },
  {
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'sumio',
    name: 'Sumio',
    origin: 'Czech Republic',
    pricingPerYear: '$20',
    slogan: 'Sum up and build your wealth.'
  },
  {
    founded: 2016,
    hasFreePlan: false,
    key: 'tiller',
    name: 'Tiller',
    origin: 'United States',
    pricingPerYear: '$79',
    slogan:
      'Your financial life in a spreadsheet, automatically updated each day'
  },
  {
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'utluna',
    languages: ['Deutsch', 'English', 'Français'],
    name: 'Utluna',
    origin: 'Switzerland',
    pricingPerYear: '$300',
    slogan: 'Your Portfolio. Revealed.',
    useAnonymously: true
  },
  {
    founded: 2020,
    hasFreePlan: true,
    key: 'vyzer',
    name: 'Vyzer',
    origin: 'United States',
    pricingPerYear: '$348',
    slogan: 'Virtual Family Office for Smart Wealth Management'
  },
  {
    hasSelfHostingAbility: false,
    key: 'wallmine',
    languages: ['English'],
    name: 'wallmine',
    origin: 'Czech Republic',
    pricingPerYear: '$600',
    slogan: 'Make Smarter Investments'
  },
  {
    founded: 2019,
    hasFreePlan: false,
    key: 'wealthbrain',
    languages: ['English'],
    name: 'Wealthbrain',
    origin: 'United Arab Emirates',
    slogan: 'Portfolio Management System'
  },
  {
    founded: 2024,
    hasSelfHostingAbility: true,
    isArchived: true,
    key: 'wealthfolio',
    languages: ['English'],
    name: 'Wealthfolio',
    origin: 'Canada',
    slogan: 'Desktop Investment Tracker'
  },
  {
    founded: 2015,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    key: 'wealthica',
    languages: ['English', 'Français'],
    name: 'Wealthica',
    origin: 'Canada',
    pricingPerYear: '$50',
    slogan: 'See all your investments in one place'
  },
  {
    founded: 2018,
    hasFreePlan: true,
    key: 'wealthposition',
    name: 'WealthPosition',
    pricingPerYear: '$60',
    slogan: 'Personal Finance & Budgeting App'
  },
  {
    founded: 2018,
    hasSelfHostingAbility: false,
    key: 'wealthy-tracker',
    languages: ['English'],
    name: 'Wealthy Tracker',
    origin: 'India',
    slogan: 'One app to manage all your investments'
  },
  {
    key: 'whal',
    name: 'Whal',
    origin: 'United States',
    slogan: 'Manage your investments in one place'
  },
  {
    founded: 2021,
    hasFreePlan: true,
    hasSelfHostingAbility: false,
    isArchived: true,
    key: 'yeekatee',
    languages: ['Deutsch', 'English', 'Español', 'Français', 'Italiano'],
    name: 'yeekatee',
    note: 'yeekatee was discontinued in 2024',
    origin: 'Switzerland',
    regions: ['Global'],
    slogan: 'Connect. Share. Invest.'
  },
  {
    founded: 2004,
    hasFreePlan: false,
    hasSelfHostingAbility: false,
    key: 'ynab',
    name: 'YNAB (You Need a Budget)',
    origin: 'United States',
    pricingPerYear: '$99',
    slogan: 'Change Your Relationship With Money'
  },
  {
    founded: 2019,
    hasFreePlan: false,
    hasSelfHostingAbility: false,
    key: 'ziggma',
    name: 'Ziggma',
    origin: 'United States',
    pricingPerYear: '$90',
    slogan: 'Your solution for investing success'
  }
];
