#!/usr/bin/env python3


from __future__ import division # 파이썬3 스타일의 나누기 지원
import rospy
from std_msgs.msg import String
from EMOTIBOT_speak.srv import stt, sttResponse
import time
import os.path

import re # 정규 표현식 사용
import sys # 파이썬 인터프리터가 제공하는 변수나 함수를 제어할 수 있는 방법을 제공
from google.cloud import speech


import pyaudio
import playsound

from six.moves import queue

# Audio recording parameters
RATE = 16000
CHUNK = int(RATE / 10)  # 100ms1

flag = 0 


class MicrophoneStream(object):
    """Opens a recording stream as a generator yielding the audio chunks."""
    global flag

    def __init__(self, rate, chunk):
        self._rate = rate
        self._chunk = chunk

        # Create a thread-safe buffer of audio data
        self._buff = queue.Queue()
        self.closed = True

    def __enter__(self): #음성 데이터 스트림을 여는 코드
        self._audio_interface = pyaudio.PyAudio() #pyaudio 인스턴스화
        self._audio_stream = self._audio_interface.open( #음성을 녹음 또는 재생하기 위해 원하는 디바이스에서 스트림을 연다.
            format=pyaudio.paInt16,
            # The API currently only supports 1-channel (mono) audio
            # https://goo.gl/z757pE
            channels=1,
            rate=self._rate,
            input=True,
            frames_per_buffer=self._chunk,
            # Run the audio stream asynchronously to fill the buffer object.
            # This is necessary so that the input device's buffer doesn't
            # overflow while the calling thread makes network requests, etc.
            stream_callback=self._fill_buffer,
        )
#        for index in range(self._audio_interface.get_device_count()):
#            desc = self._audio_interface.get_device_info_by_index(index)
#            print("DEVICE: {device}, INDEX: {index}, RATE: {rate} ".format(device=desc["name"], index=index, rate=int(desc["defaultSampleRate"])))
    
        self.closed = False

        return self

    def __exit__(self, type, value, traceback):
        self._audio_stream.stop_stream()
        self._audio_stream.close()
        self.closed = True
        # Signal the generator to terminate so that the client's
        # streaming_recognize method will not block the process termination.
        self._buff.put(None)
        self._audio_interface.terminate()

        return self

    def _fill_buffer(self, in_data, frame_count, time_info, status_flags):
        """Continuously collect data from the audio stream, into the buffer.""" 
        self._buff.put(in_data)
        
        return None, pyaudio.paContinue

    def generator(self):
        while not self.closed:
            # Use a blocking get() to ensure there's at least one chunk of
            # data, and stop iteration if the chunk is None, indicating the
            # end of the audio stream.
                
            chunk = self._buff.get()
            if chunk is None:
                return
            data = [chunk]

            # Now consume whatever other data's still buffered.
            while True:
                try:
                    chunk = self._buff.get(block=False)
                    if chunk is None:
                        print('\n---while chunk is none---\n')
                        return
                    data.append(chunk)
                except queue.Empty:
                    break

            yield b"".join(data)

def listen_print_loop(responses):
    global flag
    rospy.init_node('EMOTI_stt', sys.argv)
    service_client = rospy.ServiceProxy('stt', stt)
    pub = rospy.Publisher('sound', String)
    """Iterates through server responses and prints them.

    The responses passed is a generator that will block until a response
    is provided by the server.

    Each response may contain multiple results, and each result may contain
    multiple alternatives; for details, see https://goo.gl/tjCPAU.  Here we
    print only the transcription for the top alternative of the top result.

    In this case, responses are provided for interim results as well. If the
    response is an interim one, print a line feed at the end of it, to allow
    the next result to overwrite it, until the response is a final one. For the
    final one, print a newline to preserve the finalized transcription.
    """
    num_chars_printed = 0
    for response in responses:
        print("call response]", response)
        if not response.results:
            continue

        # The `results` list is consecutive. For streaming, we only care about
        # the first result being considered, since once it's `is_final`, it
        # moves on to considering the next utterance.
        result = response.results[0]
        if not result.alternatives:
            continue

        # Display the transcription of the top alternative.
        transcript = result.alternatives[0].transcript # 글씨 입력
        # Display interim results, but with a carriage return at the end of the
        # line, so subsequent lines will overwrite them.
        #
        # If the previous result was longer than this one, we need to print
        # some extra spaces to overwrite the previous result
        overwrite_chars = " " * (num_chars_printed - len(transcript))

        if not result.is_final:
            sys.stdout.write(transcript + overwrite_chars + "\r")
            sys.stdout.flush()
            
            num_chars_printed = len(transcript)

        else:
            print("finish]", transcript + overwrite_chars)
            
            if transcript == "네":
                pass
            
            else:
                a = service_client(transcript + overwrite_chars)
                       
            # Exit recognition if any of the transcribed phrases could be
            # one of our keywords.
            num_chars_printed = 0

def main():
    # See http://g.co/cloud/speech/docs/languages
    # for a list of supported languages.

    language_code = "ko-KR"  # a BCP-47 language tag
    file_path = os.path.expanduser(os.path.join('~', 'config/stt_key.json'))
    client = speech.SpeechClient.from_service_account_file(file_path)
    config = speech.RecognitionConfig(
        encoding=speech.RecognitionConfig.AudioEncoding.LINEAR16,
        sample_rate_hertz=RATE,
        language_code=language_code,
        speech_contexts=[{"phrases":["하이 이모티"]}]
    )

    streaming_config = speech.StreamingRecognitionConfig(
        config=config,single_utterance=False, interim_results=True
    )
    with MicrophoneStream(RATE, CHUNK) as stream:
        audio_generator = stream.generator()
        requests = (
            speech.StreamingRecognizeRequest(audio_content=content)
            for content in audio_generator
        )

        responses = client.streaming_recognize(streaming_config, requests)

        # Now, put the transcription responses to use.
        listen_print_loop(responses)       

if __name__ == "__main__":
    main()