---
title: "The Technology of Computer Destruction"
categories:
- culture
content-tags:
- tech
- history
---

In the early days of computing, there was a healthy amount of resistance to the rise of data processing. Decades after the Nazis used Hollerith machines to orchastrate the Holocaust and decades before Facebook used a cloud full of likes to sell off the integracy of US democracy, there was plenty of cause to worry about how mass processing of records might affect society. Large, expensive machines served as good proxies for the large corporate and government bureacracies that were maintaining systems of debt, racism, and war.

One important artifact of that era is an article entitled _The Technology of Computer Destruction_, published anonymously by Boston's _Broadside & The Free Press_ and then Chicago's _Seed_. It was cited quite often from mainstream and industry journals in a panic widespread enough [the _New York Times_ called for calm](https://www.nytimes.com/1971/05/09/archives/computer-scare-talk-sabotage-fears-of-experts-discounted.html) on page 3. Despite this historic significance it has been nearly impossible to find online searches, but does appear in [a scan of the original publication](https://credo.library.umass.edu/view/full/mums1014-v08-n26-i001).

In hopes of making it more findable for future researchers, here it is as text, for easy reading by the ancestors of the machines it hoped to stop:

> Abstract: Techniques for destroying data files and computer installations quickly and permanently are described. This paper is for research purposes only, and is intended to add slightly to the sum total of human knowledge. The author is a computer scientist, and his responsibility ends there. The use to which such knowledge may be put, for good or evil, belongs to the studies of sociology, political science, social psychology, and situational ethics. Scholars in these fields may be found in other departments of the University.
>
> In order to destroy a computer, it is first necessary to gain access to it, and then, assuming that the owner and manager of the computer will be hostile to one's acts, to make one's egress without being apprehended or identified. Such skills belong to the science of criminology. Unfortunately, the literature in this area is very scarce, mainly because almost all criminologists are employed by the other side. The author has little experience to recommend here, being a thinker rather than a doer. A list of relevant ideas might include breaking and entering, picking locks, bribing guards, infiltrating the data processing industry and pulling inside jobs, wearing gloves and masks, and leaving the scene quickly without bothering to call a press conference.
>
> Data is stored on punched cards, magnetic tape, and disk files. Punched cards are usually stored in metal trays, which are pull-out drawers of steel filing cabinets that may be locked. If the cards are bent, ripped, or even seriously frayed at the edges, they cannot go through the card processing equipment. However, a damaged card can be examined by hand, and a new one punched on a card punching machine which has a keyboard like a typewriter. This is tedious work, but capitalism has an almost unlimited source of female slaves to get the job done. If there are many cards destroyed, and they are ripped in half and scattered, it will not be practical to restore the data file in this manner.
>
> Punched cards are often the source of original data in a large system, because they can be mailed or otherwise distributed, and then reassembled with the information on them at the central office, and also because a common way of introducing data into the computer is to have keypunch operators transcribe the data onto the cards from lists, in-voices, and other printed forms. During the next few years, there will be fewer keypunch operators needed as optical character recognition (OCR) machines become more common. These can read printed forms or microfilms directly and input the data to the computer.
>
> An interesting form of minor sabotage is to punch extra holes in every data card you come across: bills, checks, order forms, inventory cards, etc. The results may be surprising and pleasing. Many people doing that can really fuck up the system.
>
> Punched cards are the bulkiest way in which to store data. One reel of magnetic tape can store the information contained on many thousands of cards, and can be read or written at least 100 times as fast as cards can be read of punched. Any system with many punched cards will have tapes duplicating the information on the cards. One tape may have the entire card file as it exists now, and others will have the file as it stood yesterday, the day before, last week, the week before that, and perhaps one a month going back several years.
>
> If the company feels very uptight a-bout losing its records, it may have the backup tapes stored in vaults many hundreds of feet beneath the Rocky Mountains, somewhere near Denver. It is reassuring to know that after World War Ill your insurance company will give due consideration to your claim, especially that clause exempting them from liability in the event of war or riot. To destroy a reel of magnetic tape, one simply spools the tape out onto the floor and makes sure that it gets well kinked.
>
> Magnetic disk units may be of two types: either the disk stack is removable so that another disk stack with other data stored on it may be inserted. Disks are usually not used to store permanent files, but to hold information that is about to go into or come out of the computer or data that is an intermediate step in the processing of other data. This is because the computer can reach any information on the disk much faster than if it were on tape.
>
> The disk stack usually contains several disks arranged on top of each other on a common spindle. The spaces between the disks are wide enough to allow read/write heads to enter between the disks. Data is stored on the brown metal oxide surfaces of both the upper and the under side of each disk. The disk itself can be destroyed by scoring the surfaces with a knife or a screwdriver. The read/write heads found on disk units and on tape drives are expensive and can be destroyed by rasping the surface with the tiny slits in it with a file.
>
> Every computer has a core memory, although it may be enclosed and not visible. Cores are like tiny doughnuts 1/8-inch across or less. They are arranged in a three-dimensional lattice suspended with space around them, and supported by tiny wires that go through the holes in the cores. It resembles a three-dimensional bead weaving. Core memories are very expensive and can be completely destroyed by poking into them with a blunt object.
>
> The guts of any computer are its electronic circuits. They are arranged in racks which can be seen by opening (not pounding on) the metal doors of the computer. Most of the electronics in a modern computer are integrated circuits mounted on hard plastic cards that plug into the racks. The cards also have many silver printed circuit wires on them. The cards pull out of the racks and even have handles on them to make this easy. They can be destroyed by cracking them in half, but since they are both expensive and portable, one might also consider ripping them off. An underground engineer might build a computer with them to keep tabs on the FBI.
>
> An axe is not an effective weapon against a computer, and one should not waste time bludgeoning transformers, fans, or other bulky items. Cutting wires is quite effective, however. The wires attached to the pins behind the racks that the cards plug into are very vulnerable, and if enough of them are cut, the whole unit may have to be discarded. Another interesting place to cut wires are the fat cables made of many thin, multicolored wires bundled together. A pair of tin shears is suitable for this job.
> --
