---
title: "First Week with Apple Vision Pro"
categories:
- work
content-tags:
- apple
- tech
---

As luck would have it, we were visiting family back in the US when Apple Vision Pro deliveries began last week. So, a week after Shannon and I got ours, I want to log some initial impressions so in the future I can look back and laugh at how quaint they seem.

My initial setup froze upon the Optic ID setup, and it was impossible to recover without rebooting the device. Not a great start. Also the Zeiss registration for my optic inserts was not at all up to Apple standards. E.g. I has to manually enter a serial number (despite scanning a QR code to start) and this demands letters be uppercase, complaining that I did it wrong upon submission. 🙄

## Hardware

The headset is as heavy as I feared. I’ve learned how to balance the pressure on my cheeks and forehead, but I would never call it _comfortable_.

Why isn’t the battery connector MagSafe? It makes the whole assembly feel so much more fragile when not wearing it, knowing the heavy battery could easily drag the headset to the floor.

There are a lot of commercial uses, especially in field work, that will need a less fragile form factor (and still-better passthrough).

## Reality

I had to submit an old prescription, and mine is progressive (correcting for mild nearsightedness at the top, no correction below). The inserts I received seem to have an area, a horizontal zone about 1/3rd from the top, that is always blurry. It’s worse on the left eye. The lenses are clean and living in a country where they aren’t selling these means I have no real recourse to find a better set.

The FOV is smaller than I expected based on the marketing. I wish they’d done the Ambilight thing and at least added low-resolution illumination in the edges to reduce the tunnel effect.

The tracking is so much better than any other VR headset I’ve tried. But the motion blurring on the passthrough video when I move my head is distracting and makes me want to hold still.

In most cases I’ve found the color fidelity excellent, except from our living room at home. The rich grey tones of the cloudy Dutch sky and brick textures of Amsterdam canal houses outside all appear flat, as if our windows look onto backdrops that were painted in a rush.

The passthrough distortion correction is also excellent. Although today, after updating to visionOS 1.1 beta 2, I find that looking downwards (towards a MacBook on my lap) sometimes confuses the Vision and leads to a flickering of magnification. The illusion of transparency is strong enough to make these glitches quite unsettling.

## “Content”

On the flight home, I watched _Hugo_[^hugo] in 3D. I was in one of those Delta One first class “suites” where I had plenty of room to myself. This made it surprising how often the Vision Pro lost tracking while in travel mode, helpfully warning me not to look at windows (I was not near one). I also got to lie down flat, and became frustrated at how Apple’s goal of simulating a theater seemed to be more important than letting me comfortably lie down and watch a movie.

[^hugo]: A bit on-the-nose, featuring a 3D film about how innovative moving pictures were.

The pancakes lenses inevitably add some glare, especially when using the Cinema or other dark environments. Since I usually wear glasses it’s easy for me to shrug it off, but I imagine some will find it intolerable.

I had some problems with my iPhone taking back my AirPods Pro, which is a familiar flaw in the just-works world of Apple inter-device connectivity. It was more annoying, though, since connecting from within visionOS is laborious; I finally just turned off Bluetooth on my phone.

Being [stereoblind](/about/flaws/#stereoblindness) undoubtably messes with my perception of depth, but I do _feel_ the difference between normal and spatial videos, and immersive environments have a volume I don’t experience with 2D panoramas. (_Hugo_ didn’t feel as natural, more like watching a 3D film in a theater. It gave me an impression of the unreal, akin to the “soap opera effect” of high-framerate video.)

I believe panoramic spatial video in this sort of viewer is meaningfully better. Immersive really is the right word, there is really a sense of presence. The rumors that Apple is investing in live sports broadcasting make sense, and I expect virtual travel will be enjoyable. And maybe this product category is the one where Apple’s “no adult content” stance finally does hold back their success.

Mostly, I look forward to seeing what artists like Beyoncé can pull off. I’m still struggling to say what the Vision Pro is _for_, but it is easy to imagine spending time in it enjoying the vibes created by a favorite musician, like audiophiles of previous generations might have come home to enjoy a record. But it will need to be easier to sip whiskey while wearing one.

## Interaction

The virtual display for my MacBook is great. Not so much the size, but that it sits steady and can be positioned at a comfortable angle. This actually makes me think the screen less AR laptop is not a bad idea. But the weight means it's still a relief to take it off and go back to real displays, even just the cramped screen of a small laptop.

I have a lot of other notes about visionOS and the experience of using the headset among others, but this is already a lot so I will save those for a follow-up post.
