---
title: Design Systems at Scale
categories:
- work
content-tags:
- design
- ux
- dls
- philips
external: https://www.linkedin.com/pulse/design-systems-scale-hans-gerwitz
---

The Philips design system, Filament, is not yet public. But thanks to an [iF award](https://ifdesign.com/en/winner-ranking/project/philips-filament/542755) it is being openly discussed, so it's finally time for me to talk about what I think makes it special!

When you hear "design system" you may imagine a library of web components and standards that are used to bring consistency  and support the building of a complex web site or software product. There are [numerous examples](https://github.com/alexpate/awesome-design-systems) of these and some of them are quite inspiring.

Firms like Philips, though, call for something else. We have _hundreds_ of applications on a wide variety of tech stacks. These are as diverse as the mobile apps used to get the most from your toothbrush, web interfaces for a healthcare provider to manage their fleet of in-home monitoring devices, and the high-performance realtime imaging systems used by a surgeon to precisely guide their scalpel. This diversity was assembled through a long-term acquisition strategy that means the operating models of different business units can be as varied as the products they build.

Our long-running Design Language System (DLS) program aims to bring the benefits of consistency and efficiency across this dynamic portfolio. With Filament, we've learned to lean on a few key approaches to managing design systems at this scale:

## Open Governance

Filament is not quite centralized nor federated in the common parlance of design systems. Libraries include _core_ sets of assets that are centrally maintained and _approved_ assets that have been screened by central standards. Any product team can participate in the management of the quality standards and principles. The global brand may have a leading voice, but the perspectives of hands-on builders must be included. To bring so many voices together, it is sometimes necessary to create processes for alignment in narrow slices. These can be in two dimensions, either specific features such as authentication or abstraction levels like color attributes (via design tokens).

## Pace Layers

Local-global asynchrony sounds complicated, and it is; we need to allow product teams to work at their own pace while still moving everyone towards sharing. Some businesses are slowed by regulation and deliberation, others react to fast-moving markets. Monolithic libraries can experience shearing between these speeds. We avoid this by acknowledging distinct layers for business-local, central-approved, and core assets.

Thankfully, the adoption of **[innersource](https://en.wikipedia.org/wiki/Inner_source) practices** for software development and the [evolution of design tools](https://www.figma.com/best-practices/branching-in-figma/) offer scaffolding for this. Businesses can work with a local branch (or fork) of Filament and modify it with improvements and contributions without waiting for external partners. We offer incentives to use our infrastructure and benefit from a local system, which generally makes it discoverable by others trying to avoid reinvention. Critically, it also makes this content visible to the central team, who can proactively look for sharing opportunities.

Formal centralization is an asynchronous activity, with the DLS team actively pulling their local contributions into the global libraries. From there, they are published as versioned releases that are understandable as dependancies by product team planners.

The resulting system for sharing would be too vast to manage in the case of changes to quality and consistency standards, so the global libraries need a distinct core layer. The core is considered essential to UX quality and the Philips brand, so is maintained directly by central teams.

## Family of Languages

Diverse contexts of use are not only an operational challenge, but also complicate design languages. The consumer who uses apps for their connected household products has very different style preferences than a healthcare worker sifting through patient records for administration or reviewing images and data as part of a cancer-diagnosis team. They might have different expectations for information density versus simplicity, discoverability versus long-term efficiency, precision versus glanceability. To accommodate them all with a single design language can make it so flexible that it becomes incoherent, and so complex that it resists evolution.

So a small set of design languages with different principles and styles is necessary, even though managed as one design system. This comes with a lot of risk of fragmentation; it is important to have central leadership and strong governance processes to keep them from drifting apart, to prevent arbitrary creation of new languages, and to take every opportunity for them to share libraries and foundational assets.

## Triad of Libraries

Any successful design system weaves naturally into the workflow of the product teams using it. In a highly-structured linear model, there must be clear specifications that can be used as requirements and test criteria. A developer-led, agile team needs only a code library to pull from and some guidance for extending it. Teams engaging in upfront design for research and testing need design libraries to make prototypes that they know can be implemented with the code libraries. All of these models are present among Filament's users.

This diversity can be a barrier to adoption of a design system that has been optimized for one way of working. It also presents an opportunity for the system to encourage effective design-development cooperation. Filament seeks to address this with a triad of design, code, and documentation. Especially at the component level, each building block has a reference implementation in one code library (primarily React or native mobile) that is kept aligned with documentation and our leading design library (today in Figma). The effort to maintain this can become a constraint so is focused primarily on the core assets.

## Finished

We're finally talking about this now because Filament is complete and the approaches above are comprehensive.

Alright, that's not true. What I've described here is a snapshot of continuous learning. Our DLS program has run for many years and we are always experimenting to address the challenges mentioned above within a dynamic, changing organization. We're confident enough to suggest others can learn from our experience, but today's Filament represents only our best understanding so far and will certainly continue to evolve!
