---
title: Discovering Gemini
categories:
- work
- culture
content-tags:
- web
- gemini
- gopher
- oldschool
---

Reading the web is no longer enjoyable.

A new generation of developers understand the browser as an app environment. Rich applications are built to render simple content, meaning I have to wait for cute progress loaders, can’t count on the back button or bookmarks to work, and sometimes am even unable to select text for quoting.

The dominant business model is advertising, and the industry has not shown much restraint. I feel like a consumer more than a reader, clicking on headline bait only to dismiss a cookie notice, then a prompt to enter my email. Finally, I get to the “content” and can scroll past large stock image mastheads and filler introductions in hope of finding something worth reading.

It’s become [controversial to call the browser a document viewer](https://twitter.com/kocienda/status/1355344814166876163).

While I’m glad that my [browser-as-application platform dreams](https://hans.gerwitz.com/2003/11/26/client-servers-communicating-with-server-servers-through-clients.html) came true, I am sad it replaced the web I knew. Probably should have seen it coming, but it seemed so _unlikely_ we would give up the blogosphere.

For a very brief moment I thought Google missed it, too, but [AMP turned out to be a dumpster fire](https://80x24.net/post/the-problem-with-amp/). This should have been expected from the advertising company that practically killed RSS.

Anil Dash bemoans [the Web we lost](http://anildash.com/2012/12/13/the_web_we_lost/).

Robin Rendle hopes [newsletters might show us a way back to the web](https://www.robinrendle.com/essays/newsletters).

Frank Chimero is upset [we let everything become too illegible to just play with](https://frankchimero.com/writing/everything-easy-is-hard-again/).

Farhad Manjoo tells us [reading is for olds](https://www.nytimes.com/interactive/2018/02/09/technology/the-rise-of-a-visual-internet.html).

Me? I became [curious about the state of Gopher](https://pinboard.in/u:gerwitz/t:gopher/), an internet protocol that the web effectively replaced. There was still some energy, but the community seemed both fragmented and conservative (Gopher-II notwithstanding). I don’t have the attention to spare bootstrapping interest in a new “post-web” Gopher with decent URL handling, virtual hosting, and text formatting. I [created a space](/2019/09/16/i-have-a-new-gopher-space.html) and toyed around with some client code, but set it aside.

Lo and behold, some Gopher enthusiasts were just then bootstrapping [Gemini](https://gemini.circumlunar.space/)!

It's not quite what I had in mind because there is so little room for aesthetic self-expression. The godfather of Gemini, Solderpunk, is worried about the [slippery slope](https://lists.orbitalfox.eu/archives/gemini/2020/000612.html) any configurable styling provides, so everything feels a bit too _line printer_ at this stage. This soil will not lead to a new bloom of MySpace and Geocities pages.

Some browsers are (thankfully) inlining images, so we could end up with a new crop of Tumblrs or DeviantArts! I hope we see some extensions emerge for capsule branding, such as favicons and accent colors. But I must note that limitations are, after all, the point. As [Björn Wärmedal said](https://lists.orbitalfox.eu/archives/gemini/2020/004218.html):
> Gemini isn't meant to be a reinvention of the wheel, just a nicer pair of hiking boots.

These new constraints will breed new creative projects. Most importantly, the protocol and the file format are so simple that writing browsers could become a fun exercise, the way Twitter clients once were. Let's hope for a rich world of Gemini browsers that lead to species we haven't yet imagined.

I'm starting with an old-fashioned "home page" at [gemini://tilde.club/~gerwitz/launch/](gemini://tilde.club/~gerwitz/launch/). If you don't have a `gemini:` browser, you can explore the space via a [proxy](https://gem.ondollo.com/external/tilde.club/~gerwitz/launch).
