---
title: "Pandemic Fears"
categories:
- culture
content-tags:
- usa
- eu
- covid
---

Reading about the pandemic as a social phenomenon, setting aside the physiological and emotional toll on the sick and their loved ones, I see two themes in our colllective imagination for the post-pandemic future. One is for a return to normal, which is a natural reaction to crisis. The other, dreamt mostly by those who have been oppressed by the status quo (or those who advocate for them), imagines how the pandemic might serve as a great reset and bring our attention back towards social justice and sustainability.

I see far less discussion about the ways post-pandemic world might be worse. It’s important to consider what opportunities there are to make the future even darker, through evil or ineptitude, so we might work to avoid them. So I am collecting my thoughts about how we can make the world a worst place after the COVID-19 coronavirus is no longer novel.

After turmoil in the health and prosperity of people, concern about the environment will be seen as a luxury by many. Fear of sudden shocks can keep us focused on the short term, so we’ll be less anxious about the slow collapse of the planet. It might get harder for environmental issues of any sort to get attention.

Social distancing measures mean most of humanity will be spending time with our in-groups, with plenty of time to demonize the out-groups without challenge. Specifically, a lot of us in the privileged world are escaping online[^tv], where we can chose or be algorithmically served information that confirms our biases and tickles our amygdala rather than confronting any real-life diversity.
After months of this we may have even stronger resistance to accepting differences, resulting in more conflict.

[^tv]: For me, “being online” includes passively consuming broadcast TV news.

In the US, the government is trying to preserve "the economy" via commercial banking. Reminiscent of post-war real estate redlining policies, this will enshrine inequity and biases in that private world. Meanwhile, social-distancing-as-a-service will naturally thrive and also support the thriving of Internet-scale corporations while small businesses falter.[^less-small]

[^less-small]: By May this is [already noticable](https://www.theatlantic.com/ideas/archive/2020/05/bridge-post-pandemic-world-already-collapsing/611089/).

Urbanization will fall out of favor as density is correlated with infection rates. This association may not be supported by analysis at meaningful scales, but it is easy to intuit so will reinforce existing preferences. Some of us who dwell in cities today might imagine that the suburban experience was nicer during lockdowns. Cholera and the 1918 flu pandemic helped fuel City Beautiful, the White Castle aesthetics of Le Corbusier, and the suburban sprawl served mostly by the remaining large businesses. We'll be afraid to crowd together into public transport, so car culture will get a boost.

Neoliberals, especially the American right, may make larger steps toward their goal of minimal social government by using their usual narrative about incompetence.[^reagan] They'll be supported by a few big defensive corporations hoping to avoid scrutiny for their profiteering during the crisis and looking to profit off of privatization in the aftermath.

[^reagan]: This is, of course, [the plan](https://twitter.com/donmoyn/status/1249078579868119040).

In Europe, divisions over economic issues and performance are damaging the union, and the EU is failing to seize this moment to demonstrate its necessity. Euroskeptics in the south may not win exit campaigns, but compromise with leaving the Eurozone and returning to individual sovereign currencies.

I hope I'm wrong about all of these.
