---
title: Jeff's High Frontier
categories:
- culture
content-tags: [space, future, amazon]
---

At space industry conference [SATELLITE](https://2019.satshow.com/) in May, Jeff Bezos did the billionaire-with-a-vision thing and unveiled Blue Origin's lunar lander. As is routine, the internet tweeted hot takes of his [presentation](https://www.youtube.com/watch?v=GQ98hGUe6FM) nearly in realtime, not even taking the time to let him finish, much less spend a moment thinking about it.

I understand his ambitions in the context of the [Space Studies Institute](http://ssi.org/), which is "rebooting" with a [conference in Seattle](http://ssi.org/ssi-50-the-space-settlement-enterprise/) later this year. SSI was founded by physicist Gerard O'Neill, who Bezos studied under at Princeton and even cited in the opening of the SATELLITE talk. He also echoed many of the assertions in O'Neill's own late-life ["vision" presentation](https://www.youtube.com/watch?v=Pdtc9eXenJc) quite directly:

- There is a strong correlation between energy use and standard of living.
- Earth is finite and gravity is strong, so we must exploit in-space material and energy resources.
- NASA is too conservative, we need to harness the power of capitalism to progress.
- To expand we need not grand goals, but iterative investment in infrastructure.
- To bootstrap space colonization we must stay on the moon, not only visit.
- We need to make beautiful, enjoyable space habitats if we're going to live there. This means nature, which requires scale.

<figure>
<img src="/media/2019-07-09-blue-origin/rickguidice.jpg" alt="Stanford Torus">
<span class="margin note">One of the classic <a href="http://www.rickguidice.com/nasaart/nasaarti.html">Rick Guidice illustrations</a>from 1975.</span>
</figure>

Bezos even showed renderings of future space habitats that mimicked those from O'Neill's _[The High Frontier](https://www.goodreads.com/book/show/405001.The_High_Frontier)_.
These graphics have been soundly mocked for including farms, wildlife, and replica cities. But the originals were unrealistically suburban, themselves, in a purposeful attempt to bring familiarity to the concept. He was trying to inspire and sell a vision for our distant future, not predict or prescribe it.

<blockquote>
<p>Earth is the best planet, it isn't close. We do need to protect it, it's essential, it's our job. <strong>We're now big enough now to hurt this planet.</strong></p>
<footer>Jeff Bezos, <a href="https://www.blueorigin.com/news/going-to-space-to-benefit-earth-full-event-replay">May 9, 2019</a></footer>
</blockquote>

There was also a lot of hand-wringing about our captains of industry giving up on Earth. Yet the presentation was peppered with "we must take care of Earth" statements to an annoying degree. Many observers seem upset by the fatalism around energy; Earth is finite and there is an upper limit on our use of energy. But we cannot use simply use less because human well-being is correlated with energy use, and not enough of us would prefer to make fewer humans.

Again, this is long-term worrying from the man who has spent $42 million helping to build a 10,000 year clock. It is an uncomfortable truth but also [basic science](https://www.npr.org/sections/13.7/2016/10/01/495437158/climate-change-and-the-astrobiology-of-the-anthropocene). Get over it and start working on the (social) problem.[^veg]

[^veg]: It would certainly be a nice start if leaders like Bezos got realistic about our food supply. Eating cows is not critical to our well-being.

<blockquote>
<p>Rigidity is characteristic of a system which is just about to be replaced something better.</p>
<footer>Gerard K O'Neill, <cite><a href="https://www.youtube.com/watch?v=Pdtc9eXenJc">The Vision</a></cite><footer>
</blockquote>

I myself have some discomfort with one component of Bezos's vision. Given that NASA today is conservative and underfunded, he follows in the footsteps of his mentor, who concluded that government is feckless and only business can make the future. This is natural [puddle thinking](https://www.goodreads.com/quotes/7480263-this-is-rather-as-if-you-imagine-a-puddle-waking), since the business world has given us Amazon and thus Blue Origin.

In the short term, I think his pep talk to entrepreneurs is well aimed. Capitalism is the most powerful organizing function we have, at least in the West.

In the long term, as we progress into space while also confronting the challenges of a changing planet, to assume today's means of organizing our resources will suffice seems akin to asserting our space habitats will have red barns and open crop fields.

<blockquote>
<p>Oh stop teasing, Jeff 😉</p>
<footer><a href="https://twitter.com/elonmusk/status/1126686813840535552">Elon Musk</a></footer>
</blockquote>

While I'm musing about Bezos's lunar ambitions, I have to note the contrast with Elon Musk. The Blue Origin presentation threw plenty of shade at SpaceX: asserting that Mars is simply too far for the communications we need to bootstrap, gloating about on-time launch records and availability despite weather, and differentiating between refurbishment and ready reuse of flight vehicles.

Musk was far less subtle in reacting, tweeting a modified image of the lunar lander that read "blue balls" to the roaring approval of his shitposting followers. This was 6 hours after subtweeting his approval of a reckless Tesla porn video.

The contrast in the public presence and the inevitable community of admirers attracted to each of our space oligarchs is remarkable.
