---
title: 'The Artificial Genesis'
abstract: "The story of why we created The Artificial"
categories:
- work
content-tags:
- theartificial
- design
- bauhaus
- brand
external: https://theartificial.com/blog/2018/06/07/the-artificial-genesis.html
---

The story of why we created The Artificial is oft-told but hasn't been written. Let's correct that!

## We'd Moved Our Cat

Shannon and I didn't plan to start our own studio yet, but when our big-agency employer unexpectedly asked us to return from Amsterdam to Seattle, we instead went out on our own. We had already moved our cat, so it just made sense to stay.

Also, we had decided years ago that Amsterdam was our favorite European city, and living here for one winter was simply insufficient.

We discovered the best way for us as Americans to remain legal residents was to form a Dutch company. So we did.

## Design Is a Handcraft

Soon after, we took the train to Berlin to visit a friend. While there, we stumbled upon the [Museum of Things](http://www.museumderdinge.org/institution/historical-key-topic) and, like many before us, were prompted to consider the nuances of crafted things and manufactured objects.[^dinge] As an artist, Shannon believes the process of making things receives more value from the human touch than can be offset with the scale and precision of machine tooling. Here, we saw evidence of how this view was widely held until mass production drove a cultural shift (in the West) away from artful manufacturing.

[^dinge]: See also [Justin McGuirk thinking about Heidegger's "things" and "objects"](https://www.theguardian.com/artanddesign/2012/sep/17/dangerous-design-museum-of-things)

As an overreaction to this cultural shift, there is a recurring fashion in the design world that celebrates “natural” interface design. At the time, [NUI](https://en.wikipedia.org/wiki/Natural_user_interface) was a very fashionable idea, asserting that waving our hands in the air towards a TV is more natural than touching glass and simulating physical interaction. A related idea suggests that the best interfaces are invisible, as if human perception of the environment is a tedious activity to be avoided.

We assert that this neophilia is only the other side of the industrial production coin, and both overlook that humans find meaning in affordances and the use of tangible tools.

One manifestation of this assertion is our logos. Algorithmic generative logos were very trendy when we started, some self-consciously digital and others simulating organic forms. Shannon twisted this approach and established a brand that includes every Artificer generating their own logo, by hand, as an act of design.

## Beauty Matters

There is a sublime beauty in some natural phenomena, but the human-made can also be judged aesthetically. Some products are more beautiful than others.

In the tradition of Kant, we value the judgment of this beauty as a means to communicate with and influence the user. Indeed, the aesthetic perception is often a more powerful behavioral force than rational thought.[^kant]

[^kant]: The [Critique of Judgement](http://www.iep.utm.edu/kantaest) is too often overlooked as the book where Kant balanced his previous attention to pure reason.

As Don Norman put it, [attractive things work better](http://www.jnd.org/dn.mss/emotion_design.html).

The Artificial has a reputation for beautiful designs that fit within the fashions of the year but still feel fresh. I credit this to our prioritization of handcrafted beauty over mechanical scale.

## Digital Design Needs a Bauhaus

> Bilden wir also eine neue Zunft der Handwerker ohne die klassentrennende Anmaßung, die eine hochmütige Mauer zwischen Handwerkern und Künstlern errichten wollte!

Also in Berlin, we enjoyed the [Bauhaus-Archiv](https://www.bauhaus.de/) and were inspired by [Walter Gropius‘s manifesto](https://www.bauhaus100.de/en/past/works/education/manifest-und-programm-des-staatlichen-bauhauses/index.html) and their curricula that blended art with craft.

[^flat]: There are some who have thought to apply Bauhaus principles to digital design as “authentically digital” [aesthetic simplification](http://johnnyholland.org/2011/04/the-ixd-bauhaus-what-happens-next/) with a distaste for “ornament”. We discern a more [descriptive interpretation](https://www.smashingmagazine.com/2010/03/does-form-follow-function/) of the their adopted mantra “form follows function” that elevates function without demeaning the (Kantian) aesthetic experience.

Our recent experiences had been full of silo frustration. Shannon’s skills with aesthetics earned her a “visual designer” badge that frustrated her need to engage in the holistic design of products. It often fell to her to correct prior “functional” design to suit the product’s purpose. My experiences were similar, both as a geek who should only worry about how to build someone else’s dream and as a business strategist who was asked to rationalize but not influence design decisions.

We were primed, then, to try our hands at a studio that blended business needs, technical understanding, and human aesthetic intuition. We wanted to go beyond the usual agency Design + Business + Tech sales slide and build an actual holistic practice.

Today we are proud to see designers learn to treat software platforms as materials that can be molded once understood. Pushing everyone to expand their generalist perspective has especially paid off in efficiency; we needn't staff each project with specialized researchers, interaction designers, visual designers, animators, copywriters, and a project manager to coordinate them all.

## Safe and Challenging

As our studio began to take shape in our minds, another priority came up: a no asshole rule. A holistic design studio is inevitably a consultancy, and consultancies seem particularly adept at fostering bullies. The work of UX design is already emotionally taxing, neither designers nor their work benefits from fear and intimidation.

Of course, "safe" can be misconstrued as "easy". We want everyone to be growing, and acknowledge that growth is very often difficult and taxing. It takes a continual, conscious effort to keep even a small studio feeling like a safe place to work. We must complement that with an endeavor to challenge designers to do their best work while growing their own skills.

We have signs that this undertaking is productive. As we became established, we have found a large majority of qualified candidates are women. And an Artificer who has decided to move on usually comments that they rarely felt vulnerable but almost always felt challenged to grow.

## The Name

It took us weeks to find an agency name that felt right. Considering our goal of bringing holistic craftsmanship to a design practice, Bauhaus references were tempting but had too much hubris. Seeding our exploration with terminology around craft it was notable that contemporary English lacks for vocabulary with positive connotations for the work of humans. “Artisanal” is common, but these days evokes hipster coffee cafés before great works of architecture.

So we dug back into history, and found the allegory of King Charles II telling Christopher Wren his Cathedral of St. Paul was “awful and artificial” as a compliment.[^wren]

[^wren]: See [Quote Investigator](http://quoteinvestigator.com/2012/10/31/st-pauls-cathedral/) for the best research into this allegory.

“The Artificial” has been successful as a brand component that invites consideration and discussion, though the renaissance of machine learning has certainly prompted many explanations that we aren’t focused on applications of artificial intelligence.

I believe it expresses well the intention that our work must be artful and authentic to ourselves as makers.
