---
title: "The Artificial, Week 251: Tools"
abstract: "Another week of The Artificial"
categories:
- work
content-tags:
- weeknotes
- theartificial
external: https://theartificial.com/blog/2018/01/27/week-251.html
---

Culture includes tools, so selecting our tools is more than matching feature lists. They need to support our style of work or encourage us to change in ways we appreciate. We must accommodate some bad design, but need to avoid too much frustration or, worse, tainting our environment with anti-inspiration.

Of course, costs are also a concern. At our scale, we’re not small enough to shrug off per-user charges, because I don’t want to add to the “one more seat" financial impact of every individual hire. But we’re also not so big that we can absorb typical corporate IT inefficiency with "enterprise" plans. Many lean-era startups use pricing models that seem aimed at freelancers or 50-person companies, creating a gap for small teams that.

So, as a form of advice for others in similar situations, here are some of the tools we're happy enough to pay for:

[Adobe Creative Cloud](https://www.adobe.com/nl/creativecloud/business/teams.html) is really still Creative Suite for our purposes; we depend heavily on Illustrator and InDesign. Their cloud services don’t fit us, because we can’t lock into only Adobe for everything, and their team features are not that strong anyway.

[Slack](https://slack.com/) is pretty integral to our workflow. It's easy to imagine replacing it with another IRC clone with GIFs, but we would be crippled without chatrooms.

[Dropbox](https://www.dropbox.com/business) means we don't have to maintain servers or backups. Though we do have an on-site NAS syncing with it, just in case.

[Xero](https://www.xero.com/) is our accounting software. I'd like it to be more project-aware and there are many UX nits to pick, but it has been solid for 4 years[^freeagent] and I've never been seriously tempted by anything else.

[^freeagent]: We originally used FreeAgent, which is a nicer tool for very small teams but doesn't scale as well as Xero.

[Github](https://github.com/business) brings peace of mind but understanding git is still hard, even for the technically savvy. The new Github desktop app is, unfortunately, a step backwards in abstracting the complexity for users, but there is no better way for us to manage our code projects.[^site]

[^site]: The content of our website is also managed via git, which is an unusual choice for a design firm. Someday I'll write about this.

Some we use but don't feel very committed to include [G Suite](https://gsuite.google.com/) for email and calendaring, [Harvest](https://www.getharvest.com/) for time tracking, [Recruitee](https://recruitee.com/) for job applications, [iCloud](https://www.apple.com/icloud/) for sharing notes, [Heroku](https://www.heroku.com/) for hosting web apps, and [AWS](https://aws.amazon.com/) for hosting static sites.
