---
title: Temporal Binding
abstract: There is no clock.
categories:
- culture
content-tags:
- mind
- networks
- waves
- complexity
- perception
- biology
- attention
- bats
---

Today I learned [bats are able to ignore clutter by sending out harmonic sonar](http://jeb.biologists.org/content/217/16/2834.abstract) such that only signals from their target zone come back in sync. This harmonic is reflected in their neural network, of course, starting with the firing of the sensor neurons and cascading inwards. When reflected off a surface the bat is orienting towards, both harmonic components are received in sync. The neural patterns likewise synchronize and result in predictable anti-nodes with amplified signals. Presumably, a threshold filtering mechanism can thus easily detect a positive signal.

This is interesting[^tech] because it supports the neurology model of temporal binding,
oscillatory synchronization, which posits that oscillatory gamma synchronisation influences sensory perception. This model may be useful in understanding attention, as well as providing some insights into both [epilepsy](http://link.springer.com/article/10.1007/BF03178284) and [autism](http://www.citeulike.org/user/sam1001/article/2478210).

[^tech]: And also because we may [design better radar](https://news.brown.edu/articles/2014/08/sonar) by mimicking this technique.

I like to imagine a world of computing technology that was based on this sort of emergant synchronization rather than the explicit clock beats of modern digital computers.

In yet another instance of psychologist-neurologist semantic clashing, psychology also uses the term "temporal binding" in relation to perception, but at a much higher level regarding our judgements about causation and our relative sense of time. So learning about bat sonar also taught me about this research:

> if people believe that they (or someone or something else) are in charge, the time appears to pass faster.
> - Marc Buehner, [quoted by the APS](http://www.psychologicalscience.org/index.php/news/releases/causation-warps-our-perception-of-time.html)
