---
title: Gerrymandering
abstract: An inventory of alternative US state boundaries.
categories:
- culture
content-tags:
- cartography
- history
---

_Updated February 2019_

It's inevitable that we carve up geography to group people. Political borders are usually the result of negotiations between land-hungry powers, or politicians seeking to tweak group distribution.

Julian Oliver's [Border Bumping](http://borderbumping.net/) project has me thinking again about alternate motivations, so I've assembled some of my favorite alternative approaches to US cultural cartography:

![slavery](/media/2013-04-29-mapping/slavery.jpg)
William C. Reynold's [slavery map](http://myloc.gov/Exhibitions/lincoln/rise/TheNewLincoln/KansasNebraskaAct/ExhibitObjects/ReynoldsUSPoliticalMap.aspx) was one of the first artifacts that piqued my schoolboy interest in cartography. It may be quite simplistic, but was (and remains) very effective in communicating the state of the nation in 1856.

![allegiance](/media/2013-04-29-mapping/common.gif)
Michael Baldwin's [Common Census](http://commoncensus.org/maps.php) is my modern favorite, built by voluntary association with named places. It should be no surprise that cities are highly influential.[^city]

[^city]: or that [I consider this a more valid method of grouping than states](/2011/10/20/city-rights.html).

![dialect](/media/2013-04-29-mapping/dialects.gif)
Another favorite view is [Robert Delaney's dialect regions](http://www.uta.fi/FAST/US1/REF/dial-map.html), or [Rick Aschmann's similar work](http://aschmann.net/AmEng/).

![connections](/media/2013-04-29-mapping/connections.png)
Also using communication, MIT, AT&T, IBM, and probably some other [TLAs](http://www.catb.org/jargon/html/T/TLA.html) have mapped [socially connected regions based on mobile phone calls](http://senseable.mit.edu/csa/visuals2.html). Then with Vincent Blondel (of [phone identification](http://mit.edu/newsoffice/2013/de-anonymize-cellphone-data-0327.html) fame) they [went meta](http://www.theatlanticcities.com/arts-and-lifestyle/2012/04/invisible-borders-define-american-culture/1839/).

![pop vs soda](/media/2013-04-29-mapping/popvssoda.png)
Alan McConchie has an ongoing project to track what Americans [call soft drinks](http://www.popvssoda.com/) that shows some pretty clear boundaries.[^soda][^tea]

[^soda]: [Edwin Chen](http://blog.echen.me/2012/07/06/soda-vs-pop-with-twitter/) has mined Twitter for similar data.

[^tea]: See also the [sweet tea divide](http://bigthink.com/strange-maps/317-tea-as-a-northsouth-litmus-test).

![money movement](/media/2013-04-29-mapping/wheresgeorge.jpg)
Dirk Brockmann got a lot of attention mapping [areas of mobility](http://rocs.northwestern.edu/projects/community_structure.html) using paper currency tracking as a proxy[^mobility] and points out it corresponds well to [BEA Economic Areas](http://www.bea.gov/regional/bearfacts/countybf.cfm?sublist=next&areatype=econ).

[^mobility]: [Livehoods](http://livehoods.org/research) has similar goals using checkin data from Foursquare and operating at the city level.

![equal population](/media/2013-04-29-mapping/population.jpg)
Neil Freeman has drawn [fifty states of equal population](http://fakeisthenewreal.org/reform/).

![EPA ecoregions](/media/2013-04-29-mapping/ecoregions.png)
I wouldn't be a proud citizen of [Cascadia](http://www.cascadianow.org/about-cascadia/) if I didn't include [ecoregions](https://www.epa.gov/eco-research/ecoregions).

![Constellations](/media/2013-04-29-mapping/constellations.png)
With a [midnight mapping of star constellations](http://www.ifweassume.com/2013/01/mapping-constellations.html) to Earth's surface, Jim Davenport also finds a Cascadia in Corona Borealis.

![Starbucks](/media/2013-04-29-mapping/starbucks.png)
Davenport also cleverly uses Voronoi diagrams to define states based on [distance from Starbucks](http://www.ifweassume.com/2012/10/the-united-states-of-starbucks.html
).

![Capital Voronois](/media/2013-04-29-mapping/capitals.png)
Jonathan Dowse also uses Voronoi cells, but choses [existing state capital cities](http://jbdowse.com/poib/all/voronoi-states) for the vertices.

![City Voronois](/media/2013-04-29-mapping/cities.svg)
Jason Sundram uses Voronoi around each [existing state's largest city](http://viz.runningwithdata.com/states/). He also has capital and centroid models.

![Up in Arms](/media/2013-04-29-mapping/upinarms.jpg)
Colin Woodard looks to history to inform [11 nations](http://www.tufts.edu/alumni/magazine/fall2013/features/up-in-arms.html) of distinct cultures.

![Democrats](/media/2013-04-29-mapping/democrats.jpg)
Neil Freeman generated a fictional [states map](https://twitter.com/fitnr/status/799757798716346368) that would award Democrats the presidency every time this century.

![Clinton Electoral](/media/2013-04-29-mapping/clinton.png)
Kevin Hayes Wilson built a more nuanced [tool to redraw the states](http://kevinhayeswilson.com/redraw/) for speculative electoral outcomes for the 2016 presidential election. With it, he discovered [very small tweaks](https://medium.com/@khayeswilson/clinton-would-have-won-if-the-united-states-looked-like-this-7b9c844b76a9) like subtle shifts to the Wisconsin-Illinois and Florida-Alabama borders would have tipped the scales to Hillary Clinton.

![Commuter](/media/2013-04-29-mapping/commuter.png)
Alasdair Rae and Garrett Nelson studied [commuter patterns](http://www.sheffield.ac.uk/usp/news/commuter-data-reveals-us-megaregions-1.665740) which suggest megaregion partitions.

![California](/media/2013-04-29-mapping/california.jpg)
Rob Beschizza shows us what 8 states of [populations equal to California](http://boingboing.net/2017/03/02/america-divided-into-states-th.html) would look like.

![Connected](/media/2013-04-29-mapping/connected.png)
Emily Badger and Quoctrung Bui of the New York Times use [clusters of social connection](https://www.nytimes.com/interactive/2018/09/19/upshot/facebook-county-friendships.html) and find that state lines are strong boundaries.

![Watersheds](/media/2013-04-29-mapping/watersheds.png)
Robert Szucs [colored watersheds](https://www.reddit.com/r/MapPorn/comments/589sh9/requested_rivers_basins_of_the_us_in_rainbow/), which implies divisions but is suitably chaotic in the Great Basin.
