---
title: Checking Out
abstract: Online retailers are making a mistake by keeping payment and gratification
  decoupled.
categories:
- work
content-tags:
- design
- commerce
- web
- apple
- amazon
external: https://safelyignored.com/checkout
---

Luke Wroblewski has surveyed approaches of [optimizing checkout](http://www.lukew.com/ff/entry.asp?1579) in e-commerce applications. This is effort well spent. I am routinely surprised at how many online retailers commit simple sins of usability, and imagine I'm not alone in abandoning purchases when the pain of a checkout flow exceeds the value of that store's price or selection advantage.

Still, it may be naive to concern ourselves with the checkout process. Must the metaphor of "cart" and "checkout" endure?

Apple's "pick up in store" and Square's auto-opening tabs are already streamlining the physical pick-and-pay processes that the virtual shopping cart slavishly copies. On Amazon.com, one-click purchasing allows me to make impulse purchases with even less effort than adding them to Pinterest.

But one-click purchasing may not go far enough in reducing the friction that keeps my money in my wallet. Even clicking a button that means "pay" still carries more cognitive weight than simply nodding at the bakery clerk who recognizes me and adds my croissant to my Square tab.

For a brief period, those of us fortunate enough to live in Amazon's testing grounds were offered [Tote](https://tote.amazon.com/), where product pages gained an "Add to Tote" button. This did not trigger immediate payment, so the impulse to click that I-want-this button was as unencumbered as an "Add to Cart". Unlike a cart, though, no further action was required to complete purchase. When Tote day rolled around (they experimented with different frequencies), the contents of my Tote would be charged to my card on file around midnight and the goods would simply appear on my doorstep before I awoke.

It was an important attribute of that experience that the payment event did not feel randomly timed, but was closely aligned to delivery. This immediacy of service allowed Amazon to couple payment with receipt rather than selection (as with one-click).

Tote was an experiment, and was only available in a subset of the already-constrained geography of Amazon Fresh, so it's probably not going to appear in your neighborhood soon. But if the "free super-saver shipping" order I recently received via overnight OnTrac service is any indication, they are still actively prototyping delivery rapid enough to feel concurrent with payment.

Most online retailers still treat payment as a distinct event I must perform, not tied either to selecting or receiving the product. They are going to find it difficult to compete when Amazon quietly converts my expressed interest to a purchase, without further action from me, while satisfying my desire for control by handing me my goods right after charging me. Only physical stores can compete with that, and they have their own set of challenges competing on pricing and selection.

Maybe if my barista offered to hand me a bag full of things I had added to my wishlist [yesterday](http://www.youtube.com/watch?v=HA_gwzx39LQ)...
