---
title: Which Came First, the Word or the Quale?
abstract: Do our thoughts constrain our words, or vice-versa?
categories:
- culture
content-tags:
- psychology
- communication
- language
---

> The limits of my language are the limits of my mind. All I know is what I have words for.
> - [Ludwig Wittgenstein][1], [Tractatus Logico-Philosophicus][2], 1921

Guy Deutscher has upset linguistic anthropologists[^1] with his recent NYT Magazine piece, [Does Your Language Shape How You Think?][5] for misrepresenting the state of linguistic relativity research and, specifically, [Benjamin Lee Whorf’s hypothesis][6].

What goads me, however, is the point-counterpoint-anecdote style of modern journalism that's passing for science reporting in the popular press.  Beyond sensationalist Whorf-bashing, Deutscher spends most of his words on John Haviland's and Stephen Levinson's studies of the Guugu Yimithirr's reliance on cardinal directions, but doesn't spare any for the broader examples within that language[^2] or even closely-related research[^3].

The article asserts "habits of speech…can settle into habits of mind that go beyond language itself".  Worst, then, than any Whorf-bashing or survey myopia, is the failure to back up that claim.  Besides the Guugu Yimithirr example, Deutscher touches upon a few other popular studies that suggest a correlation between cognition and vocabulary.  He neglects even trying, though, to establish any causation.  Which leaves me wanting; since learning of the Whorf-Sapir hypothesis, I've been eager to discover research or even cogent theories that tease apart the influence of vocabulary from the whole of culture.

   [1]: http://plato.stanford.edu/entries/wittgenstein/
   [2]: http://www.gutenberg.org/etext/5740
   [3]: http://www.linguisticanthropology.org/2010/09/01/linguistic-relativity-whorf-linguistic-anthropology/
   [4]: http://neuroanthropology.net/2010/08/31/the-new-linguistic-relativism-guy-deutscher-in-the-nytimes/
   [5]: http://www.nytimes.com/2010/08/29/magazine/29language-t.html?_r=1
   [6]: http://plato.stanford.edu/entries/relativism/supplement2.html
   [7]: http://www.anthro.ucsd.edu/~jhaviland/Publications/How2TalkGY/How2TalkBiL.pdf
   [8]: http://www.edge.org/3rd_culture/boroditsky09/boroditsky09_index.html


[^1]: see the [SLA blog's defense][3] and [Greg Downey's overview][4].
[^2]: e.g. Haviland on [Guugu Yimidhirr's linguistic expression of  a "complicated calculus of social identities"][7].
[^3]: [Lera Boroditsky's work with the Kuuk Thaayorre][8] was my initial exposure to absolute spatial Aborigine language
