---
title: Reintroducing Saint Louis to the Mississippi
categories:
- uncategorized
content-tags:
- tagless
---

Yesterday I took a stroll down to the riverfront to check out [Artica][1] and ponder the redevelopment plans recently [made public][2].  Most people are familiar with the four progressive proposals, from the simple and cheap Promenade to the outrageous Terraces and Islands.


   [1]: http://www.artica.org/
   [2]: http://www.greatrivers.info/DocumentStore/c2a7920a7e364980a60fe0cdbc908a6b/051011-RiverfrontForumPresentation.pdf

### The official plans

Rather than presenting 4 distinct proposals for public feedback, the design team has essentially offered one, with 3 lessor versions if you can't afford all the options.  If there's money to spend, they would have it, we should use it connecting pedestrians to the river with floating islands and sweeping walkways.  Let me start with what I like about the plan:




  * Inclusion of all traffic levels.  Pedestrians, cyclists, horses, cars, tour busses all contribute to the vibrancy of an urban space.


  * Retail spaces in the arches of Eads Bridge.


  * Access to Eads Bridge overlook from the riverfront via stairs and elevator.  (I believe this was part of the original plans for the bridge.)



> I agree we need to figure some way to bring people down to the river and make things more attractiive, but i feel like the cobblestone landing is a HUGE part of St. Louis' historic legacy.
> - [Steve Patterson][3]

   [3]: http://www.urbanstl.com/viewtopic.php?p=14107#14107

Most of the effort will be in replacing the cobblestones with islands and seawalls, et cetera.  The cobblestones are both historic and functional, but they do add an air of unapproachability to the water when the water level is down.  The islands concept does connect people on the riverfront to Big Muddy herself.


### The real problems

The disconnect between the Mississippi and the city, though, is multilayered.  Everyone acknowledges today that I-70 and Memorial Drive need a makeover to invite visitors between downtown and the Arch grounds.  The riverfront development proposals seek to bring the river and Arch grounds together.  Between them, though, the [Jefferson National Expansion Memorial][4] dramatically isolates the city from her river.  In 1957, Saarinen modified the original plans for the Arch and buried the railroad under an artificial hill well beyond human scale.  The result we live with today is complete isolation.  To reach the water from the Old Courthouse nearly exceeds the quarter mile most people are content to walk, and the Arch itself sits in a no man's land where neither the water nor any city street are visible.

   [4]: http://www.nps.gov/jeff/

The levee between the Poplar Street and Eads bridges is not St. Louis's riverfront; it is the Arch's riverfront.  From downtown, the river is not our eastern edge, it's the other side of that immense park.

Because we cannot modify the park, this aspect of our river denial has not been openly discussed.  But being powerless to change it doesn't mean it's not a problem; just look at the skyline from Eads Bridge just over the levee and it's striking how far away St. Louis really is from the Mississippi.

> The primary intent for this project is to  position this Riverfront as a nationally recognized destination showcasing the Mississippi River and the St. Louis Region.
> - [Great Rivers][5]

   [5]: http://www.greatrivers.info/Projects/PDFs/RiverfrontInformation.pdf

> For me the biggest priority is not to make some pretty pattern on the ground as seen from the Arch. The best thing we can do is reconnect our downtown with the river.
> - [Steve Patterson, July 1st, 2005][6]

   [6]: http://www.urbanreviewstl.com/archives/000209.php

> The idea that the riverfront must be this world class design seems more like something for the trophy case than sound urban planning.
> - [Steve Patterson, October 14th, 2005][7]

   [7]: http://www.urbanreviewstl.com/archives/000293.php

Building a trophy project like this makes for dramatic renderings but is unlikely to increase traffic or tourism.  Drawing people from the Arch grounds to the river is a zero-sum game.

Three intertwined goals should be guiding this process:


### Preserve the historical significance of the levee

> Shouldn't our history be acknowledged in these proposals?
> - [framer][8]

   [8]: http://www.urbanstl.com/viewtopic.php?p=14114#14114

St. Louis is a historic city, and we must admit that the river's appeal is in cultural significance; our waterfront is not the wonder of natural beauty some cities are blessed with, but it does embody a rich cultural heritage appreciated around the globe.  Rather than compound the mistakes of the past with our grand scheming to impress the world with what we can build, let us build on what we already have.

This is what will bring tourists to our riverfront.  They want to see the river where Lewis and Clark began, where Clemmons set Huckleberry Finn.  Any that have come to marvel at engineering and architecture are drawn by a noteworthy, 630-foot tall steel arch; do we really think we can top that?


### Connect the city to the river


There are far too many of us who live and work in the city and have no reason to visit the river.

I live on 13th Street and do a lot of walking and cycling.  Sometimes I ride out onto Eads Bridge and take in the skyline, but rarely do I come near the water.  This is largely a symptom of the I-70 problem, but is exacerbated by the sea of parking isolating Laclede's Landing and the streetscape dead zone between 4th and 6th on Washington.  There's just nothing that's fun to look at between Broadway and the river itself.


### Draw Arch visitors out to the city and the river


There are far too many people who park, visit the Arch, and leave.

My "water isolation" experience is with the north side; workers and residents closer to Market than Washington are confronted with the imposing pit of I-70, and the boring greenspace void of Saarinen's berm.  More importantly, visitors to the Arch grounds have little incentive to walk west into the city and support downtown businesses.

This is being addressed by other initiatives, but belongs in any discussion about drawing people to the river.


### Building on our strengths

Let's connect the strong areas we've already built, and integrate the riverfront along the way.


### Connect Laclede's Landing to the river


This is the riverfront we should be concerned with first.  We have increasing amounts of pedestrian traffic already mere yards from the water, this is a more appropriate place to try some bold new ideas for bringing people in contact with the Mississippi.  The market already has identified this and plans new river-oriented condos.


### Connect Downtown and Laclede's Landing


The sea of parking lots needs to be redeveloped into a streetscape.  Washington between Eads and Broadway needs to be more inviting.  Retail within the Eads arches will help, as well.

A streetcar from the Landing up Washington Avenue to the loft district could do wonders to re-associate the Landing with Downtown.  Perhaps the Pinnacle casino and Bottle District developers could contribute to development of a line that included their front doors.


### Bring Arch visitors to Laclede's Landing and the Riverfront


Extending the streetcar along Leonor K Sullivan Blvd would invite visitors between the Landing and the Arch's riverfront.

Reorienting the Arch parking garage towards Washingon (with simple signage) with a station on the plateau of that hill would do wonders.  Visitors would be unable to miss the station on entering the garage, and could then consider using the streetcar to save themselves a bit of climbing, and also see the Landing and riverfront.


### Make the Riverfront pleasant to visit


Ideally, LKS would be converted to a boulevard, with one lane for parking and one for traffic on either side of grassy median with tracks (as in New Orleans) and boardwalk on the eastern side that extends over the cobbles.  That boardwalk could start out wide enough for festival booths and souvenir stands, but grow out further over the cobblestones as traffic increased and small businesses desired space for shops and restaurants.  Perhaps as people found it easier to visit the Riverfront, there would be enough tourist traffic to bring back riverboat-based attractions.


### Connect everything else


If there's any single development I'd like to see in Downtown St. Louis, it's a streecar line connecting Union Station to the Washington Avenue loft district to Laclede's Landing (via the Convention Center and Dome) to the riverfront (and Arch) to the ballpark village.

Our leaders are eager to show the nation something interesting how about trollies running along Clark Street, visible just past left field on televised Cardinals games, and also seen in skyline views running along the river?
