---
title: The Tree 🌲
layout: page
---

The glyph[^logo] I use as a logo is based on [LEGO part #2435][tree]. It has accumulated many meanings over time.

[^logo]: {% tree 99 %}

[tree]: https://www.bricklink.com/v2/catalog/catalogitem.page?P=2435

I never intended to have a logo, unless you count a childhood fascination with drawing Sierpiński triangles. But when Dustin Curtis [invited me to Svbtle](https://gerwitz.svbtle.com/first), he asked me to choose a unicode character and color. I selected the [Evergreen Tree at point U+1F332][unicode], <span role="img" aria-label="tree">&#x1F332;&#xFE0E;</span>, which in the days before creeping emojification rendered as a simple single-color graphic and looked nice in [classic HTML green](https://www.color-hex.com/color/008000). I was living in Seattle at the time and inspired by the Doug flag of [Free Cascadia][cascadia].

[unicode]: https://unicode-table.com/en/1F332/
[cascadia]: https://freecascadia.org/

Circa 2017, I became worried about the longevity of my own content and hopped on the IndieWeb train. This included shifting canonical posts to this site, which felt like moving from Svbtle to here. So, the tree came here, and in January 2018 I devised the LEGO version after thinking about why the evergreen tree resonated with me.

The Cascadian flag[^doug] still resonated with me. Not from parochial pride for a region I've not inhabited for some time, but for the idea of [aligning political regions with ecosystems][bioregionalism]. Of course, the Douglas fir outline is too complex to serve as a logo.

[^doug]: {% include "./doug.svg" %}

[bioregionalism]: https://en.wikipedia.org/wiki/Bioregionalism

I also spent a lot of time in Missouri forests and many of my childhood friends were trees. My short walks to elementary school in Ferguson went through an orderly set of white pines of the same sort as those I knew in the Ozarks. I often reflected on their connection between civilization and nature.

So I wanted to keep the tree, but didn't have a unique form.

As a child I was fascinated with the the [original LEGO tree][big tree] as a manufactured object. I enjoyed thinking about the design of the object itself. The way it evoked organic form with a simple construction felt fractal and tickled my interest in complexity theory. I remember, uncharacteristically vividly, my thoughts about the machines for manufacturing them as one of the sparks which ignited my lifelong interest in the creation and maintenance of things and our built environment.[^seal] It serves nicely as a symbol of **causal complexity**.

[big tree]: https://www.bricklink.com/v2/catalog/catalogitem.page?P=3471

[^seal]: My LEGO tree is analgeous to [Teddy Roosevelt's seal skull](https://www.theodorerooseveltcenter.org/Blog/Item/A%20Propitious%20Sign%20from%20the%20Ocean) which inspired his conservationism, in turn changing the shape of America. Except, of course, I went on to be a curious nerd rather than change the course of history.

So, there it is. I used the dimensions of part #2435 to draw an outline with the aim to be recognizable to LEGO nerds but also work as just a tree. I've been happy with the result and can imagine using it for the rest of my life as long as no one subverts the imagery.
