---
date: 2014-09-11
layout: page
title: "to [icon]"
---

_to [icon]_ was a long-lived side project of [The Artificial](/projects//the-artificial/), launched in 2014.

As we scaled the aagency up, we were often creating quick mockups and prototyping. By then, [Noun Project](https://thenounproject.com/) was long-established as the primary resource for visual assets that could be used for these. It had grown quickly and the quality level of icons there had declined, so searching for a good stand-in often became an exercise of sifting through poorly-conceived or sloppily-executed chaff. And we didn't need clip-art to depict objects as much as icons for use in UI to represent user actions. Our icon sets were thus verb-oriented and held to Shannon's typically high quality standards.

To organize them, I developed[^roos] a site in Ruby on Rails with an administrative interface for a metadata database and high-performance public browsing view. As a sort of proof-of-concept that the web was ready, the icons were rendered as inline SVGs.

[^roos]: For a while we had a development intern we'd mentored via Rails Girls, [Roos de Bildt](https://www.roosbeeldt.com/), who contributed a lot to the site's codebase.

Our quality standards and the site became a [learning exercise](/2017/12/06/week-244.html) for our designers. To use their bench time contributing to the collections, they had to learn to work with a coarse grid for pixel-snapping at low resolutions, be consistant with their color palette and line weights, think about how each icon fit into a taxonomy of verbs (with primary and secondary labels) and what non-verb tags would be useful for searching, and understand a workflow that included SVG production and git commits.

As we bootstrapped the library and site, we thought to use is as an experiment for the agency to learn what it's like to [run a Kickstarter](https://artificial.design/archives/2014/04/10/toicon.html) (we had 141 backers). We gained [a little publicity](https://www.fastcompany.com/3029584/universal-symbols-for-verbs-from-headbanging-to-hallucinating), cut physical icons on our CNC to display at Dutch Design Week, and learned that crowdfunding supporters have a seriously outsized sense of entitlement over product development. We finally threw one of our first of our [agency parties](https://artificial.design/archives/2014/09/12/launchparty.html).

Over the years, we continued to find value in creating icon sets and evolving the site as a training exercise. Some of the tutorials we wrote about technique got a lot of traffic, and the published library grew to 4198 icons in 20 distinctly-styled sets. The site had a simple navigation model supporting discovery by browsing through a multi-faceted taxonomy or structured search, and beautiful previews that highlighted the flexibility of the SVG assets in scale and color.

It was fun to have a "product" to manage, as we experimented with fashionable growth hacking techniques and rolled out new features like curated collections. Although the last new icons were published over 4 years ago and we never finished plans to offer color-customized downloads for paid subscriptions, it continued to hum along.

As I write this in mid-2022 there are still about 100 unique visitors each day, each spending an average of 2 minutes visiting more than 4 pages, and over 10% of them choose to download an icon or collection. That's added up to over 2.7 million downloads so far!

It is sad to retire a product that thousands of people find valuable each month, but the site has bitrot and is full of security holes. To maintain it will require I give up other projects or find a way have it pay for its own support. While this level of ongoing popularity seems big to me, though, it's tiny in terms of advertising options and other monetization options would be difficult with half of the traffic coming from China.

So, I can't justify further development and am taking the site offline to prevent it becoming a malware host. All those downloaded icons will live on, and maybe someday we'll find a suitable but more sustainable way to publish them again.

<figure>
<svg version="1.1" id="DESIGNS" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="128px" height="128px" viewBox="0 0 32 32" style="enable-background:new 0 0 32 32;" xml:space="preserve">
<style type="text/css">
	.linesandangles_een{fill:#111918;}
</style>
<path class="linesandangles_een" d="M16,4C9.935,4,5,8.935,5,15c0,3.36,1.494,6.461,4.113,8.563L10.219,28h11.562l1.105-4.437
	C25.506,21.461,27,18.36,27,15C27,8.935,22.065,4,16,4z M21.398,22.188L21.115,22.4L20.219,26H19v-3h-2v3h-2v-3h-2v3h-1.219
	l-0.896-3.6l-0.283-0.213C8.312,20.466,7,17.846,7,15c0-4.963,4.037-9,9-9s9,4.037,9,9C25,17.846,23.687,20.466,21.398,22.188z
	 M15,15.5c0,1.933-1.343,3.5-3,3.5s-3-1.567-3-3.5s1.343-3.5,3-3.5S15,13.567,15,15.5z M23,15.5c0,1.933-1.343,3.5-3,3.5
	s-3-1.567-3-3.5s1.343-3.5,3-3.5S23,13.567,23,15.5z"></path>
</svg>
<figcaption><em>to die</em> from the series <em>Lines and Angles</em> by Shannon E Thomas on <a href="https:///www.toicon.com/">to [icon]</a>. Licensed CC-BY 4.0</figcaption>
</figure>
