---
title: Cognition Traps
---

We seek and retain knowledge that fits our stories, and center those stories on individuals.

It's well understood that we humans are imperfect thinkers. We started refining reason long ago and [inventory our common mistakes](https://yourlogicalfallacyis.com/). When we started applying scientific thought, it also became popular to consider our cognitive biases.

Even before I majored in psychology, I enjoyed thinking about these traps that we fall into. Formal studies only heightened that interest, and I often find myself referring to the Wikipedia pages on [cognitive biases](https://en.wikipedia.org/wiki/List_of_cognitive_biases) and [heuristics](https://en.wikipedia.org/wiki/Heuristics_in_judgment_and_decision-making). Like most of Wikipedia, they are useful to provoke thought and make new connections, before jumping off to more rigorous sources.

Over time, that page became first more extensive, and eventually more structured. Still, it's quite a soup of ideas. People who seek to strengthen their own thinking often find themselves flummoxed by this mess, which unfortunately is representative of our understanding of human cognition. Everyone would like some structure to be more effective in addressing behavior. The best example I know is [Buster Benson's conundrums](https://busterbenson.com/piles/cognitive-biases/):

- There is too much information so we must filter it.
- We look for meaningful stories to connect our knowledge together.
- We move too quickly.

I will probably spend my entire life toying with such grand unifying theories of cognition, myself. For the purpose of avoiding these traps, though, I find it most useful to focus on two of them: [Confirmation Bias](https://www.theatlantic.com/magazine/archive/2018/09/cognitive-bias/565775/) and [Fundamental Attribution Error](https://www.oxfordbibliographies.com/view/document/obo-9780199828340/obo-9780199828340-0114.xml).

Here, though, is a broad collection of other named traps that I find particularly meaningful:

**Fundamental attribution error**
We attribute behavior to personal characteristics that is a result of situations.
_I would have handled that better because I'm more forgiving._

**[Confirmation bias](http://skepdic.com/confirmbias.html)**
We are more likely to seek and notice observations that confirm our existing beliefs.
_Every time there's a full moon, I notice more cats outside._
See also [choice-supportive bias](https://en.wikipedia.org/wiki/Choice-supportive_bias).

**[Representative heuristic](http://changingminds.org/explanations/theories/representativeness_heuristic.htm)**
We assume that things which are like each other in some ways will be alike in all ways.
_People like her never like this cocktail._

**[Availability heuristic](http://heuristics.behaviouralfinance.net/availability/)**
We rely on knowledge that is readily available in our memory.
_I just saw an article about this, so it must be popular._

**[Survivorship bias](http://youarenotsosmart.com/2013/05/23/survivorship-bias/)**
We neglect missing subjects in studying a population.
_The novels we still read from the 19th century are all so good, writing must have been better then._
See also [subject attrition](http://www.ncbi.nlm.nih.gov/pubmed/26726833)

**[Hindsight bias](http://lesswrong.com/lw/il/hindsight_bias/)**
We consider past events to be more easily predicted than they were.
_I knew that all along!_
See also [the sentient puddle](https://en.wikipedia.org/wiki/Fine-tuned_Universe#In_popular_culture).

**[Anchoring and adjustment heuristic](http://youarenotsosmart.com/2010/07/27/anchoring-effect/)**
We rely too much on the first information we have.
_If that house was listed at $500,000, then $400,000 must be a bargain._

**Acquiescence bias**
We tend to agree.
_If they're asking that question, there might be some truth to it._

**[Loss aversion](http://www.beinghuman.org/article/loss-aversion)**
We value what we have more than what we might gain.
_I'm only willing to risk $10 on a 50/50 chance for much more than $20._

**Halo effect**
We tend to find positive details in that which we feel good about.
_It's from Apple, so it must be well-designed_

**[Context dependance](http://www.wheelofpersuasion.com/technique/context-dependent-memory/)**
It is easier to recall information in the same context as it was learned.
See also [state dependance](http://www.memorylossonline.com/glossary/statedependentmemory.html)

**[Doorway effect](http://www.scientificamerican.com/article/why-walking-through-doorway-makes-you-forget/)**
Spatial transitions lead to forgetting.

**Peak-end**
https://en.wikipedia.org/wiki/Peak–end_rule

**[Isolation effect](https://en.wikipedia.org/wiki/Von_Restorff_effect)**
We remember items that stick out from the group.

**[Testing effect](https://en.wikipedia.org/wiki/Testing_effect)**
Remembering information strengthens our memory of it.

**Fluency** - easier to consider
https://en.wikipedia.org/wiki/Fluency_heuristic

**Affect heuristic** - emotion
https://en.wikipedia.org/wiki/Affect_heuristic

**Generation** - (writing, sketching, forming words) reinforces memory
https://en.wikipedia.org/wiki/Generation_effect

**Hostile attribution bias**
We tend to ascribe malicious intent to others.
See also [Hanlon's razor](https://en.wikipedia.org/wiki/Hanlon%27s_razor).

**Scarcity**
https://en.wikipedia.org/wiki/Scarcity_heuristic

**[Self-serving bias](http://psychology.wikia.com/wiki/Self-serving_bias)**
We tend to take more responsibility for success than failure.

**Demand characteristics**
Subjects behave differently under study.
_I don't want to disappoint these researchers._

**[Method of loci](https://en.wikipedia.org/wiki/Method_of_loci)**
Our memory works best with a spatial relationship.

**[Picture superiority](https://en.wikipedia.org/wiki/Picture_superiority_effect)**
We remember what we've seen better than what we've read.

**[Illusory correlation](https://en.wikipedia.org/wiki/Illusory_correlation)**
We like to make connections and will imagine correlations.
