package com.kangkai.utils;

public class RegexConstants {
	/**
     * 静态文件匹配模式(media)
     */
    public static final String STATIC_FILE_PATTEN = "^.+\\.(?:jpg|gif|png|css|js|html|ico|bmp|jpeg|xml|txt|swf|flv)$";

    /**
     * 邮箱匹配模式
     */
    public static final String EMAIL_PATTEN = "^(?:[\\w]+\\.?[\\w]+)+@(?:[\\w]+\\.?[\\w]+)+\\.(?:com|net|cn|org)$";

    /**
     * HTTP url匹配模式
     */
    public static final String HTTP_URL_PATTEN = "^https?://.+$";

    /**
     * 电话匹配模式
     */
    public static final String TELPHONE_PATTEN = "^0[1-9][0-9]{1,2}-[1-9][0-9]{6,7}$|^1[1-9][0-9]{9}$";

    /**
     * 手机号码匹配模式
     */
    public static final String CELLPHONE_PATTEN = "^1[1-9][0-9]{9}$";

    /**
     * 日期匹配模式(YYYY-MM-DD)
     */
    public static final String DATE_PATTEN = "((^((1[8-9]\\d{2})|([2-9]\\d{3}))([-\\/\\._])(10|12|0?[13578])([-\\/\\._])(3[01]|[12][0-9]|0?[1-9])$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))([-\\/\\._])(11|0?[469])([-\\/\\._])(30|[12][0-9]|0?[1-9])$)|(^((1[8-9]\\d{2})|([2-9]\\d{3}))([-\\/\\._])(0?2)([-\\/\\._])(2[0-8]|1[0-9]|0?[1-9])$)|(^([2468][048]00)([-\\/\\._])(0?2)([-\\/\\._])(29)$)|(^([3579][26]00)([-\\/\\._])(0?2)([-\\/\\._])(29)$)|(^([1][89][0][48])([-\\/\\._])(0?2)([-\\/\\._])(29)$)|(^([2-9][0-9][0][48])([-\\/\\._])(0?2)([-\\/\\._])(29)$)|(^([1][89][2468][048])([-\\/\\._])(0?2)([-\\/\\._])(29)$)|(^([2-9][0-9][2468][048])([-\\/\\._])(0?2)([-\\/\\._])(29)$)|(^([1][89][13579][26])([-\\/\\._])(0?2)([-\\/\\._])(29)$)|(^([2-9][0-9][13579][26])([-\\/\\._])(0?2)([-\\/\\._])(29)$))";

    /**
     * 时间匹配模式(HH:mm:ss) 分钟,秒可选,小时必须
     */
    public static final String TIME_PATTEN = "^(?:[01]?[0-9]|2[0-3])(?::[0-5]?[0-9]){0,2}$";

    /**
     * 匹配ipv4网络地址,包括私有IP
     */
    public static final String IP_V4_PATTEN = "^(?:[0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])(?:\\.([0-9]|[1-9][0-9]|1[0-9][0-9]|2[0-4][0-9]|25[0-5])){3}$";

    /**
     * HTTP url匹配模式
     */
    public static final String HTTP_IMG_URL_PATTEN = "^https?://.+\\.(?:gif|png|jpeg|jpg)$";

    public static final String ZIP_PATTERN = "\\d{6}";
}

