/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.qrcode;

import java.util.Vector;
import jp.sourceforge.qrcode.data.QRCodeImage;
import jp.sourceforge.qrcode.data.QRCodeSymbol;
import jp.sourceforge.qrcode.exception.DecodingFailedException;
import jp.sourceforge.qrcode.exception.InvalidDataBlockException;
import jp.sourceforge.qrcode.exception.SymbolNotFoundException;
import jp.sourceforge.qrcode.geom.Point;
import jp.sourceforge.qrcode.reader.QRCodeDataBlockReader;
import jp.sourceforge.qrcode.reader.QRCodeImageReader;
import jp.sourceforge.qrcode.util.DebugCanvas;
import jp.sourceforge.qrcode.util.DebugCanvasAdapter;
import jp.sourceforge.reedsolomon.RsDecode;

public class QRCodeDecoder {
    int numTryDecode = 0;
    QRCodeSymbol qrCodeSymbol;
    Vector results;
    Vector lastResults = new Vector();
    static DebugCanvas canvas;
    QRCodeImageReader imageReader;
    int numLastCorrectionFailures;

    public static void setCanvas(DebugCanvas canvas) {
        QRCodeDecoder.canvas = canvas;
    }

    public static DebugCanvas getCanvas() {
        return canvas;
    }

    public QRCodeDecoder() {
        this.results = new Vector();
        canvas = new DebugCanvasAdapter();
    }

    public byte[] decode(QRCodeImage qrCodeImage) throws DecodingFailedException {
        Point[] adjusts = this.getAdjustPoints();
        Vector<DecodeResult> results = new Vector<DecodeResult>();
        this.numTryDecode = 0;
        while (this.numTryDecode < adjusts.length) {
            DecodeResult result;
            block10: {
                result = this.decode(qrCodeImage, adjusts[this.numTryDecode]);
                if (!result.isCorrectionSucceeded()) break block10;
                byte[] byArray = result.getDecodedBytes();
                ++this.numTryDecode;
                return byArray;
            }
            try {
                try {
                    results.addElement(result);
                    canvas.println("Decoding succeeded but could not correct");
                    canvas.println("all errors. Retrying..");
                }
                catch (DecodingFailedException dfe) {
                    if (dfe.getMessage().indexOf("Finder Pattern") >= 0) {
                        throw dfe;
                    }
                    ++this.numTryDecode;
                    continue;
                }
            }
            catch (Throwable throwable) {
                ++this.numTryDecode;
                throw throwable;
            }
            ++this.numTryDecode;
        }
        if (results.size() == 0) {
            throw new DecodingFailedException("Give up decoding");
        }
        int minErrorIndex = -1;
        int minError = Integer.MAX_VALUE;
        int i = 0;
        while (i < results.size()) {
            DecodeResult result = (DecodeResult)results.elementAt(i);
            if (result.getNumCorrectuionFailures() < minError) {
                minError = result.getNumCorrectuionFailures();
                minErrorIndex = i;
            }
            ++i;
        }
        canvas.println("All trials need for correct error");
        canvas.println("Reporting #" + minErrorIndex + " that,");
        canvas.println("corrected minimum errors (" + minError + ")");
        canvas.println("Decoding finished.");
        return ((DecodeResult)results.elementAt(minErrorIndex)).getDecodedBytes();
    }

    Point[] getAdjustPoints() {
        Vector<Point> adjustPoints = new Vector<Point>();
        int d = 0;
        while (d < 4) {
            adjustPoints.addElement(new Point(1, 1));
            ++d;
        }
        int lastX = 0;
        int lastY = 0;
        int y = 0;
        while (y > -4) {
            int x = 0;
            while (x > -4) {
                if (x != y && (x + y) % 2 == 0) {
                    adjustPoints.addElement(new Point(x - lastX, y - lastY));
                    lastX = x;
                    lastY = y;
                }
                --x;
            }
            --y;
        }
        Point[] adjusts = new Point[adjustPoints.size()];
        int i = 0;
        while (i < adjusts.length) {
            adjusts[i] = (Point)adjustPoints.elementAt(i);
            ++i;
        }
        return adjusts;
    }

    DecodeResult decode(QRCodeImage qrCodeImage, Point adjust) throws DecodingFailedException {
        try {
            if (this.numTryDecode == 0) {
                canvas.println("Decoding started");
                int[][] intImage = this.imageToIntArray(qrCodeImage);
                this.imageReader = new QRCodeImageReader();
                this.qrCodeSymbol = this.imageReader.getQRCodeSymbol(intImage);
            } else {
                canvas.println("--");
                canvas.println("Decoding restarted #" + this.numTryDecode);
                this.qrCodeSymbol = this.imageReader.getQRCodeSymbolWithAdjustedGrid(adjust);
            }
        }
        catch (SymbolNotFoundException e) {
            throw new DecodingFailedException(e.getMessage());
        }
        canvas.println("Created QRCode symbol.");
        canvas.println("Reading symbol.");
        canvas.println("Version: " + this.qrCodeSymbol.getVersionReference());
        canvas.println("Mask pattern: " + this.qrCodeSymbol.getMaskPatternRefererAsString());
        int[] blocks = this.qrCodeSymbol.getBlocks();
        canvas.println("Correcting data errors.");
        blocks = this.correctDataBlocks(blocks);
        try {
            byte[] decodedByteArray = this.getDecodedByteArray(blocks, this.qrCodeSymbol.getVersion(), this.qrCodeSymbol.getNumErrorCollectionCode());
            return new DecodeResult(decodedByteArray, this.numLastCorrectionFailures);
        }
        catch (InvalidDataBlockException e) {
            canvas.println(e.getMessage());
            throw new DecodingFailedException(e.getMessage());
        }
    }

    int[][] imageToIntArray(QRCodeImage image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[][] intImage = new int[width][height];
        int y = 0;
        while (y < height) {
            int x = 0;
            while (x < width) {
                intImage[x][y] = image.getPixel(x, y);
                ++x;
            }
            ++y;
        }
        return intImage;
    }

    int[] correctDataBlocks(int[] blocks) {
        int numSucceededCorrections = 0;
        int numCorrectionFailures = 0;
        int dataCapacity = this.qrCodeSymbol.getDataCapacity();
        int[] dataBlocks = new int[dataCapacity];
        int numErrorCollectionCode = this.qrCodeSymbol.getNumErrorCollectionCode();
        int numRSBlocks = this.qrCodeSymbol.getNumRSBlocks();
        int eccPerRSBlock = numErrorCollectionCode / numRSBlocks;
        if (numRSBlocks == 1) {
            RsDecode corrector = new RsDecode(eccPerRSBlock / 2);
            int ret = corrector.decode(blocks);
            if (ret > 0) {
                numSucceededCorrections += ret;
            } else if (ret < 0) {
                ++numCorrectionFailures;
            }
            return blocks;
        }
        int numLongerRSBlocks = dataCapacity % numRSBlocks;
        if (numLongerRSBlocks == 0) {
            int lengthRSBlock = dataCapacity / numRSBlocks;
            int[][] RSBlocks = new int[numRSBlocks][lengthRSBlock];
            int i = 0;
            while (i < numRSBlocks) {
                int j = 0;
                while (j < lengthRSBlock) {
                    RSBlocks[i][j] = blocks[j * numRSBlocks + i];
                    ++j;
                }
                canvas.println("eccPerRSBlock=" + eccPerRSBlock);
                RsDecode corrector = new RsDecode(eccPerRSBlock / 2);
                int ret = corrector.decode(RSBlocks[i]);
                if (ret > 0) {
                    numSucceededCorrections += ret;
                } else if (ret < 0) {
                    ++numCorrectionFailures;
                }
                ++i;
            }
            int p = 0;
            int i2 = 0;
            while (i2 < numRSBlocks) {
                int j = 0;
                while (j < lengthRSBlock - eccPerRSBlock) {
                    dataBlocks[p++] = RSBlocks[i2][j];
                    ++j;
                }
                ++i2;
            }
        } else {
            int lengthShorterRSBlock = dataCapacity / numRSBlocks;
            int lengthLongerRSBlock = dataCapacity / numRSBlocks + 1;
            int numShorterRSBlocks = numRSBlocks - numLongerRSBlocks;
            int[][] shorterRSBlocks = new int[numShorterRSBlocks][lengthShorterRSBlock];
            int[][] longerRSBlocks = new int[numLongerRSBlocks][lengthLongerRSBlock];
            int i = 0;
            while (i < numRSBlocks) {
                int ret;
                RsDecode corrector;
                int mod;
                if (i < numShorterRSBlocks) {
                    mod = 0;
                    int j = 0;
                    while (j < lengthShorterRSBlock) {
                        if (j == lengthShorterRSBlock - eccPerRSBlock) {
                            mod = numLongerRSBlocks;
                        }
                        shorterRSBlocks[i][j] = blocks[j * numRSBlocks + i + mod];
                        ++j;
                    }
                    canvas.println("eccPerRSBlock(shorter)=" + eccPerRSBlock);
                    corrector = new RsDecode(eccPerRSBlock / 2);
                    ret = corrector.decode(shorterRSBlocks[i]);
                    if (ret > 0) {
                        numSucceededCorrections += ret;
                    } else if (ret < 0) {
                        ++numCorrectionFailures;
                    }
                } else {
                    mod = 0;
                    int j = 0;
                    while (j < lengthLongerRSBlock) {
                        if (j == lengthShorterRSBlock - eccPerRSBlock) {
                            mod = numShorterRSBlocks;
                        }
                        longerRSBlocks[i - numShorterRSBlocks][j] = blocks[j * numRSBlocks + i - mod];
                        ++j;
                    }
                    canvas.println("eccPerRSBlock(longer)=" + eccPerRSBlock);
                    corrector = new RsDecode(eccPerRSBlock / 2);
                    ret = corrector.decode(longerRSBlocks[i - numShorterRSBlocks]);
                    if (ret > 0) {
                        numSucceededCorrections += ret;
                    } else if (ret < 0) {
                        ++numCorrectionFailures;
                    }
                }
                ++i;
            }
            int p = 0;
            int i3 = 0;
            while (i3 < numRSBlocks) {
                int j;
                if (i3 < numShorterRSBlocks) {
                    j = 0;
                    while (j < lengthShorterRSBlock - eccPerRSBlock) {
                        dataBlocks[p++] = shorterRSBlocks[i3][j];
                        ++j;
                    }
                } else {
                    j = 0;
                    while (j < lengthLongerRSBlock - eccPerRSBlock) {
                        dataBlocks[p++] = longerRSBlocks[i3 - numShorterRSBlocks][j];
                        ++j;
                    }
                }
                ++i3;
            }
        }
        if (numSucceededCorrections > 0) {
            canvas.println(String.valueOf(String.valueOf(numSucceededCorrections)) + " data errors corrected successfully.");
        } else {
            canvas.println("No errors found.");
        }
        this.numLastCorrectionFailures = numCorrectionFailures;
        return dataBlocks;
    }

    byte[] getDecodedByteArray(int[] blocks, int version, int numErrorCorrectionCode) throws InvalidDataBlockException {
        QRCodeDataBlockReader reader = new QRCodeDataBlockReader(blocks, version, numErrorCorrectionCode);
        byte[] byteArray = reader.getDataByte();
        return byteArray;
    }

    class DecodeResult {
        int numCorrectionFailures;
        byte[] decodedBytes;

        public DecodeResult(byte[] decodedBytes, int numCorrectionFailures) {
            this.decodedBytes = decodedBytes;
            this.numCorrectionFailures = numCorrectionFailures;
        }

        public byte[] getDecodedBytes() {
            return this.decodedBytes;
        }

        public int getNumCorrectuionFailures() {
            return this.numCorrectionFailures;
        }

        public boolean isCorrectionSucceeded() {
            return QRCodeDecoder.this.numLastCorrectionFailures == 0;
        }
    }
}

