export default function ApiLogo({DarkMode}: {DarkMode: boolean}) {
  return (
    <svg
      xmlns='http://www.w3.org/2000/svg'
      width='50'
      height='50'
      fill='none'
      viewBox='0 0 48 48'
    >
      <path fill='#fff' fillOpacity='0.01' d='M0 0H48V48H0z'></path>
      <path
        fill='#2F88FF'
        stroke={DarkMode ? "#fff" : "#000"} 
        strokeLinecap='round'
        strokeLinejoin='round'
        strokeWidth='4'
        d='M37 22l-3 3-11-11 3-3c1.5-1.5 7-4 11 0s1.5 9.5 0 11z'
      ></path>
      <path
        stroke={DarkMode ? "#fff" : "#000"} 
        strokeLinecap='round'
        strokeLinejoin='round'
        strokeWidth='4'
        d='M42 6l-5 5'
      ></path>
      <path
        fill='#2F88FF'
        stroke={DarkMode ? "#fff" : "#000"} 
        strokeLinecap='round'
        strokeLinejoin='round'
        strokeWidth='4'
        d='M11 26l3-3 11 11-3 3c-1.5 1.5-7 4-11 0s-1.5-9.5 0-11z'
      ></path>
      <path
        stroke={DarkMode ? "#fff" : "#000"} 
        strokeLinecap='round'
        strokeLinejoin='round'
        strokeWidth='4'
        d='M23 32l4-4M6 42l5-5M16 25l4-4'
      ></path>
    </svg>
  );
}
