import { useMemo } from "react";
import Head from "next/head";
import type { AppProps } from 'next/app'
import { ThemeProvider as MuiThemeProvider } from "@mui/material/styles";
import { createTheme } from "@mui/material/styles";
import CssBaseline from "@mui/material/CssBaseline";
import { useIsDarkModeEnabled, withIsDarkModeEnabled } from "../shared/isDarkModeEnabled";
import { createEmotionSsrAdvancedApproach } from "tss-react/next/pagesDir";

const {
    augmentDocumentWithEmotionCache,
    withAppEmotionCache
} = createEmotionSsrAdvancedApproach({ "key": "css" });

export { augmentDocumentWithEmotionCache };

export function App({ Component, pageProps }: AppProps) {

	const { isDarkModeEnabled } = useIsDarkModeEnabled();

	const theme = useMemo(
		() => createTheme({
			"palette": {
				"mode": isDarkModeEnabled ? "dark" : "light",
				"primary": {
					"main": "#32CD32" //Limegreen
				},
				"info": {
					"main": "#ffff00" //Yellow
				}
			},
			"typography": {
				"subtitle2": {
					"fontStyle": "italic"
				}
			},
			"components": {
				"TestingStyleOverrides": {
					"styleOverrides": {
						"lightBulb": ({ theme, ownerState: { isOn }, lightBulbBorderColor }: any) => ({
							"border": `1px solid ${lightBulbBorderColor}`,
							"backgroundColor": isOn ? theme.palette.info.main : "grey"
						})
					}

				}
			} as any
		}),
		[isDarkModeEnabled]
	);

	return (
		<>
			<Head>
				<title>Create Next App</title>
				<meta name="description" content="Generated by create next app" />
				<link rel="icon" href="/favicon.ico" />
			</Head>
			<MuiThemeProvider theme={theme}>
				<CssBaseline />
				<Component {...pageProps} />
			</MuiThemeProvider>
		</>
	);

}

export default withAppEmotionCache(withIsDarkModeEnabled(App));