---
title: 'Meningkatkan Kemampuan Berfikir dan Problem Solving'
slug: {
  en: null,
  id: 'meningkatkan-kemampuan-berfikir'
}
date: 2021-04-21
description: 'Ada sebuah cara unik untuk meningkatkan kemampuan berfikir dan problem solving ala Dr. Edward de Bono. Yaitu dengan memiliki "The Six Thinking Hats". Apakah itu?'
keywords: 'meningkatkan kemampuan berfikir, kemampuan berfikir, akal, berfikir, life, thinking, self upgrade, life hack, problem solving, edward de bono, six thinking hats, thinking hats'
tags: ['life', 'problem solving', 'six thinking hats']
image: '/media/blog/meningkatkan-kemampuan-berfikir/banner.jpg'
---

Manusia adalah mahluk sempurna, yang diciptakan Allah dengan memiliki Akal. Akal ini adalah salah satu bekal dari tuhan kita yang menjadikan kita mahluk sempurna. Tentu saja, jika kita dapat menggunakannya dengan baik.

Ada salah satu bagian dari akal, yaitu ***Berfikir***. Siapa sih yang tidak tahu berfikir? Berfikir sudah menjadi kebutuhan kita untuk menjadi manusia normal dalam mencari jawaban dari persoalan-persoalan yang ada di kehidupan kita.

Secara istilah, Berfikir adalah suatu aktivitas otak yang dapat mengubungkan partikel-partikel pengetahuan/informasi yang ada di dalam otak kita guna untuk dapat membentuk sebuah keputusan atau jawaban. Sebagai penjelasannnya, coba kita lihat exercise berikut.

$1 + 1 = ?$

$7 - 2 = ?$

$2 * 5 = ?$

Pada persoalan diatas, jelas kita dapat dengan mudah menemukan jawabannya. Kira-kira seperti itulah contoh sederhana ***pengalaman***, jawaban dari persoalan tersebut sudah tertanam di otak kita. Jadi, kita tinggal mengambil jawaban tersebut dari otak tanpa harus berfikir lebih lama lagi, karena kita sudah sering bertemu dengan persoalannya. Beda lagi kalau persoalan tersebut dikasih ke anak yang baru memulai sekolah, mereka pasti membutuhkan waktu yang lebih lama untuk menemukan jawabannya, karena mereka sendiri belum ada pengalaman dari persoalan tersebut.

Lalu, bagaimana kalau dengan ini?

$429 \times (7!) = ?$

$69321 + \sqrt{25} = ?$

$12732 \div \frac{2^{\sqrt{2^3}}}{2} = ?$


Yap, kita akan agak kesulitan dan lebih memakan waktu untuk menemukan jawaban dari persoalan diatas. Itu karena kita mungkin belum pernah bertemu dengan persoalan tersebut. Tapi ada yang menarik disini, walaupun kita belum bertemu dengan persoalan tersebut sebelumnya, kita tetap bisa menyelesaikannya dengan menggunakan basic-basic kecil dari pengetahuan dan pengalaman yang sudah kita alami sebelumnya. Proses inilah yang disebut berfikir.

Dari kedua contoh sederhana persoalan tersebut, kita jadi tahu sebenarnya seperti itulah siklus kita dalam mencari jawaban dari persoalan-persoalan yang ada di kehidupan. Kita bisa dengan reflek menggunakan jawaban-jawaban yang sudah tertanam di otak kita jika sedang berhadapan dengan persoalan yang sudah pernah kita temui. Lalu kita juga akan reflek menggunakan basic-basic kecil pengetahuan dan pengalaman yang ada pada diri ketika berhadapan dengan masalah yang belum pernah kita temui.

Tapi bagaimana jika belum ada sama sekali basic-basic pengetahuannya? Jelas, ketika di kondisi ini kita butuh yang namanya ***Mentor***. Kita umpama kan seperti anak yang baru sekolah ketika bertemu dengan contoh persoalan yang pertama tadi, jelas mereka butuh mentor untuk membimbingnya menyelesaikan persoalan tersebut.

---

Oke, sekarang kita masuk ke inti pembahasannya. Tulisan ini tidak akan membahas bagaimana cara berfikir dengan cepat, atau semacamnya. Tapi kita disini akan membahas bagaimana cara meningkatkan kualitas berfikir kita.

Ada sebuah cara yang unik untuk meningkatkan kualitas berfikir kita. ***[Dr. Edward De Bono](https://www.google.com/search?q=Edward+the+bono)*** mengungkapkan sebuah metode berfikir yang ditulis dalam bukunya yang berjudul ***["Six Thinking Hats"](https://www.google.com/search?q=six+thinking+hats)***, bahwa terdapat 6 metode berfikir manusia. Di dalam buku tersebut, 6 metode berfikir ini diumpamakan menjadi 6 Topi yang berwarna, antara lain ialah:

- White Hat,
- Red Hat,
- Yellow Hat,
- Black Hat,
- Green Hat, dan
- Blue Hat

Masing-masing dari Topi tersebut mempresentasikan sudut pandang atau metode cara berfikir. Adapun point-point sudut pandang dari setiap Topi berfikir itu sebagai berikut:

![Six Thinking Hats](/media/blog/meningkatkan-kemampuan-berfikir/six-thinking-hats.jpg)

### 1. White Hat
Topi Putih (White Hat) mewakili sudut pandang berfikir yang bersifat netral, faktual dan objektif. Ketika menggunakan Topi ini artinya kita sedang mengumpulkan data atau informasi-informasi yang bersifat fakta dan objektif, informasi-informasi yang dikumpulkan ini akan digunakan untuk menjadi sebuah pondasi dalam penyelesaian suatu persoalan. Informasi disini tidak termasuk opini atau interpretasi pribadi, seperti: *'Menurut saya..', 'Katanya..', 'Setau saya..',* dan sebagainya.

Contoh statement yang dapat kita gunakan saat memakai Topi Putih ini adalah:
- Apakah Data ini valid?
- Dari mana sumbernya?
- Apakah Metode ini sudah terbukti?
- Berapa orang yang sudah mencobanya?
- Berdasarkan statistik yang ada...
- Seperti fakta yang kita lihat...

Secara overall, Topi Putih ini adalah Topi yang paling dasar untuk dimiliki. Sebab, Topi ini dapat menjadi sebuah pondasi diantara Topi-Topi lainnya. Karena kualitas dari setiap keputusan atau jawaban yang kita ambil untuk kedepannya ialah tergantung dari kualitas data dan informasi yang kita punya.

### 2. Red Hat
Topi Merah (Red Hat) ini mewakili sudut pandang berfikir yang bersifat emosional, naluri, intuisi, dan perasaan. Ketika menggunakan Topi ini artinya kita menghadapi persoalan dari sudut pandang emosi, naluri dan perasaan baik positif maupun negatif. Dengan menggunakan naluri, kita sering sekali mendapat arahan akan hal yang tidak bisa diungkapkan secara fakta dan informasi.

Tidak semua di dunia ini ada datanya. Oleh karena itu, Topi ini juga cukup penting. Karena emosi, naluri, dan perasaan berpengaruh penting dalam menilai dan mengungkapkan sesuatu yang tidak ada datanya. Jelas, sebab kita adalah manusia. Tanpa sudut pandang pada Topi Merah ini, kita akan menjadi seperti robot yang hanya mengambil keputusan berdasarkan data, serta mengesampingkan perasaan manusiawi. Apakah kita harus memilih untuk tidak mengambil keputusan jika dihadapi dengan persoalan yang tidak ada datanya? Tentu tidak kan?

Contoh statement yang dapat kita gunakan saat memakai Topi Merah adalah:
- Instingku berkata tidak untuk mengambil keputusan ini.
- Menurutku, keputusan ini terlalu berat untuk dilaksanakan tanpa eksplorasi yang lebih dalam.
- Masyarakat mungkin tidak setuju dengan keputusan ini.
- Keputusan ini terlalu kejam untuk dilaksanakan.

Namun, walau bagaimanapun, untuk mengambil keputusan dan menjawab persoalan tidak bisa hanya dengan menggunakan emosi belaka. Kita juga harus menyatukan perasaan dengan fakta atau data yang ada, kita harus mengumpulkan intuisi-intuisi dari orang yang berbeda. Karena jika tidak begitu, maka keputusan yang kita buat bisa saja salah dan berakibat sangat fatal.

### 3. Yellow Hat
Topi Kuning (Yellow Hat) ini mewakili sudut pandang berfikir yang bersifat positif, konstruktif, optimis, dan harapan-harapan yang bersifat kesuksesan, kekuatan, manfaat ataupun keuntungan. Ketika menggunakan Topi ini artinya kita memikirkan manfaat-manfaat dari keputusan-keputusan yang sudah kita buat, serta mempertanyakan mengapa keputusan atau jawaban ini layak dieksplorasi dan diimplementasikan.

Contoh statement yang dapat kita gunakan saat memakai Topi Kuning adalah:
- Apa point-point positifnya?
- Apa manfaatnya?
- Mengapa keputusan ini layak diambil?
- Bagaimana keputusan ini dapat membantu kita untuk kedepannya?

Sudut pandang berfikir pada Topi Kuning ini dapat membantu kita untuk terus melangkah ketika segala sesuatunya tampak sulit. Kita akan dapat dengan jelas melihat sisi-sisi positif dari keputusan yang kita ambil. Efeknya, kita akan lebih bersemangat untuk menyelesaikan persoalan.

### 4. Black Hat
Kebalikan dari Topi Kuning, Topi Hitam (Black Hat) ini mewakili sudut pandang berfikir yang bersifat negatif, destruktif, pesimis, dan harapan-harapan yang bersifat kegagalan, kelemahan ataupun kerugian. Ketika menggunakan Topi ini artinya kita harus berfikir kritis guna untuk mengkaji resiko-resiko yang mungkin terjadi dari keputusan atau jawaban yang sudah kita buat.

Adapun contoh statement yang dapat kita gunakan saat memakai Topi Hitam adalah:
- Apa point-point negatifnya?
- Apa kerugiannya?
- Mengapa keputusan ini mungkin tidak akan berhasil?
- Bagaimana keputusan ini dapat merobohkan kita untuk kedepannya?

Sudut pandang berfikir pada Topi Hitam ini sebenarnya dapat membantu kita untuk lebih hati-hati dalam menghadapi persoalan. Tidak ceroboh dan gegabah. Kita dapat dengan mudah untuk mengambil langkah dalam menyelesaikan persoalan jika kita sudah tau sisi kelemahan dan hal-hal apa saja yang membuat kita jatuh ketika memilih sebuah keputusan.

### 5. Green Hat
Topi Hijau (Green Hat) mewakili sudut pandang berfikir yang bersifat kreatif, alternatif atau *out of the box*. Ketika menggunakan Topi ini, biarkan otak kita mengumpulkan ide-ide kreatif sebanyak mungkin tanpa harus mempertimbangkan informasi, fakta, logika dan kemungkinan negatif dari ide tersebut. Tujuannya agar otak kita tidak terhambat.

Sudut pandang berfikir pada Topi Hijau ini dapat membantu kita untuk bertumbuh dan mengeksekusi ide kreatif guna membuat inovasi serta prespektif baru. Saat menggunakan Topi Hijau, kita harus mengeliminasi terlebih dahulu kemungkinan-kemungkinan negatif yang dideteksi oleh Topi Hitam. Topi ini juga dapat membuat keputusan atau cara-cara alternatif untuk mengatasi masalah yang kita identifikasi saat menggunakan Topi Hitam.

### 6. Blue Hat
Topi Biru (Blue Hat) mewakili sudut pandang berfikir yang bersifat planning, proses, organisir dan action. Jika ke-5 Topi diatas dapat membantu kita untuk mem-*breakdown* komponen-komponen keputusan yang akan diambil. Dengan Topi Biru ini, kita akan dibawa untuk memikirkan bagaimana cara mengimplementasikan komponen-komponen tersebut.

Topi ini lebih cenderung ke manajemen dan action. Menggunakan Topi Biru ini dapat membantu kita untuk mengeksekusi keputusan. Semua komponen keputusan yang sudah kita buat dengan menggunakan ke-5 Topi diatas akan sia-sia jika tidak ada manajemen dan actionnya.

---

6 Topi berfikir seperti yang disebutkan tadi dapat meningkatkan kualitas berfikir kita, serta membantu untuk menyelesaikan persoalan-persoalan yang sedang kita hadapi. Sebenarnya tidak ada dari 6 Topi tersebut yang lebih penting, semuanya sama penting.

Normalnya, tidak semua orang yang memiliki gaya berfikir seperti ini, dan tidak semua orang bisa menggunakan ke-6 sudut pandang ini. Ini sama seperti kita memiliki 6 topi, tetapi kita lebih suka memakai satu atau beberapa warna saja untuk sehari-hari, tanpa memakai Topi yang lain.

Namun, kita tetap bisa menggunakan semua Topi ini, jika kita terus membiasakannya. Teknik berfikir yang baik adalah dengan menggunakan semua Topi tersebut secara *step by step*. Keputusan atau jawaban yang kita ambil akan menjadi lebih matang jika kita menggunakan semua metode berfikir tersebut.

Jika pun sekarang kita tidak dapat menggunakan semuanya, kita bisa melatihnya sampai terbiasa untuk menggunakan semuanya. Jadi mulai sekarang, yuk kita biasakan untuk menggunakan ke-6 metode berfikir ini sebelum menyelesaikan persoalan-persoalan yang ada pada kehidupan sehari-hari kita ☺️
