# 👨‍💻 Gading's Hideout
[![Lighthouse](https://github.com/gadingnst/gading.dev/actions/workflows/lighthouse.yml/badge.svg?event=workflow_dispatch)](https://github.com/gadingnst/gading.dev/actions/workflows/lighthouse.yml)
[![Cloudinary](https://github.com/gadingnst/gading.dev/actions/workflows/cloudinary.yml/badge.svg?event=workflow_dispatch)](https://github.com/gadingnst/gading.dev/actions/workflows/cloudinary.yml)
[![Continuous Integration](https://github.com/gadingnst/gading.dev/actions/workflows/integration.yml/badge.svg)](https://github.com/gadingnst/gading.dev/actions/workflows/integration.yml)

> My Personal Homepage & Blog site with NextJS : https://gading.dev

## Prerequisites
- [NodeJS](https://nodejs.org/en/download/)

## Ongoing Features
- [x] Dark Mode
- [x] Color System Documentation
- [x] Mobile friendly
- [x] Stateful MDX (Can write stateful Component in the Markdown)
- [x] Synchronizing media images to [Cloudinary](https://cloudinary.com) CDN
- [x] Optimized image scaling & Lazyload with blur effect like Instagram
- [x] Reading-time prediction like Medium
- [x] I18n (Internationalization) content.
- [x] Page transition and effect
- [x] Posts pagination (For limiting blog list load to improve performance)
- [x] Automate Lighthouse report
- [x] Web Analytic integration with [umami](https://umami.is)
- [x] SEO Optimized with meta information tags
- [x] Feed RSS & Sitemap
- [x] [On Demand Revalidation](https://nextjs.org/docs/basic-features/data-fetching/incremental-static-regeneration#on-demand-revalidation-beta)
- [x] Comment & Reaction System with [Disqus](https://disqus.com) plugin
- [x] Social share (FB, Linkedin, Twitter, Tumblr, WA, Telegram)
- [ ] Use `app` dir with RSC in Next 13
- [ ] Push notifications support with [OneSignal](https://onesignal.com/pricing) and [Zapier](https://zapier.com/apps/onesignal/integrations/rss/8120/send-onesignal-push-notifications-for-new-items-in-an-rss-feed) Integration
- [ ] PWA / Offline-first
- [ ] Search posts
- [ ] Sorting posts by date & tags

This is a [Next.js](https://nextjs.org/) project bootstrapped with [`create-next-app`](https://github.com/vercel/next.js/tree/canary/packages/create-next-app).

## Special Thanks to:
- [Creative Tim](https://demos.creative-tim.com/vue-argon-design-system) (Inspired me to to reproduce their `Design System`)
- [Vitor Britto](https://github.com/vitorbritto/forcefiles/blob/f0e32299138348247bd2f6ccb3dd51683fa761fd/scripts/initpost.sh) (Inspired me to to reproduce his `./initpost` script)
- [Marina Aisa](https://marinaaisa.com) (Inspired me to create I18n content)
- [Ankur Parihar](https://github.com/ankurparihar/readme-pagespeed-insights) (Inspired me to use his repo to generate Pagespeed insight periodically)
- [Myself](https://github.com/gadingnst/swr-global-state) (Have created a zero-setup global state management library for this repository)

## Support Me
### Global
[![ko-fi](https://www.ko-fi.com/img/githubbutton_sm.svg)](https://ko-fi.com/gadingnst)
### Indonesia
- [Trakteer](https://trakteer.id/sutanlab)
- [Karyakarsa](https://karyakarsa.com/sutanlab)

* * *

Copyright © 2022 by Sutan Gading Fadhillah Nasution
