# **Laravel Starter For SPA and REST API**

This Starter App Uses  The Following Technology:

[Laravel](https://laravel.com/) as Api Back End

[Vue](https://vuejs.org//) and [Element](https://github.com/ElemeFE/element) or [Buefy](https://buefy.github.io/) For Front END

[Laradock](https://github.com/laradock/laradock) For Spinning Containers for Our Servers


If You :thumbsup: This Please :star2: This REPO

**Sharing is Caring**  :sparkling_heart:

It Would Give me More Motivation to Update this Repo Frequently.

    
**:clipboard: Table of Contents**

<!-- TOC -->

- [**Laravel Starter For SPA and REST API**](#laravel-starter-for-spa-and-rest-api)
    - [:heavy_exclamation_mark: Changelogs](#heavy_exclamation_mark-changelogs)
    - [:warning: Dev Machine Requirements :](#warning-dev-machine-requirements-)
    - [:wine_glass: Installation](#wine_glass-installation)
        - [:hammer: Using Simple ENV Set Up](#hammer-using-simple-env-set-up)
        - [:whale: Using Docker ENV Set Up](#whale-using-docker-env-set-up)
        - [:ocean: Deployment on Digital Ocean](#ocean-deployment-on-digital-ocean)
    - [:mailbox_with_mail: Use Post Man To Test API Endpoint](#mailbox_with_mail-use-post-man-to-test-api-endpoint)
    - [:minidisc: Modular State Management With Vuex](#minidisc-modular-state-management-with-vuex)
    - [:art: Styling Your APP](#art-styling-your-app)
        - [Using Buefy (Bulma)](#using-buefy-bulma)
        - [Using Element Ui](#using-element-ui)
    - [:dart: Upcoming Updates](#dart-upcoming-updates)
    - [:trophy: For Feature Request or :name_badge: Issue or :beetle: Bugs](#trophy-for-feature-request-or-name_badge-issue-or-beetle-bugs)
    - [:moneybag: Love This Repo You Can Directly Support me on Patreon](#moneybag-love-this-repo-you-can-directly-support-me-on-patreon)

<!-- /TOC -->



## :heavy_exclamation_mark: Changelogs

[View Change Log Here](./Docs/Changelog.md)

## :warning: Dev Machine Requirements :

 - [x] Prefered OS [Windows 10 Insider Build](https://insider.windows.com/Install/PC)/Linux/MacOS

 - [x] WSL Bash on Ubuntu or Mintty 
  - :candy: [Guide on Setting Up Mintty WSL](https://github.com/g0ld3lux/laravel-wsl-dev-machine):

 - [x] [VSCODE](https://code.visualstudio.com/) for Various Extension to help us In Our Development

- :rainbow: List of VSCODE Extensions
[See All Usefull VS Code Extension For This Repo](./Docs/VSExtension.md)
- configure your .vscode settings @ [./.vscode/settings.json](./.vscode/settings.json)

 - [x] [Docker Community Edition for Windows](https://store.docker.com/editions/community/docker-ce-desktop-windows) for Spinning Up Server Containers

 - [x] [NODEJS latest](https://nodejs.org/en/) for Your Asset Management (webpack and laravel mix)

## :wine_glass: Installation

### :hammer: Using Simple ENV Set Up

:closed_book: [Check Guide Here](./Docs/SimpleENVSetUp.md)


### :whale: Using Docker ENV Set Up
:closed_book: [Check Guide Here](./Docs/DockerENVSetUp.md)

### :ocean: Deployment on Digital Ocean
:closed_book: [Check Guide Here](https://gist.github.com/g0ld3lux/4145d031bccf66404dcdb78e9c30dc11)

## :mailbox_with_mail: Use Post Man To Test API Endpoint

:blue_book: [Check Guide Here](./Docs/API.md)

## :minidisc: Modular State Management With Vuex

:blue_book: [Check Guide Here](./Docs/StateManagement.md)

## :art: Styling Your APP

### Using Buefy (Bulma)
:orange_book: [Buefy Style Guide](./Docs/BuefyStyling.md)

### Using Element Ui
:orange_book: [Element Ui Style Guide](./Docs/ElementUi.md)

## :dart: Upcoming Updates
:memo: [TODOS](./Docs/Todo.md)

## :trophy: For Feature Request or :name_badge: Issue or :beetle: Bugs 
:octocat: [Request Here](https://github.com/g0ld3lux/laravel-vue-starter/issues/new)


## :moneybag: Love This Repo You Can Directly Support me on Patreon
[Become a Patron](https://www.patreon.com/codeitlikemiley)