<?php

namespace App\Notifications;

use Illuminate\Bus\Queueable;
use Illuminate\Notifications\Notification;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Notifications\Messages\MailMessage;

class PasswordResetNotification extends Notification
{
    use Queueable;

    // We Receive the Token
    public $token;
    /**
     * Create a new notification instance.
     *
     * @return void
     */

    // Inject Token
    public function __construct($token)
    {
        $this->token = $token;
    }

    /**
     * Get the notification's delivery channels.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function via($notifiable)
    {
        return ['mail'];
    }

    /**
     * Get the mail representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return \Illuminate\Notifications\Messages\MailMessage
     */
    public function toMail($notifiable)
    {
        return (new MailMessage)
                    ->subject('Have You Requested to Reset Your Password?')
                    ->greeting('Hi ' .$notifiable->first_name. ' '. $notifiable->last_name.'!')
                    ->line('Click the Button Below To Reset Your Password.')
                    ->action('Reset Your Password', url('forgotpassword/'.$this->token))
                    ->line('If You Did\'nt Request For This Password Reset. Just Ignore this Email.')
                    ;
    }

    /**
     * Get the array representation of the notification.
     *
     * @param  mixed  $notifiable
     * @return array
     */
    public function toArray($notifiable)
    {
        return [
            //
        ];
    }
}
