package fyne

import (
	"net/url"
	"testing"

	"github.com/stretchr/testify/assert"
)

type dummyApp struct{}

func (dummyApp) CloudProvider() CloudProvider {
	return nil
}

func (dummyApp) NewWindow(title string) Window {
	return nil
}

func (dummyApp) OpenURL(url *url.URL) error {
	return nil
}

func (dummyApp) Icon() Resource {
	return nil
}

func (dummyApp) SetIcon(Resource) {
}

func (dummyApp) Run() {
}

func (dummyApp) Quit() {
}

func (dummyApp) Driver() Driver {
	return nil
}

func (dummyApp) UniqueID() string {
	return "dummy"
}

func (dummyApp) SendNotification(*Notification) {
}

func (dummyApp) SetCloudProvider(CloudProvider) {
}

func (dummyApp) Settings() Settings {
	return nil
}

func (dummyApp) Storage() Storage {
	return nil
}

func (dummyApp) Preferences() Preferences {
	return nil
}

func (dummyApp) Lifecycle() Lifecycle {
	return nil
}

func (dummyApp) Metadata() AppMetadata {
	return AppMetadata{}
}

func TestSetCurrentApp(t *testing.T) {
	a := &dummyApp{}
	SetCurrentApp(a)

	assert.Equal(t, a, CurrentApp())
}
