/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime.registry;

import io.github.dddplus.ext.IDomainExtension;
import io.github.dddplus.ext.IIdentity;
import io.github.dddplus.ext.IPolicy;
import io.github.dddplus.runtime.BaseRouter;
import io.github.dddplus.runtime.interceptor.IExtensionInterceptor;
import io.github.dddplus.runtime.registry.BootstrapException;
import io.github.dddplus.runtime.registry.DomainArtifacts;
import io.github.dddplus.runtime.registry.DomainDef;
import io.github.dddplus.runtime.registry.DomainServiceDef;
import io.github.dddplus.runtime.registry.ExtensionDef;
import io.github.dddplus.runtime.registry.InterceptorDef;
import io.github.dddplus.runtime.registry.PartnerDef;
import io.github.dddplus.runtime.registry.PatternDef;
import io.github.dddplus.runtime.registry.PolicyDef;
import io.github.dddplus.runtime.registry.RouterDef;
import io.github.dddplus.runtime.registry.StepDef;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InternalIndexer {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InternalIndexer.class);
    private static final List<StepDef> emptySteps = Collections.emptyList();
    static final Map<String, DomainDef> domainDefMap = new HashMap<String, DomainDef>();
    static final Map<Class<? extends BaseRouter>, RouterDef> routerDefMap = new HashMap<Class<? extends BaseRouter>, RouterDef>();
    static final Map<String, Map<String, StepDef>> domainStepDefMap = new HashMap<String, Map<String, StepDef>>();
    static final Map<String, PatternDef> patternDefMap = new HashMap<String, PatternDef>();
    static final Map<Class<? extends IDomainExtension>, List<PatternDef>> sortedPatternMap = new HashMap<Class<? extends IDomainExtension>, List<PatternDef>>();
    static final Map<String, PartnerDef> partnerDefMap = new ConcurrentHashMap<String, PartnerDef>();
    static PartnerDef partnerDefPrepared = null;
    static final Map<Class<? extends IDomainExtension>, PolicyDef> policyDefMap = new HashMap<Class<? extends IDomainExtension>, PolicyDef>();
    static final Map<Class<? extends IPolicy>, PolicyDef> policyClazzMap = new HashMap<Class<? extends IPolicy>, PolicyDef>();
    static IExtensionInterceptor extensionInterceptor = null;

    private InternalIndexer() {
    }

    public static <T extends BaseRouter> T findRouter(@NonNull Class<? extends T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        RouterDef routerDef = routerDefMap.get(clazz);
        if (routerDef == null) {
            log.error("{} forgot to apply @Router, ArchitectureEnforcer turned off? indexed:{}", (Object)clazz.getCanonicalName(), routerDefMap.keySet());
            return null;
        }
        return (T)routerDef.getBaseRouterBean();
    }

    public static <Ext extends IDomainExtension> Class<Ext> extClazzOfPolicy(@NonNull Class<? extends IPolicy<Ext, ? extends IIdentity>> policyClazz) {
        if (policyClazz == null) {
            throw new NullPointerException("policyClazz is marked non-null but is null");
        }
        PolicyDef policyDef = policyClazzMap.get(policyClazz);
        return policyDef.getExtClazz();
    }

    public static Class<? extends IDomainExtension> getBaseRouterExtDeclaration(@NonNull Class<? extends BaseRouter> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        RouterDef routerDef = routerDefMap.get(clazz);
        if (routerDef == null) {
            log.error("{} not apply @Router, ArchitectureEnforcer turned off?", (Object)clazz.getCanonicalName());
            return null;
        }
        return routerDef.getExtClazz();
    }

    public static IExtensionInterceptor registeredInterceptor() {
        return extensionInterceptor;
    }

    @NonNull
    public static List<ExtensionDef> findEffectiveExtensions(@NonNull Class<? extends IDomainExtension> extClazz, @NonNull IIdentity identity, boolean firstStop) {
        ExtensionDef extensionDef;
        if (extClazz == null) {
            throw new NullPointerException("extClazz is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        LinkedList<ExtensionDef> effectiveExtensions = new LinkedList<ExtensionDef>();
        PolicyDef policyDef = policyDefMap.get(extClazz);
        if (policyDef != null) {
            ExtensionDef extensionByPolicy = policyDef.getExtension(identity);
            if (extensionByPolicy != null) {
                log.info("{} ident:{} use policy:{}", new Object[]{extClazz.getSimpleName(), identity, extensionByPolicy.getCode()});
            } else {
                log.info("{} ident:{} use null policy", (Object)extClazz.getSimpleName(), (Object)identity);
            }
            if (extensionByPolicy == null) {
                return effectiveExtensions;
            }
            effectiveExtensions.add(extensionByPolicy);
            return effectiveExtensions;
        }
        List<PatternDef> sortedPatternDefs = sortedPatternMap.get(extClazz);
        if (sortedPatternDefs != null && !sortedPatternDefs.isEmpty()) {
            log.debug("{} found patterns:{}", (Object)extClazz.getCanonicalName(), sortedPatternDefs);
            for (PatternDef patternDef : sortedPatternDefs) {
                if (!patternDef.match(identity)) continue;
                extensionDef = patternDef.getExtension(extClazz);
                if (extensionDef != null) {
                    effectiveExtensions.add(extensionDef);
                }
                if (!firstStop || effectiveExtensions.isEmpty()) continue;
                return effectiveExtensions;
            }
        }
        for (PartnerDef partnerDef : partnerDefMap.values()) {
            extensionDef = partnerDef.getExtension(extClazz);
            if (extensionDef == null || !partnerDef.match(identity)) continue;
            effectiveExtensions.add(extensionDef);
            break;
        }
        return effectiveExtensions;
    }

    @NonNull
    public static List<StepDef> findDomainSteps(@NonNull String activityCode, @NonNull List<String> stepCodeList) {
        if (activityCode == null) {
            throw new NullPointerException("activityCode is marked non-null but is null");
        }
        if (stepCodeList == null) {
            throw new NullPointerException("stepCodeList is marked non-null but is null");
        }
        Map<String, StepDef> childMap = domainStepDefMap.get(activityCode);
        if (childMap == null || childMap.isEmpty()) {
            log.error("found NO activity:{}", (Object)activityCode);
            return emptySteps;
        }
        LinkedList<StepDef> result = new LinkedList<StepDef>();
        for (String code : stepCodeList) {
            StepDef stepDef = childMap.get(code);
            if (stepDef == null) continue;
            result.add(stepDef);
        }
        if (result.size() != stepCodeList.size()) {
            log.warn("expected:{}, got:{} domain steps", (Object)stepCodeList.size(), (Object)result.size());
        }
        return result;
    }

    static void index(InterceptorDef interceptorDef) {
        if (extensionInterceptor != null) {
            throw BootstrapException.ofMessage("ExtensionInterceptor can only be registered once! " + extensionInterceptor.getClass().getCanonicalName());
        }
        extensionInterceptor = interceptorDef.getInterceptorBean();
    }

    static void index(StepDef stepDef) {
        Map<String, StepDef> childMap;
        if (!domainStepDefMap.containsKey(stepDef.getActivity())) {
            domainStepDefMap.put(stepDef.getActivity(), new HashMap());
        }
        if ((childMap = domainStepDefMap.get(stepDef.getActivity())).containsKey(stepDef.getCode())) {
            throw BootstrapException.ofMessage("duplicated step code: ", stepDef.getCode());
        }
        childMap.put(stepDef.getCode(), stepDef);
        log.debug("indexed {} ", (Object)stepDef);
    }

    static void index(DomainDef domainDef) {
        if (domainDefMap.containsKey(domainDef.getCode())) {
            throw BootstrapException.ofMessage("duplicated domain code: ", domainDef.getCode());
        }
        domainDefMap.put(domainDef.getCode(), domainDef);
        log.debug("indexed {}", (Object)domainDef);
    }

    static void index(RouterDef routerDef) {
        if (routerDefMap.containsKey(routerDef.getBaseRouterClazz())) {
            throw BootstrapException.ofMessage("duplicated router: ", routerDef.getBaseRouterBean().toString());
        }
        routerDefMap.put(routerDef.getBaseRouterClazz(), routerDef);
        log.debug("indexed {}", (Object)routerDef);
    }

    static void index(DomainServiceDef domainServiceDef) {
        if (!domainDefMap.containsKey(domainServiceDef.getDomain())) {
            throw BootstrapException.ofMessage("DomainService domain not found: ", domainServiceDef.getDomain());
        }
        log.debug("indexed {}", (Object)domainServiceDef);
    }

    static void index(ExtensionDef extensionDef) {
        if (policyDefMap.containsKey(extensionDef.getExtClazz())) {
            PolicyDef policyDef = policyDefMap.get(extensionDef.getExtClazz());
            policyDef.registerExtensionDef(extensionDef);
            log.debug("indexed {} on {}", (Object)extensionDef, (Object)policyDef);
            return;
        }
        if (patternDefMap.containsKey(extensionDef.getCode())) {
            PatternDef patternDef = patternDefMap.get(extensionDef.getCode());
            patternDef.registerExtensionDef(extensionDef);
            log.debug("indexed {} on {}", (Object)extensionDef, (Object)patternDef);
            return;
        }
        if (partnerDefMap.containsKey(extensionDef.getCode())) {
            PartnerDef partnerDef = partnerDefMap.get(extensionDef.getCode());
            partnerDef.registerExtensionDef(extensionDef);
            log.debug("indexed {} on {}", (Object)extensionDef, (Object)partnerDef);
            return;
        }
        if (!"_default__".equals(extensionDef.getCode())) {
            throw BootstrapException.ofMessage("invalid extension code: ", extensionDef.getCode());
        }
    }

    static void index(PatternDef patternDef) {
        if (patternDefMap.containsKey(patternDef.getCode())) {
            throw BootstrapException.ofMessage("duplicated pattern code: ", patternDef.getCode());
        }
        if (partnerDefMap.containsKey(patternDef.getCode())) {
            throw BootstrapException.ofMessage("pattern: ", patternDef.getCode(), " conflicts with partner code");
        }
        patternDefMap.put(patternDef.getCode(), patternDef);
        log.debug("indexed {}", (Object)patternDef);
    }

    static void index(PartnerDef partnerDef) {
        if (partnerDefMap.containsKey(partnerDef.getCode())) {
            throw BootstrapException.ofMessage("duplicated partner code: ", partnerDef.getCode());
        }
        if (patternDefMap.containsKey(partnerDef.getCode())) {
            throw BootstrapException.ofMessage("partner: ", partnerDef.getCode(), " conflicts with pattern code");
        }
        partnerDefMap.put(partnerDef.getCode(), partnerDef);
        log.debug("indexed {}", (Object)partnerDef);
    }

    static void index(PolicyDef policyDef) {
        if (policyDefMap.containsKey(policyDef.getExtClazz())) {
            throw BootstrapException.ofMessage("1 Policy decides only 1 Extension:", policyDef.policyName(), ", ext:", policyDef.getExtClazz().getCanonicalName());
        }
        policyDefMap.put(policyDef.getExtClazz(), policyDef);
        log.debug("indexed {}", (Object)policyDef);
        policyClazzMap.put(policyDef.getPolicyClazz(), policyDef);
        log.debug("indexed ext for {}", (Object)policyDef.getPolicyBean());
    }

    static void postIndexing() {
        for (PatternDef patternDef : patternDefMap.values()) {
            for (Class<? extends IDomainExtension> extClazz : patternDef.extClazzSet()) {
                if (!sortedPatternMap.containsKey(extClazz)) {
                    sortedPatternMap.put(extClazz, new ArrayList());
                }
                sortedPatternMap.get(extClazz).add(patternDef);
            }
        }
        for (List list : sortedPatternMap.values()) {
            Collections.sort(list, (p1, p2) -> p1.getPriority() - p2.getPriority());
        }
        patternDefMap.clear();
        DomainArtifacts.getInstance().export();
    }

    static void prepare(PartnerDef partnerDef) {
        partnerDefPrepared = partnerDef;
    }

    static void prepare(ExtensionDef extensionDef) {
        if (partnerDefPrepared == null) {
            throw BootstrapException.ofMessage("Partner must reside in Plugin Jar with its extensions!");
        }
        partnerDefPrepared.registerExtensionDef(extensionDef);
    }

    static void commitPartner() {
        partnerDefMap.put(partnerDefPrepared.getCode(), partnerDefPrepared);
        log.warn("Partner({}) committed", (Object)partnerDefPrepared.getCode());
        partnerDefPrepared = null;
        DomainArtifacts.getInstance().export();
    }
}

