/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime;

import io.github.dddplus.model.IDomainModel;
import io.github.dddplus.runtime.DDD;
import io.github.dddplus.step.IDomainStep;
import io.github.dddplus.step.IReviseStepsException;
import io.github.dddplus.step.IRevokableDomainStep;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.RejectedExecutionException;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.aop.support.AopUtils;
import org.springframework.core.ResolvableType;
import org.springframework.scheduling.SchedulingTaskExecutor;

@Deprecated
public abstract class StepsExecTemplate<Step extends IDomainStep, Model extends IDomainModel> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StepsExecTemplate.class);
    private static final List<String> emptyRevisedSteps = Collections.emptyList();
    private static final Set<String> emptyAsyncSteps = Collections.emptySet();
    private static final int MAX_STEP_REVISIONS = 100;

    protected void beforeStep(Step step, Model model) {
    }

    protected void afterStep(Step step, Model model) {
    }

    public final void execute(String activityCode, List<String> stepCodes, Model model) throws RuntimeException {
        this.execute(activityCode, stepCodes, model, null, emptyAsyncSteps);
    }

    public final void execute(String activityCode, List<String> stepCodes, Model model, SchedulingTaskExecutor taskExecutor, Set<String> asyncStepCodes) throws RuntimeException {
        if (stepCodes == null || stepCodes.isEmpty()) {
            log.warn("Empty steps of activity:{} on {}", (Object)activityCode, model);
            return;
        }
        Stack<IRevokableDomainStep> executedSteps = new Stack<IRevokableDomainStep>();
        int stepRevisions = 0;
        while (++stepRevisions < 100 && !(stepCodes = this.executeSteps(activityCode, stepCodes, executedSteps, model, taskExecutor, asyncStepCodes)).isEmpty()) {
            log.info("revised steps:{}", stepCodes);
        }
        if (stepRevisions == 100) {
            log.error("Steps revision seem to encounter dead loop, abort after {} model:{}", (Object)stepRevisions, model);
            throw new RuntimeException("Seems steps dead loop, abort after 100");
        }
    }

    private List<String> executeSteps(String activityCode, List<String> stepCodes, Stack<IRevokableDomainStep> executedSteps, Model model, SchedulingTaskExecutor taskExecutor, Set<String> asyncStepCodes) throws RuntimeException {
        if (asyncStepCodes == null || taskExecutor == null) {
            asyncStepCodes = emptyAsyncSteps;
        }
        List<IDomainStep> steps = DDD.findSteps(activityCode, stepCodes);
        String currentStepCode = null;
        try {
            for (IDomainStep step : steps) {
                currentStepCode = step.stepCode();
                this.beforeStep(step, model);
                if (asyncStepCodes.contains(currentStepCode)) {
                    this.asyncExecuteStep(taskExecutor, step, model);
                } else {
                    step.execute(model);
                }
                this.afterStep(step, model);
                if (!(step instanceof IRevokableDomainStep) || asyncStepCodes.contains(currentStepCode)) continue;
                executedSteps.push((IRevokableDomainStep)step);
            }
        }
        catch (Exception cause) {
            if (cause instanceof IReviseStepsException) {
                return ((IReviseStepsException)cause).subsequentSteps();
            }
            log.error("Step:{}.{} fails for {}", new Object[]{activityCode, currentStepCode, stepCodes, cause});
            if (cause instanceof RejectedExecutionException) {
                throw (RejectedExecutionException)cause;
            }
            if (!executedSteps.empty() && cause instanceof RuntimeException) {
                if (cause.getClass() == this.resolveStepExType()) {
                    this.safeRollbackExecutedSteps(model, (RuntimeException)cause, executedSteps);
                } else {
                    log.debug("will not rollback, {} thrown", (Object)cause.getClass().getCanonicalName());
                }
            }
            throw cause;
        }
        return emptyRevisedSteps;
    }

    private void asyncExecuteStep(SchedulingTaskExecutor taskExecutor, Step step, Model model) {
        Map mdcContext = MDC.getCopyOfContextMap();
        taskExecutor.execute(() -> {
            MDC.setContextMap((Map)mdcContext);
            try {
                step.execute(model);
            }
            finally {
                MDC.clear();
            }
        });
    }

    private Class resolveStepExType() {
        Class<?> thisClass = AopUtils.isAopProxy((Object)this) ? AopUtils.getTargetClass((Object)this) : this.getClass();
        ResolvableType stepsExecType = ResolvableType.forClass(thisClass);
        ResolvableType templateType = stepsExecType.getSuperType();
        while (templateType.getGenerics().length == 0) {
            templateType = templateType.getSuperType();
        }
        ResolvableType stepType = templateType.getGeneric(new int[]{0});
        for (ResolvableType stepInterfaceType : stepType.getInterfaces()) {
            if (!IDomainStep.class.isAssignableFrom(stepInterfaceType.resolve())) continue;
            return stepInterfaceType.getGeneric(new int[]{1}).resolve();
        }
        log.error("Cannot tell Step.Ex type for {}", this.getClass());
        return null;
    }

    private void safeRollbackExecutedSteps(Model model, RuntimeException cause, Stack<IRevokableDomainStep> executedSteps) {
        while (!executedSteps.isEmpty()) {
            IRevokableDomainStep executedStep = executedSteps.pop();
            try {
                executedStep.rollback(model, cause);
            }
            catch (Throwable ignored) {
                log.error("step:{} rollback err ignored, model:{}", new Object[]{executedStep.stepCode(), model, ignored});
            }
        }
    }
}

