/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime;

import java.util.List;
import java.util.function.Predicate;
import lombok.NonNull;

public interface IReducer<R> {
    public R reduce(List<R> var1);

    public boolean shouldStop(List<R> var1);

    public static <R> IReducer<R> stopOnFirstMatch(final @NonNull Predicate<R> predicate) {
        if (predicate == null) {
            throw new NullPointerException("predicate is marked non-null but is null");
        }
        return new IReducer<R>(){

            @Override
            public R reduce(List<R> accumulatedResults) {
                Object tail = this.tail(accumulatedResults);
                if (tail == null) {
                    return null;
                }
                return tail;
            }

            @Override
            public boolean shouldStop(List<R> accumulatedResults) {
                Object tail = this.tail(accumulatedResults);
                if (tail == null) {
                    return false;
                }
                return predicate.test(tail);
            }

            private R tail(List<R> accumulatedResults) {
                if (accumulatedResults == null || accumulatedResults.isEmpty()) {
                    return null;
                }
                return accumulatedResults.get(accumulatedResults.size() - 1);
            }
        };
    }

    public static <R> IReducer<R> allOf() {
        return new IReducer<R>(){

            @Override
            public R reduce(List<R> accumulatedResults) {
                return null;
            }

            @Override
            public boolean shouldStop(List<R> accumulatedResults) {
                return false;
            }
        };
    }

    @Deprecated
    public static <R> IReducer<R> allOf(final Predicate<R> predicate) {
        return new IReducer<R>(){

            @Override
            public R reduce(List<R> accumulatedResults) {
                if (predicate == null) {
                    return null;
                }
                for (Object r : accumulatedResults) {
                    if (!predicate.test(r)) continue;
                    return r;
                }
                return null;
            }

            @Override
            public boolean shouldStop(List<R> accumulatedResults) {
                return false;
            }
        };
    }
}

