/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime;

import io.github.dddplus.ext.IDomainExtension;
import io.github.dddplus.ext.IIdentity;
import io.github.dddplus.runtime.ExtTimeoutException;
import io.github.dddplus.runtime.IExceptionWeakLogging;
import io.github.dddplus.runtime.IReducer;
import io.github.dddplus.runtime.NamedThreadFactory;
import io.github.dddplus.runtime.interceptor.ExtensionContext;
import io.github.dddplus.runtime.interceptor.IExtensionInterceptor;
import io.github.dddplus.runtime.registry.ExtensionDef;
import io.github.dddplus.runtime.registry.InternalIndexer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

class ExtensionInvocationHandler<Ext extends IDomainExtension, R>
implements InvocationHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExtensionInvocationHandler.class);
    private static ExecutorService extInvokeTimerExecutor = new ThreadPoolExecutor(10, System.getProperty("invokeExtMaxPoolSize") != null ? Integer.valueOf(System.getProperty("invokeExtMaxPoolSize")) : 50, 5L, TimeUnit.MINUTES, new SynchronousQueue<Runnable>(), new NamedThreadFactory("ExtInvokeTimer", false));
    private final Class<Ext> extInterface;
    private final IIdentity identity;
    private final IReducer<R> reducer;
    private final Ext defaultExt;
    private final IExtensionInterceptor interceptor;
    private final int timeoutInMs;

    ExtensionInvocationHandler(@NonNull Class<Ext> extInterface, @NonNull IIdentity identity, IReducer<R> reducer, Ext defaultExt, IExtensionInterceptor interceptor, int timeoutInMs) {
        if (extInterface == null) {
            throw new NullPointerException("extInterface is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        this.extInterface = extInterface;
        this.identity = identity;
        this.reducer = reducer;
        this.defaultExt = defaultExt;
        this.interceptor = interceptor;
        this.timeoutInMs = timeoutInMs;
    }

    Ext createProxy() {
        return (Ext)((IDomainExtension)Proxy.newProxyInstance(this.extInterface.getClassLoader(), new Class[]{this.extInterface}, (InvocationHandler)this));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        List<ExtensionDef> effectiveExts = InternalIndexer.findEffectiveExtensions(this.extInterface, this.identity, this.reducer == null);
        log.debug("{} effective {}", (Object)this.extInterface.getCanonicalName(), effectiveExts);
        if (effectiveExts.isEmpty()) {
            if (this.defaultExt == null) {
                log.debug("found NO ext instance {} on {}, HAS TO return null", (Object)this.extInterface.getCanonicalName(), (Object)this.identity);
                return null;
            }
            log.debug("use default {}", this.defaultExt);
            effectiveExts.add(new ExtensionDef((IDomainExtension)this.defaultExt));
        }
        ArrayList<Object> accumulatedResults = new ArrayList<Object>(effectiveExts.size());
        Object result = null;
        for (ExtensionDef extensionDef : effectiveExts) {
            result = this.invokeExtension(extensionDef, method, args);
            accumulatedResults.add(result);
            if (this.reducer != null && !this.reducer.shouldStop(accumulatedResults)) continue;
            break;
        }
        if (this.reducer != null) {
            return this.reducer.reduce(accumulatedResults);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private R invokeExtension(ExtensionDef extensionDef, Method method, Object[] args) throws Throwable {
        try {
            ExtensionContext context = null;
            if (this.interceptor != null) {
                context = new ExtensionContext(extensionDef.getCode(), extensionDef.getExtensionBean(), method, args);
                this.interceptor.beforeInvocation(context);
            }
            try {
                R r = this.invokeExtensionMethod(extensionDef, method, args);
                return r;
            }
            finally {
                if (this.interceptor != null) {
                    this.interceptor.afterInvocation(context);
                }
            }
        }
        catch (InvocationTargetException e) {
            Throwable actualException = e.getTargetException();
            if (actualException instanceof IExceptionWeakLogging) {
                log.warn("{} code:{} ex:{}", new Object[]{this.extInterface.getCanonicalName(), extensionDef.getCode(), actualException.getMessage()});
                throw actualException;
            }
            log.error("{} code:{}", new Object[]{this.extInterface.getCanonicalName(), extensionDef.getCode(), e.getTargetException()});
            throw actualException;
        }
        catch (TimeoutException e) {
            log.error("timed out:{}ms, {} method:{} args:{}", new Object[]{this.timeoutInMs, extensionDef.getExtensionBean(), method.getName(), args});
            throw new ExtTimeoutException(this.timeoutInMs);
        }
        catch (RejectedExecutionException e) {
            log.error("ExtInvokeTimer thread pool FULL:{}", (Object)e.getMessage());
            throw e;
        }
        catch (Throwable e) {
            log.error("{} code:{} unexpected", new Object[]{this.extInterface.getCanonicalName(), extensionDef.getCode(), e});
            throw e;
        }
    }

    private R invokeExtensionMethod(ExtensionDef extensionDef, Method method, Object[] args) throws Throwable {
        IDomainExtension extInstance = extensionDef.getExtensionBean();
        if (this.timeoutInMs > 0) {
            return this.invokeExtensionMethodWithTimeout(extInstance, method, args, this.timeoutInMs);
        }
        Object result = method.invoke((Object)extInstance, args);
        log.debug("{} method:{} args:{}, result:{}", new Object[]{extInstance, method.getName(), args, result});
        return (R)result;
    }

    private R invokeExtensionMethodWithTimeout(IDomainExtension extInstance, Method method, Object[] args, int timeoutInMs) throws Throwable {
        Map mdcContext = MDC.getCopyOfContextMap();
        Future<Object> future = extInvokeTimerExecutor.submit(() -> {
            MDC.setContextMap((Map)mdcContext);
            try {
                Object object = method.invoke((Object)extInstance, args);
                return object;
            }
            finally {
                MDC.clear();
            }
        });
        try {
            Object result = future.get(timeoutInMs, TimeUnit.MILLISECONDS);
            log.debug("{} method:{} args:{}, result:{}", new Object[]{extInstance, method.getName(), args, result});
            return (R)result;
        }
        catch (TimeoutException e) {
            if (!future.isCancelled()) {
                future.cancel(true);
            }
            throw e;
        }
        catch (ExecutionException e) {
            throw e.getCause() != null ? e.getCause() : e;
        }
    }
}

