/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime;

import io.github.dddplus.ext.IDomainExtension;
import io.github.dddplus.ext.IIdentity;
import io.github.dddplus.model.IDomainService;
import io.github.dddplus.runtime.ExtensionInvocationHandler;
import io.github.dddplus.runtime.IReducer;
import io.github.dddplus.runtime.registry.InternalIndexer;
import lombok.NonNull;

public abstract class BaseRouter<Ext extends IDomainExtension, Identity extends IIdentity>
implements IDomainService {
    protected Ext forEachExtension(@NonNull Identity identity) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        return this.forEachExtension(identity, IReducer.allOf());
    }

    protected <R> Ext forEachExtension(@NonNull Identity identity, @NonNull IReducer<R> reducer) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (reducer == null) {
            throw new NullPointerException("reducer is marked non-null but is null");
        }
        return this.forEachExtension(identity, 0, reducer);
    }

    private <R> Ext forEachExtension(@NonNull Identity identity, int timeoutInMs, @NonNull IReducer<R> reducer) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        if (reducer == null) {
            throw new NullPointerException("reducer is marked non-null but is null");
        }
        Class<? extends IDomainExtension> extClazz = InternalIndexer.getBaseRouterExtDeclaration(this.getClass());
        return (Ext)this.findExtension((Class<Ext>)extClazz, identity, reducer, this.defaultExtension(identity), timeoutInMs);
    }

    protected Ext firstExtension(@NonNull Identity identity) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        return this.firstExtension(identity, 0);
    }

    protected Ext firstExtension(@NonNull Identity identity, int timeoutInMs) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        Class<? extends IDomainExtension> extClazz = InternalIndexer.getBaseRouterExtDeclaration(this.getClass());
        return (Ext)this.findExtension((Class<Ext>)extClazz, identity, (IReducer<R>)null, this.defaultExtension(identity), timeoutInMs);
    }

    public abstract Ext defaultExtension(@NonNull Identity var1);

    private <Ext extends IDomainExtension, R> Ext findExtension(@NonNull Class<Ext> extClazz, @NonNull Identity identity, IReducer<R> reducer, Ext defaultExt, int timeoutInMs) {
        if (extClazz == null) {
            throw new NullPointerException("extClazz is marked non-null but is null");
        }
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        ExtensionInvocationHandler<Ext, R> proxy = new ExtensionInvocationHandler<Ext, R>(extClazz, (IIdentity)identity, reducer, defaultExt, InternalIndexer.registeredInterceptor(), timeoutInMs);
        return proxy.createProxy();
    }
}

