/*
 * Decompiled with CFR 0.152.
 */
package io.github.dddplus.runtime;

import io.github.dddplus.ext.IIdentity;
import io.github.dddplus.ext.IIdentityResolver;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BasePattern
implements IIdentityResolver<IIdentity> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BasePattern.class);
    private static final String MATCH_METHOD_NAME = "match";
    private static final Map<String, Method> matchMethodCache = new ConcurrentHashMap<String, Method>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final boolean match(@NonNull IIdentity identity) {
        if (identity == null) {
            throw new NullPointerException("identity is marked non-null but is null");
        }
        Class<?> patternClazz = this.getClass();
        Class<?> identityClazz = identity.getClass();
        String cacheKey = patternClazz.getName() + ":" + identityClazz.getName();
        Method matchMethod = matchMethodCache.get(cacheKey);
        if (matchMethod == null) {
            log.debug("pattern match method miss: {}", (Object)cacheKey);
            try {
                Class<BasePattern> clazz = BasePattern.class;
                synchronized (BasePattern.class) {
                    matchMethod = matchMethodCache.get(cacheKey);
                    if (matchMethod == null) {
                        log.debug("get pattern match method with reflection: {}", (Object)cacheKey);
                        matchMethod = this.getMatchMethod(patternClazz, identityClazz);
                        matchMethodCache.put(cacheKey, matchMethod);
                    } else {
                        log.debug("got pattern after double check: {}", (Object)cacheKey);
                    }
                    // ** MonitorExit[var6_6] (shouldn't be in output)
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(patternClazz.getName() + " match method " + e.getClass().getSimpleName() + " " + e.getMessage(), e);
            }
        } else {
            log.debug("pattern match method hit: {}", (Object)cacheKey);
        }
        {
            try {
                matchMethod.setAccessible(true);
                log.debug("invoking {}.match({})", (Object)patternClazz.getSimpleName(), (Object)identityClazz.getSimpleName());
                boolean matched = (Boolean)matchMethod.invoke((Object)this, identity);
                if (matched) {
                    log.info("{} Pattern matched for {}", (Object)patternClazz.getSimpleName(), (Object)identity);
                }
                return matched;
            }
            catch (InvocationTargetException e) {
                Throwable actualException = e.getCause();
                if (actualException == null) {
                    throw new IllegalStateException(patternClazz.getName() + ".match(" + identityClazz.getSimpleName() + ") weirdly failed. See cause: " + e.getMessage(), e);
                }
                if (actualException instanceof RuntimeException) {
                    throw (RuntimeException)actualException;
                }
                throw new IllegalStateException(patternClazz.getName() + ".match(" + identityClazz.getSimpleName() + ") failed. See cause: " + actualException.getMessage(), actualException);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(patternClazz.getName() + ".match(" + identityClazz.getSimpleName() + ") access failed. See cause: " + e.getMessage(), e);
            }
        }
    }

    private Method getMatchMethod(Class patternClazz, Class modelClazz) throws NoSuchMethodException {
        Method method;
        try {
            method = patternClazz.getDeclaredMethod(MATCH_METHOD_NAME, modelClazz);
        }
        catch (Exception e) {
            method = patternClazz.getMethod(MATCH_METHOD_NAME, modelClazz);
        }
        return method;
    }
}

