# Yakitty: a chat app for everyone :point_right: [bit.ly/yakitty](http://bit.ly/yakitty)

<a rel="license" href="http://creativecommons.org/licenses/by-sa/4.0">
  <img alt="Creative Commons Licence" style="border-width:0" src="https://i.creativecommons.org/l/by-sa/4.0/80x15.png" />
</a>

## What's this?

>yak (verb): to talk persistently. Also, a large long-haired wild or domesticated ox :ox:

Yakitty is a simple [React Native](https://facebook.github.io/react-native) tutorial for building smooth-running Android and iOS apps using [JavaScript](https://developer.mozilla.org/en-US/docs/Web/javascript). If you're interested, **have a look at the [requirements](https://github.com/frnkly/react-native-tutorial/blob/stable/tutorials/requirements.md)** before getting started.

To get the most out of this tutorial, you should have a basic understanding of [JavaScript](https://developer.mozilla.org/en-US/docs/Web/javascript). Knowing the basics of [React](https://reactjs.org/tutorial/tutorial.html) will be helpful too, but it's not required.

This is meant to give you a taste of what you can do with React Native. I encourage you to [read the docs](https://facebook.github.io/react-native/docs/getting-started.html) to get a more complete understanding of the framework. This is also a work in progress. Feel free to [contribute](https://github.com/frnkly/react-native-tutorial/blob/stable/docs/contributing.md) :)

# First things first

This tutorial is split up into modules, each taking roughly 30 to 60 minutes to complete. You'll find all the modules at the end of this page.

## What are we building?

We're going to build an Android or iOS app _with our bear hands_. :bear:

## What will we learn?

We're going to use renowned libraries such as [React](https://reactjs.org) in order to become renowned developers. We'll also learn how to integrate 3rd party APIs and organize our codebase the way master code crafters do.

## What is React Native?

[React Native](https://facebook.github.io/react-native) is a framework built on [React](https://reactjs.org) for building native mobile apps using JavaScript. Native means your app will look and feel like any real app that was written in Java or Objective-C, the languages for developing Android and iOS apps.

This is different from tools like [PhoneGap](https://phonegap.com) or [Ionic](https://ionicframework.com) which create apps that run in your phone's "Web View" (or browser). But it _is_ similar to frameworks such as [NativeScript](https://www.nativescript.org) or [Flutter](https://flutter.io).

## What you'll need

Did you skip the [requirements](https://github.com/frnkly/react-native-tutorial/blob/stable/tutorials/requirements.md) page? Here's the CliffsNotes version:

- A computer (Windows, Mac or Linux).
- A [code editor](https://alternativeto.net/software/sublime-text) such as [Visual Studio Code](https://code.visualstudio.com) or [Sublime Text](https://sublimetext.com).
- If you're on Windows, I recommend getting the [Cmder](http://cmder.net) console emulator.
- [Node](https://nodejs.org/en) and [Expo](https://docs.expo.io/versions/latest/introduction/installation)
- An Android phone (4.4+) or iPhone (iOS 9+) with the Expo Client app installed.

I'll even provide you these QR codes for your convenience, so you don't have to search for the app in the Play Store/App Store. Just point your camera and download the app:

<table>
  <tr>
    <td align="center">Expo for Android</td>
    <td align="center">Expo for iOS</td>
  </tr>
  <tr>
    <td align="center">
      <a target="_blank" href="https://play.google.com/store/apps/details?id=host.exp.exponent">
        <img src="https://raw.githubusercontent.com/frnkly/react-native-tutorial/stable/tutorials/qr-code-expo-android.png" />
      </a>
    </td>
    <td align="center">
      <a target="_blank" href="https://itunes.apple.com/us/app/expo-client/id982107779">
        <img src="https://raw.githubusercontent.com/frnkly/react-native-tutorial/stable/tutorials/qr-code-expo-ios.png" />
      </a>
    </td>
  </tr>
</table>

# Modules

- [Requirements](https://github.com/frnkly/react-native-tutorial/blob/stable/tutorials/requirements.md)
- [Intro to React Native](https://github.com/frnkly/react-native-tutorial/blob/stable/tutorials/intro.md)
- [Creating components](https://github.com/frnkly/react-native-tutorial/blob/stable/tutorials/creating-components.md)
- [Using state and integrating 3rd party libraries (Moment.js)](https://github.com/frnkly/react-native-tutorial/blob/stable/tutorials/state.md)
- [Integrating 3rd party APIs (Chatkit)](https://github.com/frnkly/react-native-tutorial/blob/stable/tutorials/apis.md)
- Publishing to the Play Store/App Store (TODO)
- Supporting languages other than English (TODO)
- Integrating layout libraries, e.g. yogalayout.com (TODO)
- [Resources](https://github.com/frnkly/react-native-tutorial/blob/stable/tutorials/resources.md)

Have any requests? Let me know :point_right: [bit.ly/yakitty-feedback](http://bit.ly/yakitty-feedback)

_This content is licensed under a [Creative Commons Attribution-ShareAlike 4.0 International (CC BY-SA 4.0)](https://creativecommons.org/licenses/by-sa/4.0) license._
