# Angular

## Installation

To add crayons to your Angular app, install the package from npm.

`npm install @freshworks/crayons@v4`

## Usage

### Event Handling

Crayons components emit custom events. For example, the button component emits the `fwClick` event when it is getting clicked. In Angular, you can listen for the event using `(fwClick)`.

### Example Lazy Load

```html live
<iframe
  src="https://codesandbox.io/embed/angular-example-crayons-v3-5zh1t3?fontsize=14&hidenavigation=1&theme=dark"
  style="width:100%; height:500px; border:0; border-radius: 4px; overflow:hidden;"
  title="angular-example-crayons-v3"
  allow="accelerometer; ambient-light-sensor; camera; encrypted-media; geolocation; gyroscope; hid; microphone; midi; payment; usb; vr; xr-spatial-tracking"
  sandbox="allow-forms allow-modals allow-popups allow-presentation allow-same-origin allow-scripts"
></iframe>
```

### Example Tree Shakeable

```html live
<iframe
  src="https://codesandbox.io/embed/angular-example-crayons-v3-treeshakeable-1w6v9q?fontsize=14&hidenavigation=1&theme=dark"
  style="width:100%; height:500px; border:0; border-radius: 4px; overflow:hidden;"
  title="angular-example-crayons-v3-treeshakeable"
  allow="accelerometer; ambient-light-sensor; camera; encrypted-media; geolocation; gyroscope; hid; microphone; midi; payment; usb; vr; xr-spatial-tracking"
  sandbox="allow-forms allow-modals allow-popups allow-presentation allow-same-origin allow-scripts"
></iframe>
```
